<!-- THIS WHOLE FILE IS AUTOGENERATED. DO NOT MODIFY IT. See scripts/generate-docs.sh -->




# heap

## **glibc**


Glibc version for heap heuristics resolution (e.g. 2.31).



**Default:** ''  

----------

## **global-max-fast**


The address of global_max_fast.



**Default:** '0'  

----------

## **heap-corruption-check-limit**


Amount of chunks to traverse for the bin corruption check.

The bins are traversed both forwards and backwards.

**Default:** 64  

----------

## **heap-dereference-limit**


Number of chunks to dereference in each bin.



**Default:** 8  

----------

## **main-arena**


The address of main_arena.



**Default:** '0'  

----------

## **mp**


The address of mp_.



**Default:** '0'  

----------

## **resolve-heap-via-heuristic**

=== "GDB"

     The strategy to resolve heap via heuristic.

    Values explained:

    + `auto` - Pwndbg will try to use heuristics if debug symbols are missing
    + `force` - Pwndbg will always try to use heuristics, even if debug symbols are available
    + `never` - Pwndbg will never use heuristics to resolve the heap

    If the output of the heap related command produces errors with heuristics, you
    can try manually setting the libc symbol addresses.
    For this, see the `heap_config` command output and set the `main_arena`, `mp_`,
    `global_max_fast`, `tcache` and `thread_arena` addresses.

    Note: Pwndbg will generate more reliable results with proper debug symbols.
    Therefore, when debug symbols are missing, you should try to install them first
    if you haven't already.

    They can probably be installed via the package manager of your choice.
    See also: https://sourceware.org/gdb/onlinedocs/gdb/Separate-Debug-Files.html .

    E.g. on Ubuntu/Debian you might need to do the following steps (for 64-bit and
    32-bit binaries):
    ```bash
    sudo apt-get install libc6-dbg
    sudo dpkg --add-architecture i386
    sudo apt-get install libc-dbg:i386
    ```
    If you used setup.sh on Arch based distro you'll need to do a power cycle or set
    environment variable manually like this:
    ```bash
    export DEBUGINFOD_URLS=https://debuginfod.archlinux.org
    ```

    In addition, even you have the debug symbols of libc, you might still see the
    following warning when debugging a multi-threaded program:
    ```
    warning: Unable to find libthread_db matching inferior's thread library, thread
    debugging will not be available.
    ```

    You'll need to ensure that the correct `libthread_db.so` is loaded. To do this,
    set the search path using:
    ```
    set libthread-db-search-path <path having correct libthread_db.so>
    ```
    Then, restart your program to enable proper thread debugging.

    **Default:** 'auto'  
    **Valid values:** 'auto', 'force', 'never'
=== "LLDB"

     The strategy to resolve heap via heuristic.

    Values explained:

    + `auto` - Pwndbg will try to use heuristics if debug symbols are missing
    + `force` - Pwndbg will always try to use heuristics, even if debug symbols are available
    + `never` - Pwndbg will never use heuristics to resolve the heap

    If the output of the heap related command produces errors with heuristics, you
    can try manually setting the libc symbol addresses.
    For this, see the `heap_config` command output and set the `main_arena`, `mp_`,
    `global_max_fast`, `tcache` and `thread_arena` addresses.

    Note: Pwndbg will generate more reliable results with proper debug symbols.
    Therefore, when debug symbols are missing, you should try to install them first
    if you haven't already.

    They can probably be installed via the package manager of your choice.
    See also: https://sourceware.org/gdb/onlinedocs/gdb/Separate-Debug-Files.html .

    E.g. on Ubuntu/Debian you might need to do the following steps (for 64-bit and
    32-bit binaries):
    ```bash
    sudo apt-get install libc6-dbg
    sudo dpkg --add-architecture i386
    sudo apt-get install libc-dbg:i386
    ```
    If you used setup.sh on Arch based distro you'll need to do a power cycle or set
    environment variable manually like this:
    ```bash
    export DEBUGINFOD_URLS=https://debuginfod.archlinux.org
    ```

    **Default:** 'auto'  
    **Valid values:** 'auto', 'force', 'never'

----------

## **tcache**


The address pointed by tcache.



**Default:** '0'  

----------

## **thread-arena**


The address pointed by thread_arena.



**Default:** '0'  

----------
