/*
 * Decompiled with CFR 0.152.
 */
package com.github.difflib.patch;

import com.github.difflib.algorithm.Change;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.ChangeDelta;
import com.github.difflib.patch.Chunk;
import com.github.difflib.patch.ConflictOutput;
import com.github.difflib.patch.DeleteDelta;
import com.github.difflib.patch.EqualDelta;
import com.github.difflib.patch.InsertDelta;
import com.github.difflib.patch.PatchFailedException;
import com.github.difflib.patch.VerifyChunk;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;

public final class Patch<T>
implements Serializable {
    private final List<AbstractDelta<T>> deltas;
    public final ConflictOutput<T> CONFLICT_PRODUCES_EXCEPTION = (verifyChunk, delta, result2) -> {
        throw new PatchFailedException("could not apply patch due to " + verifyChunk.toString());
    };
    public static final ConflictOutput<String> CONFLICT_PRODUCES_MERGE_CONFLICT = (verifyChunk, delta, result2) -> {
        ArrayList<Object> orgData;
        if (result2.size() > delta.getSource().getPosition()) {
            orgData = new ArrayList<Object>();
            for (int i = 0; i < delta.getSource().size(); ++i) {
                orgData.add(result2.get(delta.getSource().getPosition()));
                result2.remove(delta.getSource().getPosition());
            }
        } else {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        orgData.add(0, "<<<<<< HEAD");
        orgData.add("======");
        orgData.addAll(delta.getSource().getLines());
        orgData.add(">>>>>>> PATCH");
        result2.addAll(delta.getSource().getPosition(), orgData);
    };
    private ConflictOutput<T> conflictOutput = this.CONFLICT_PRODUCES_EXCEPTION;

    public Patch() {
        this(10);
    }

    public Patch(int estimatedPatchSize) {
        this.deltas = new ArrayList<AbstractDelta<T>>(estimatedPatchSize);
    }

    public List<T> applyTo(List<T> target) throws PatchFailedException {
        ArrayList<T> result2 = new ArrayList<T>(target);
        ListIterator<AbstractDelta<T>> it = this.getDeltas().listIterator(this.deltas.size());
        while (it.hasPrevious()) {
            AbstractDelta<T> delta = it.previous();
            VerifyChunk valid = delta.verifyAntApplyTo(result2);
            if (valid == VerifyChunk.OK) continue;
            this.conflictOutput.processConflict(valid, delta, result2);
        }
        return result2;
    }

    public List<T> applyFuzzy(List<T> target, int maxFuzz) throws PatchFailedException {
        PatchApplyingContext ctx = new PatchApplyingContext(new ArrayList<T>(target), maxFuzz);
        int lastPatchDelta = 0;
        for (AbstractDelta delta : this.getDeltas()) {
            ctx.defaultPosition = delta.getSource().getPosition() + lastPatchDelta;
            int patchPosition = this.findPositionFuzzy(ctx, delta);
            if (0 <= patchPosition) {
                delta.applyFuzzyToAt(ctx.result, ctx.currentFuzz, patchPosition);
                lastPatchDelta = patchPosition - delta.getSource().getPosition();
                ctx.lastPatchEnd = delta.getSource().last() + lastPatchDelta;
                continue;
            }
            this.conflictOutput.processConflict(VerifyChunk.CONTENT_DOES_NOT_MATCH_TARGET, delta, ctx.result);
        }
        return ctx.result;
    }

    private int findPositionFuzzy(PatchApplyingContext<T> ctx, AbstractDelta<T> delta) throws PatchFailedException {
        for (int fuzz = 0; fuzz <= ctx.maxFuzz; ++fuzz) {
            ctx.currentFuzz = fuzz;
            int foundPosition = this.findPositionWithFuzz(ctx, delta, fuzz);
            if (foundPosition < 0) continue;
            return foundPosition;
        }
        return -1;
    }

    private int findPositionWithFuzz(PatchApplyingContext<T> ctx, AbstractDelta<T> delta, int fuzz) throws PatchFailedException {
        if (delta.getSource().verifyChunk(ctx.result, fuzz, ctx.defaultPosition) == VerifyChunk.OK) {
            return ctx.defaultPosition;
        }
        ctx.beforeOutRange = false;
        ctx.afterOutRange = false;
        for (int moreDelta = 0; moreDelta >= 0; ++moreDelta) {
            int pos = this.findPositionWithFuzzAndMoreDelta(ctx, delta, fuzz, moreDelta);
            if (pos >= 0) {
                return pos;
            }
            if (ctx.beforeOutRange && ctx.afterOutRange) break;
        }
        return -1;
    }

    private int findPositionWithFuzzAndMoreDelta(PatchApplyingContext<T> ctx, AbstractDelta<T> delta, int fuzz, int moreDelta) throws PatchFailedException {
        VerifyChunk after;
        VerifyChunk before;
        int beginAt;
        if (!ctx.beforeOutRange && (beginAt = ctx.defaultPosition - moreDelta + fuzz) <= ctx.lastPatchEnd) {
            ctx.beforeOutRange = true;
        }
        if (!ctx.afterOutRange) {
            beginAt = ctx.defaultPosition + moreDelta + delta.getSource().size() - fuzz;
            if (ctx.result.size() < beginAt) {
                ctx.afterOutRange = true;
            }
        }
        if (!ctx.beforeOutRange && (before = delta.getSource().verifyChunk(ctx.result, fuzz, ctx.defaultPosition - moreDelta)) == VerifyChunk.OK) {
            return ctx.defaultPosition - moreDelta;
        }
        if (!ctx.afterOutRange && (after = delta.getSource().verifyChunk(ctx.result, fuzz, ctx.defaultPosition + moreDelta)) == VerifyChunk.OK) {
            return ctx.defaultPosition + moreDelta;
        }
        return -1;
    }

    public Patch withConflictOutput(ConflictOutput<T> conflictOutput) {
        this.conflictOutput = conflictOutput;
        return this;
    }

    public List<T> restore(List<T> target) {
        ArrayList<T> result2 = new ArrayList<T>(target);
        ListIterator<AbstractDelta<T>> it = this.getDeltas().listIterator(this.deltas.size());
        while (it.hasPrevious()) {
            AbstractDelta<T> delta = it.previous();
            delta.restore(result2);
        }
        return result2;
    }

    public void addDelta(AbstractDelta<T> delta) {
        this.deltas.add(delta);
    }

    public List<AbstractDelta<T>> getDeltas() {
        this.deltas.sort(Comparator.comparing(d -> d.getSource().getPosition()));
        return this.deltas;
    }

    public String toString() {
        return "Patch{deltas=" + this.deltas + '}';
    }

    public static <T> Patch<T> generate(List<T> original, List<T> revised, List<Change> changes) {
        return Patch.generate(original, revised, changes, false);
    }

    private static <T> Chunk<T> buildChunk(int start, int end, List<T> data) {
        return new Chunk<T>(start, new ArrayList<T>(data.subList(start, end)));
    }

    public static <T> Patch<T> generate(List<T> original, List<T> revised, List<Change> _changes, boolean includeEquals) {
        Patch<T> patch = new Patch<T>(_changes.size());
        int startOriginal = 0;
        int startRevised = 0;
        List<Change> changes = _changes;
        if (includeEquals) {
            changes = new ArrayList<Change>(_changes);
            Collections.sort(changes, Comparator.comparing(d -> d.startOriginal));
        }
        for (Change change : changes) {
            if (includeEquals && startOriginal < change.startOriginal) {
                patch.addDelta(new EqualDelta<T>(Patch.buildChunk(startOriginal, change.startOriginal, original), Patch.buildChunk(startRevised, change.startRevised, revised)));
            }
            Chunk<T> orgChunk = Patch.buildChunk(change.startOriginal, change.endOriginal, original);
            Chunk<T> revChunk = Patch.buildChunk(change.startRevised, change.endRevised, revised);
            switch (change.deltaType) {
                case DELETE: {
                    patch.addDelta(new DeleteDelta<T>(orgChunk, revChunk));
                    break;
                }
                case INSERT: {
                    patch.addDelta(new InsertDelta<T>(orgChunk, revChunk));
                    break;
                }
                case CHANGE: {
                    patch.addDelta(new ChangeDelta<T>(orgChunk, revChunk));
                    break;
                }
            }
            startOriginal = change.endOriginal;
            startRevised = change.endRevised;
        }
        if (includeEquals && startOriginal < original.size()) {
            patch.addDelta(new EqualDelta<T>(Patch.buildChunk(startOriginal, original.size(), original), Patch.buildChunk(startRevised, revised.size(), revised)));
        }
        return patch;
    }

    private static class PatchApplyingContext<T> {
        public final List<T> result;
        public final int maxFuzz;
        public int lastPatchEnd = -1;
        public int currentFuzz = 0;
        public int defaultPosition;
        public boolean beforeOutRange = false;
        public boolean afterOutRange = false;

        private PatchApplyingContext(List<T> result2, int maxFuzz) {
            this.result = result2;
            this.maxFuzz = maxFuzz;
        }
    }
}

