/*
 * Decompiled with CFR 0.152.
 */
package coursier.util.shaded.org.jsoup.nodes;

import coursier.util.shaded.org.jsoup.SerializationException;
import coursier.util.shaded.org.jsoup.helper.Validate;
import coursier.util.shaded.org.jsoup.internal.Normalizer;
import coursier.util.shaded.org.jsoup.internal.StringUtil;
import coursier.util.shaded.org.jsoup.nodes.Attributes;
import coursier.util.shaded.org.jsoup.nodes.Document;
import coursier.util.shaded.org.jsoup.nodes.Entities;
import coursier.util.shaded.org.jsoup.nodes.Range;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;

public class Attribute
implements Map.Entry<String, String>,
Cloneable {
    private static final String[] booleanAttributes = new String[]{"allowfullscreen", "async", "autofocus", "checked", "compact", "declare", "default", "defer", "disabled", "formnovalidate", "hidden", "inert", "ismap", "itemscope", "multiple", "muted", "nohref", "noresize", "noshade", "novalidate", "nowrap", "open", "readonly", "required", "reversed", "seamless", "selected", "sortable", "truespeed", "typemustmatch"};
    private String key;
    private @Nullable String val;
    @Nullable Attributes parent;
    private static final Pattern xmlKeyReplace = Pattern.compile("[^-a-zA-Z0-9_:.]+");
    private static final Pattern htmlKeyReplace = Pattern.compile("[\\x00-\\x1f\\x7f-\\x9f \"'/=]+");

    public Attribute(String key2, @Nullable String value) {
        this(key2, value, null);
    }

    public Attribute(String key2, @Nullable String val, @Nullable Attributes parent) {
        Validate.notNull(key2);
        key2 = key2.trim();
        Validate.notEmpty(key2);
        this.key = key2;
        this.val = val;
        this.parent = parent;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public void setKey(String key2) {
        int i;
        Validate.notNull(key2);
        key2 = key2.trim();
        Validate.notEmpty(key2);
        if (this.parent != null && (i = this.parent.indexOfKey(this.key)) != -1) {
            String oldKey = this.parent.keys[i];
            this.parent.keys[i] = key2;
            Map<String, Range.AttributeRange> ranges = this.parent.getRanges();
            if (ranges != null) {
                Range.AttributeRange range = ranges.remove(oldKey);
                ranges.put(key2, range);
            }
        }
        this.key = key2;
    }

    @Override
    public String getValue() {
        return Attributes.checkNotNull(this.val);
    }

    public boolean hasDeclaredValue() {
        return this.val != null;
    }

    @Override
    public String setValue(@Nullable String val) {
        int i;
        String oldVal = this.val;
        if (this.parent != null && (i = this.parent.indexOfKey(this.key)) != -1) {
            oldVal = this.parent.get(this.key);
            this.parent.vals[i] = val;
        }
        this.val = val;
        return Attributes.checkNotNull(oldVal);
    }

    public String html() {
        StringBuilder sb = StringUtil.borrowBuilder();
        try {
            this.html(sb, new Document("").outputSettings());
        }
        catch (IOException exception) {
            throw new SerializationException(exception);
        }
        return StringUtil.releaseBuilder(sb);
    }

    public Range.AttributeRange sourceRange() {
        if (this.parent == null) {
            return Range.AttributeRange.UntrackedAttr;
        }
        return this.parent.sourceRange(this.key);
    }

    protected void html(Appendable accum2, Document.OutputSettings out) throws IOException {
        Attribute.html(this.key, this.val, accum2, out);
    }

    protected static void html(String key2, @Nullable String val, Appendable accum2, Document.OutputSettings out) throws IOException {
        if ((key2 = Attribute.getValidKey(key2, out.syntax())) == null) {
            return;
        }
        Attribute.htmlNoValidate(key2, val, accum2, out);
    }

    static void htmlNoValidate(String key2, @Nullable String val, Appendable accum2, Document.OutputSettings out) throws IOException {
        accum2.append(key2);
        if (!Attribute.shouldCollapseAttribute(key2, val, out)) {
            accum2.append("=\"");
            Entities.escape(accum2, Attributes.checkNotNull(val), out, 2);
            accum2.append('\"');
        }
    }

    public static @Nullable String getValidKey(String key2, Document.OutputSettings.Syntax syntax) {
        if (syntax == Document.OutputSettings.Syntax.xml && !Attribute.isValidXmlKey(key2)) {
            return Attribute.isValidXmlKey(key2 = xmlKeyReplace.matcher(key2).replaceAll("_")) ? key2 : null;
        }
        if (syntax == Document.OutputSettings.Syntax.html && !Attribute.isValidHtmlKey(key2)) {
            return Attribute.isValidHtmlKey(key2 = htmlKeyReplace.matcher(key2).replaceAll("_")) ? key2 : null;
        }
        return key2;
    }

    private static boolean isValidXmlKey(String key2) {
        int length = key2.length();
        if (length == 0) {
            return false;
        }
        char c = key2.charAt(0);
        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == ':')) {
            return false;
        }
        for (int i = 1; i < length; ++i) {
            c = key2.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_' || c == ':' || c == '.') continue;
            return false;
        }
        return true;
    }

    private static boolean isValidHtmlKey(String key2) {
        int length = key2.length();
        if (length == 0) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            char c = key2.charAt(i);
            if (c > '\u001f' && (c < '\u007f' || c > '\u009f') && c != ' ' && c != '\"' && c != '\'' && c != '/' && c != '=') continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.html();
    }

    public static Attribute createFromEncoded(String unencodedKey, String encodedValue) {
        String value = Entities.unescape(encodedValue, true);
        return new Attribute(unencodedKey, value, null);
    }

    protected boolean isDataAttribute() {
        return Attribute.isDataAttribute(this.key);
    }

    protected static boolean isDataAttribute(String key2) {
        return key2.startsWith("data-") && key2.length() > "data-".length();
    }

    protected final boolean shouldCollapseAttribute(Document.OutputSettings out) {
        return Attribute.shouldCollapseAttribute(this.key, this.val, out);
    }

    protected static boolean shouldCollapseAttribute(String key2, @Nullable String val, Document.OutputSettings out) {
        return out.syntax() == Document.OutputSettings.Syntax.html && (val == null || (val.isEmpty() || val.equalsIgnoreCase(key2)) && Attribute.isBooleanAttribute(key2));
    }

    public static boolean isBooleanAttribute(String key2) {
        return Arrays.binarySearch(booleanAttributes, Normalizer.lowerCase(key2)) >= 0;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        return Objects.equals(this.key, attribute.key) && Objects.equals(this.val, attribute.val);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.key, this.val);
    }

    public Attribute clone() {
        try {
            return (Attribute)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

