/*
 * Decompiled with CFR 0.152.
 */
package mill.main;

import java.io.InputStream;
import java.util.Properties;
import mill.moduledefs.Scaladoc;

public final class BuildInfo$ {
    public static final BuildInfo$ MODULE$ = new BuildInfo$();
    private static final Properties buildInfoProperties = new Properties();
    @Scaladoc(value="/** Mill binary platform version. */")
    private static final String millBinPlatform;
    @Scaladoc(value="/** Coordinates of the module pulling the whole of Mill */")
    private static final String millDistModule;
    @Scaladoc(value="/** All Mill distribution dependencies */")
    private static final String millEmbeddedDeps;
    @Scaladoc(value="/** Scalac compiler plugin dependencies to compile the build script. */")
    private static final String millScalacPluginDeps;
    @Scaladoc(value="/** Mill version. */")
    private static final String millVersion;
    @Scaladoc(value="/** Scala version used to compile mill core. */")
    private static final String scalaVersion;
    @Scaladoc(value="/** Scala 2.12 version used by some workers. */")
    private static final String workerScalaVersion212;
    @Scaladoc(value="/** Scala 2.13 version used by some workers. */")
    private static final String workerScalaVersion213;

    static {
        InputStream buildInfoInputStream = MODULE$.getClass().getResourceAsStream("BuildInfo.buildinfo.properties");
        if (buildInfoInputStream == null) {
            throw new RuntimeException("Could not load resource BuildInfo.buildinfo.properties");
        }
        try {
            MODULE$.buildInfoProperties().load(buildInfoInputStream);
        }
        finally {
            buildInfoInputStream.close();
        }
        millBinPlatform = MODULE$.buildInfoProperties().getProperty("millBinPlatform");
        millDistModule = MODULE$.buildInfoProperties().getProperty("millDistModule");
        millEmbeddedDeps = MODULE$.buildInfoProperties().getProperty("millEmbeddedDeps");
        millScalacPluginDeps = MODULE$.buildInfoProperties().getProperty("millScalacPluginDeps");
        millVersion = MODULE$.buildInfoProperties().getProperty("millVersion");
        scalaVersion = MODULE$.buildInfoProperties().getProperty("scalaVersion");
        workerScalaVersion212 = MODULE$.buildInfoProperties().getProperty("workerScalaVersion212");
        workerScalaVersion213 = MODULE$.buildInfoProperties().getProperty("workerScalaVersion213");
    }

    private Properties buildInfoProperties() {
        return buildInfoProperties;
    }

    public String millBinPlatform() {
        return millBinPlatform;
    }

    public String millDistModule() {
        return millDistModule;
    }

    public String millEmbeddedDeps() {
        return millEmbeddedDeps;
    }

    public String millScalacPluginDeps() {
        return millScalacPluginDeps;
    }

    public String millVersion() {
        return millVersion;
    }

    public String scalaVersion() {
        return scalaVersion;
    }

    public String workerScalaVersion212() {
        return workerScalaVersion212;
    }

    public String workerScalaVersion213() {
        return workerScalaVersion213;
    }

    private BuildInfo$() {
    }
}

