# Security Policy

## Reporting a Vulnerability
The KubeVirt project treats security vulnerabilities seriously, so we
strive to take action quickly when required.

The project requests that security issues be disclosed in a responsible
manner to allow adequate time to respond.  If a security issue or
vulnerability has been found, please disclose the details to our
dedicated email address:

cncf-kubevirt-security@lists.cncf.io [PGP](#PGP Encryption)

Please include as much information as possible with the report. The
following details assist with analysis efforts:
  - Description of the vulnerability
  - Affected component (version, commit, branch etc)
  - Affected code (file path, line numbers)
  - Exploit code

Any confidential information disclosed to the security team will be
handled appropriately to prevent misuse or accidental disclosure.

## PGP Encryption
Security issues can often be sensitive in nature, so information can be
disclosed with PGP encryption. Our public key can be found on
[public keyservers](https://pgp.mit.edu/pks/lookup?search=0x26A3D09E&op=vindex&exact=on)
and our fingerprint is as follows:

```CEF1 66F8 B929 4CDE 3233  5FCF B3D9 0475 26A3 D09E```

Please note that the above key will not be used for signing releases.
Please refer to your vendors instructions for verifying packages, images
or source code.

## Security Notices
Security notices will be sent to the kubevirt-dev@googlegroups.com
mailing list and published to the
[Security Advisories](https://github.com/kubevirt/kubevirt/security/advisories)
page.

## Security Team
The security team currently consists of the Maintainers of Kubevirt.
