// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package resourcegroupstaggingapi

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opGetResources = "GetResources"

// GetResourcesRequest generates a "aws/request.Request" representing the
// client's request for the GetResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResources for more information on using the GetResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResourcesRequest method.
//    req, resp := client.GetResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resourcegroupstaggingapi-2017-01-26/GetResources
func (c *ResourceGroupsTaggingAPI) GetResourcesRequest(input *GetResourcesInput) (req *request.Request, output *GetResourcesOutput) {
	op := &request.Operation{
		Name:       opGetResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"PaginationToken"},
			OutputTokens:    []string{"PaginationToken"},
			LimitToken:      "ResourcesPerPage",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetResourcesInput{}
	}

	output = &GetResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResources API operation for AWS Resource Groups Tagging API.
//
// Returns all the tagged resources that are associated with the specified tags
// (keys and values) located in the specified region for the AWS account. The
// tags and the resource types that you specify in the request are known as
// filters. The response includes all tags that are associated with the requested
// resources. If no filter is provided, this action returns a paginated resource
// list with the associated tags.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups Tagging API's
// API operation GetResources for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   A parameter is missing or a malformed string or invalid or out-of-range value
//   was supplied for the request parameter.
//
//   * ErrCodeThrottledException "ThrottledException"
//   The request was denied to limit the frequency of submitted requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The request processing failed because of an unknown error, exception, or
//   failure. You can retry the request.
//
//   * ErrCodePaginationTokenExpiredException "PaginationTokenExpiredException"
//   A PaginationToken is valid for a maximum of 15 minutes. Your request was
//   denied because the specified PaginationToken has expired.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resourcegroupstaggingapi-2017-01-26/GetResources
func (c *ResourceGroupsTaggingAPI) GetResources(input *GetResourcesInput) (*GetResourcesOutput, error) {
	req, out := c.GetResourcesRequest(input)
	return out, req.Send()
}

// GetResourcesWithContext is the same as GetResources with the addition of
// the ability to pass a context and additional request options.
//
// See GetResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroupsTaggingAPI) GetResourcesWithContext(ctx aws.Context, input *GetResourcesInput, opts ...request.Option) (*GetResourcesOutput, error) {
	req, out := c.GetResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetResourcesPages iterates over the pages of a GetResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetResources operation.
//    pageNum := 0
//    err := client.GetResourcesPages(params,
//        func(page *resourcegroupstaggingapi.GetResourcesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ResourceGroupsTaggingAPI) GetResourcesPages(input *GetResourcesInput, fn func(*GetResourcesOutput, bool) bool) error {
	return c.GetResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetResourcesPagesWithContext same as GetResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroupsTaggingAPI) GetResourcesPagesWithContext(ctx aws.Context, input *GetResourcesInput, fn func(*GetResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetResourcesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetTagKeys = "GetTagKeys"

// GetTagKeysRequest generates a "aws/request.Request" representing the
// client's request for the GetTagKeys operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTagKeys for more information on using the GetTagKeys
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTagKeysRequest method.
//    req, resp := client.GetTagKeysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resourcegroupstaggingapi-2017-01-26/GetTagKeys
func (c *ResourceGroupsTaggingAPI) GetTagKeysRequest(input *GetTagKeysInput) (req *request.Request, output *GetTagKeysOutput) {
	op := &request.Operation{
		Name:       opGetTagKeys,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"PaginationToken"},
			OutputTokens:    []string{"PaginationToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetTagKeysInput{}
	}

	output = &GetTagKeysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTagKeys API operation for AWS Resource Groups Tagging API.
//
// Returns all tag keys in the specified region for the AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups Tagging API's
// API operation GetTagKeys for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   A parameter is missing or a malformed string or invalid or out-of-range value
//   was supplied for the request parameter.
//
//   * ErrCodeThrottledException "ThrottledException"
//   The request was denied to limit the frequency of submitted requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The request processing failed because of an unknown error, exception, or
//   failure. You can retry the request.
//
//   * ErrCodePaginationTokenExpiredException "PaginationTokenExpiredException"
//   A PaginationToken is valid for a maximum of 15 minutes. Your request was
//   denied because the specified PaginationToken has expired.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resourcegroupstaggingapi-2017-01-26/GetTagKeys
func (c *ResourceGroupsTaggingAPI) GetTagKeys(input *GetTagKeysInput) (*GetTagKeysOutput, error) {
	req, out := c.GetTagKeysRequest(input)
	return out, req.Send()
}

// GetTagKeysWithContext is the same as GetTagKeys with the addition of
// the ability to pass a context and additional request options.
//
// See GetTagKeys for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroupsTaggingAPI) GetTagKeysWithContext(ctx aws.Context, input *GetTagKeysInput, opts ...request.Option) (*GetTagKeysOutput, error) {
	req, out := c.GetTagKeysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetTagKeysPages iterates over the pages of a GetTagKeys operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetTagKeys method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetTagKeys operation.
//    pageNum := 0
//    err := client.GetTagKeysPages(params,
//        func(page *resourcegroupstaggingapi.GetTagKeysOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ResourceGroupsTaggingAPI) GetTagKeysPages(input *GetTagKeysInput, fn func(*GetTagKeysOutput, bool) bool) error {
	return c.GetTagKeysPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetTagKeysPagesWithContext same as GetTagKeysPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroupsTaggingAPI) GetTagKeysPagesWithContext(ctx aws.Context, input *GetTagKeysInput, fn func(*GetTagKeysOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetTagKeysInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetTagKeysRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetTagKeysOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetTagValues = "GetTagValues"

// GetTagValuesRequest generates a "aws/request.Request" representing the
// client's request for the GetTagValues operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTagValues for more information on using the GetTagValues
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTagValuesRequest method.
//    req, resp := client.GetTagValuesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resourcegroupstaggingapi-2017-01-26/GetTagValues
func (c *ResourceGroupsTaggingAPI) GetTagValuesRequest(input *GetTagValuesInput) (req *request.Request, output *GetTagValuesOutput) {
	op := &request.Operation{
		Name:       opGetTagValues,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"PaginationToken"},
			OutputTokens:    []string{"PaginationToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetTagValuesInput{}
	}

	output = &GetTagValuesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTagValues API operation for AWS Resource Groups Tagging API.
//
// Returns all tag values for the specified key in the specified region for
// the AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups Tagging API's
// API operation GetTagValues for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   A parameter is missing or a malformed string or invalid or out-of-range value
//   was supplied for the request parameter.
//
//   * ErrCodeThrottledException "ThrottledException"
//   The request was denied to limit the frequency of submitted requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The request processing failed because of an unknown error, exception, or
//   failure. You can retry the request.
//
//   * ErrCodePaginationTokenExpiredException "PaginationTokenExpiredException"
//   A PaginationToken is valid for a maximum of 15 minutes. Your request was
//   denied because the specified PaginationToken has expired.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resourcegroupstaggingapi-2017-01-26/GetTagValues
func (c *ResourceGroupsTaggingAPI) GetTagValues(input *GetTagValuesInput) (*GetTagValuesOutput, error) {
	req, out := c.GetTagValuesRequest(input)
	return out, req.Send()
}

// GetTagValuesWithContext is the same as GetTagValues with the addition of
// the ability to pass a context and additional request options.
//
// See GetTagValues for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroupsTaggingAPI) GetTagValuesWithContext(ctx aws.Context, input *GetTagValuesInput, opts ...request.Option) (*GetTagValuesOutput, error) {
	req, out := c.GetTagValuesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetTagValuesPages iterates over the pages of a GetTagValues operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetTagValues method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetTagValues operation.
//    pageNum := 0
//    err := client.GetTagValuesPages(params,
//        func(page *resourcegroupstaggingapi.GetTagValuesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ResourceGroupsTaggingAPI) GetTagValuesPages(input *GetTagValuesInput, fn func(*GetTagValuesOutput, bool) bool) error {
	return c.GetTagValuesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetTagValuesPagesWithContext same as GetTagValuesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroupsTaggingAPI) GetTagValuesPagesWithContext(ctx aws.Context, input *GetTagValuesInput, fn func(*GetTagValuesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetTagValuesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetTagValuesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetTagValuesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opTagResources = "TagResources"

// TagResourcesRequest generates a "aws/request.Request" representing the
// client's request for the TagResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResources for more information on using the TagResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourcesRequest method.
//    req, resp := client.TagResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resourcegroupstaggingapi-2017-01-26/TagResources
func (c *ResourceGroupsTaggingAPI) TagResourcesRequest(input *TagResourcesInput) (req *request.Request, output *TagResourcesOutput) {
	op := &request.Operation{
		Name:       opTagResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourcesInput{}
	}

	output = &TagResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TagResources API operation for AWS Resource Groups Tagging API.
//
// Applies one or more tags to the specified resources. Note the following:
//
//    * Not all resources can have tags. For a list of resources that support
//    tagging, see Supported Resources (http://docs.aws.amazon.com/awsconsolehelpdocs/latest/gsg/supported-resources.html)
//    in the AWS Resource Groups and Tag Editor User Guide.
//
//    * Each resource can have up to 50 tags. For other limits, see Tag Restrictions
//    (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-restrictions)
//    in the Amazon EC2 User Guide for Linux Instances.
//
//    * You can only tag resources that are located in the specified region
//    for the AWS account.
//
//    * To add tags to a resource, you need the necessary permissions for the
//    service that the resource belongs to as well as permissions for adding
//    tags. For more information, see Obtaining Permissions for Tagging (http://docs.aws.amazon.com/awsconsolehelpdocs/latest/gsg/obtaining-permissions-for-tagging.html)
//    in the AWS Resource Groups and Tag Editor User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups Tagging API's
// API operation TagResources for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   A parameter is missing or a malformed string or invalid or out-of-range value
//   was supplied for the request parameter.
//
//   * ErrCodeThrottledException "ThrottledException"
//   The request was denied to limit the frequency of submitted requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The request processing failed because of an unknown error, exception, or
//   failure. You can retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resourcegroupstaggingapi-2017-01-26/TagResources
func (c *ResourceGroupsTaggingAPI) TagResources(input *TagResourcesInput) (*TagResourcesOutput, error) {
	req, out := c.TagResourcesRequest(input)
	return out, req.Send()
}

// TagResourcesWithContext is the same as TagResources with the addition of
// the ability to pass a context and additional request options.
//
// See TagResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroupsTaggingAPI) TagResourcesWithContext(ctx aws.Context, input *TagResourcesInput, opts ...request.Option) (*TagResourcesOutput, error) {
	req, out := c.TagResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResources = "UntagResources"

// UntagResourcesRequest generates a "aws/request.Request" representing the
// client's request for the UntagResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResources for more information on using the UntagResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourcesRequest method.
//    req, resp := client.UntagResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resourcegroupstaggingapi-2017-01-26/UntagResources
func (c *ResourceGroupsTaggingAPI) UntagResourcesRequest(input *UntagResourcesInput) (req *request.Request, output *UntagResourcesOutput) {
	op := &request.Operation{
		Name:       opUntagResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourcesInput{}
	}

	output = &UntagResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UntagResources API operation for AWS Resource Groups Tagging API.
//
// Removes the specified tags from the specified resources. When you specify
// a tag key, the action removes both that key and its associated value. The
// operation succeeds even if you attempt to remove tags from a resource that
// were already removed. Note the following:
//
//    * To remove tags from a resource, you need the necessary permissions for
//    the service that the resource belongs to as well as permissions for removing
//    tags. For more information, see Obtaining Permissions for Tagging (http://docs.aws.amazon.com/awsconsolehelpdocs/latest/gsg/obtaining-permissions-for-tagging.html)
//    in the AWS Resource Groups and Tag Editor User Guide.
//
//    * You can only tag resources that are located in the specified region
//    for the AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Resource Groups Tagging API's
// API operation UntagResources for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   A parameter is missing or a malformed string or invalid or out-of-range value
//   was supplied for the request parameter.
//
//   * ErrCodeThrottledException "ThrottledException"
//   The request was denied to limit the frequency of submitted requests.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   The request processing failed because of an unknown error, exception, or
//   failure. You can retry the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/resourcegroupstaggingapi-2017-01-26/UntagResources
func (c *ResourceGroupsTaggingAPI) UntagResources(input *UntagResourcesInput) (*UntagResourcesOutput, error) {
	req, out := c.UntagResourcesRequest(input)
	return out, req.Send()
}

// UntagResourcesWithContext is the same as UntagResources with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ResourceGroupsTaggingAPI) UntagResourcesWithContext(ctx aws.Context, input *UntagResourcesInput, opts ...request.Option) (*UntagResourcesOutput, error) {
	req, out := c.UntagResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Details of the common errors that all actions return.
type FailureInfo struct {
	_ struct{} `type:"structure"`

	// The code of the common error. Valid values include InternalServiceException,
	// InvalidParameterException, and any valid error code returned by the AWS service
	// that hosts the resource that you want to tag.
	ErrorCode *string `type:"string" enum:"ErrorCode"`

	// The message of the common error.
	ErrorMessage *string `type:"string"`

	// The HTTP status code of the common error.
	StatusCode *int64 `type:"integer"`
}

// String returns the string representation
func (s FailureInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailureInfo) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *FailureInfo) SetErrorCode(v string) *FailureInfo {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *FailureInfo) SetErrorMessage(v string) *FailureInfo {
	s.ErrorMessage = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *FailureInfo) SetStatusCode(v int64) *FailureInfo {
	s.StatusCode = &v
	return s
}

type GetResourcesInput struct {
	_ struct{} `type:"structure"`

	// A string that indicates that additional data is available. Leave this value
	// empty for your initial request. If the response includes a PaginationToken,
	// use that string for this value to request an additional page of data.
	PaginationToken *string `type:"string"`

	// The constraints on the resources that you want returned. The format of each
	// resource type is service[:resourceType]. For example, specifying a resource
	// type of ec2 returns all tagged Amazon EC2 resources (which includes tagged
	// EC2 instances). Specifying a resource type of ec2:instance returns only EC2
	// instances.
	//
	// The string for each service name and resource type is the same as that embedded
	// in a resource's Amazon Resource Name (ARN). Consult the AWS General Reference
	// for the following:
	//
	//    * For a list of service name strings, see AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces).
	//
	//    * For resource type strings, see Example ARNs (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arns-syntax).
	//
	//    * For more information about ARNs, see Amazon Resource Names (ARNs) and
	//    AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	ResourceTypeFilters []*string `type:"list"`

	// A limit that restricts the number of resources returned by GetResources in
	// paginated output. You can set ResourcesPerPage to a minimum of 1 item and
	// the maximum of 50 items.
	ResourcesPerPage *int64 `type:"integer"`

	// A list of tags (keys and values). A request can include up to 50 keys, and
	// each key can include up to 20 values.
	//
	// If you specify multiple filters connected by an AND operator in a single
	// request, the response returns only those resources that are associated with
	// every specified filter.
	//
	// If you specify multiple filters connected by an OR operator in a single request,
	// the response returns all resources that are associated with at least one
	// or possibly more of the specified filters.
	TagFilters []*TagFilter `type:"list"`

	// A limit that restricts the number of tags (key and value pairs) returned
	// by GetResources in paginated output. A resource with no tags is counted as
	// having one tag (one key and value pair).
	//
	// GetResources does not split a resource and its associated tags across pages.
	// If the specified TagsPerPage would cause such a break, a PaginationToken
	// is returned in place of the affected resource and its tags. Use that token
	// in another request to get the remaining data. For example, if you specify
	// a TagsPerPage of 100 and the account has 22 resources with 10 tags each (meaning
	// that each resource has 10 key and value pairs), the output will consist of
	// 3 pages, with the first page displaying the first 10 resources, each with
	// its 10 tags, the second page displaying the next 10 resources each with its
	// 10 tags, and the third page displaying the remaining 2 resources, each with
	// its 10 tags.
	//
	// You can set TagsPerPage to a minimum of 100 items and the maximum of 500
	// items.
	TagsPerPage *int64 `type:"integer"`
}

// String returns the string representation
func (s GetResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourcesInput"}
	if s.TagFilters != nil {
		for i, v := range s.TagFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *GetResourcesInput) SetPaginationToken(v string) *GetResourcesInput {
	s.PaginationToken = &v
	return s
}

// SetResourceTypeFilters sets the ResourceTypeFilters field's value.
func (s *GetResourcesInput) SetResourceTypeFilters(v []*string) *GetResourcesInput {
	s.ResourceTypeFilters = v
	return s
}

// SetResourcesPerPage sets the ResourcesPerPage field's value.
func (s *GetResourcesInput) SetResourcesPerPage(v int64) *GetResourcesInput {
	s.ResourcesPerPage = &v
	return s
}

// SetTagFilters sets the TagFilters field's value.
func (s *GetResourcesInput) SetTagFilters(v []*TagFilter) *GetResourcesInput {
	s.TagFilters = v
	return s
}

// SetTagsPerPage sets the TagsPerPage field's value.
func (s *GetResourcesInput) SetTagsPerPage(v int64) *GetResourcesInput {
	s.TagsPerPage = &v
	return s
}

type GetResourcesOutput struct {
	_ struct{} `type:"structure"`

	// A string that indicates that the response contains more data than can be
	// returned in a single response. To receive additional data, specify this string
	// for the PaginationToken value in a subsequent request.
	PaginationToken *string `type:"string"`

	// A list of resource ARNs and the tags (keys and values) associated with each.
	ResourceTagMappingList []*ResourceTagMapping `type:"list"`
}

// String returns the string representation
func (s GetResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourcesOutput) GoString() string {
	return s.String()
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *GetResourcesOutput) SetPaginationToken(v string) *GetResourcesOutput {
	s.PaginationToken = &v
	return s
}

// SetResourceTagMappingList sets the ResourceTagMappingList field's value.
func (s *GetResourcesOutput) SetResourceTagMappingList(v []*ResourceTagMapping) *GetResourcesOutput {
	s.ResourceTagMappingList = v
	return s
}

type GetTagKeysInput struct {
	_ struct{} `type:"structure"`

	// A string that indicates that additional data is available. Leave this value
	// empty for your initial request. If the response includes a PaginationToken,
	// use that string for this value to request an additional page of data.
	PaginationToken *string `type:"string"`
}

// String returns the string representation
func (s GetTagKeysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTagKeysInput) GoString() string {
	return s.String()
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *GetTagKeysInput) SetPaginationToken(v string) *GetTagKeysInput {
	s.PaginationToken = &v
	return s
}

type GetTagKeysOutput struct {
	_ struct{} `type:"structure"`

	// A string that indicates that the response contains more data than can be
	// returned in a single response. To receive additional data, specify this string
	// for the PaginationToken value in a subsequent request.
	PaginationToken *string `type:"string"`

	// A list of all tag keys in the AWS account.
	TagKeys []*string `type:"list"`
}

// String returns the string representation
func (s GetTagKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTagKeysOutput) GoString() string {
	return s.String()
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *GetTagKeysOutput) SetPaginationToken(v string) *GetTagKeysOutput {
	s.PaginationToken = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *GetTagKeysOutput) SetTagKeys(v []*string) *GetTagKeysOutput {
	s.TagKeys = v
	return s
}

type GetTagValuesInput struct {
	_ struct{} `type:"structure"`

	// The key for which you want to list all existing values in the specified region
	// for the AWS account.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// A string that indicates that additional data is available. Leave this value
	// empty for your initial request. If the response includes a PaginationToken,
	// use that string for this value to request an additional page of data.
	PaginationToken *string `type:"string"`
}

// String returns the string representation
func (s GetTagValuesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTagValuesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTagValuesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTagValuesInput"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *GetTagValuesInput) SetKey(v string) *GetTagValuesInput {
	s.Key = &v
	return s
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *GetTagValuesInput) SetPaginationToken(v string) *GetTagValuesInput {
	s.PaginationToken = &v
	return s
}

type GetTagValuesOutput struct {
	_ struct{} `type:"structure"`

	// A string that indicates that the response contains more data than can be
	// returned in a single response. To receive additional data, specify this string
	// for the PaginationToken value in a subsequent request.
	PaginationToken *string `type:"string"`

	// A list of all tag values for the specified key in the AWS account.
	TagValues []*string `type:"list"`
}

// String returns the string representation
func (s GetTagValuesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTagValuesOutput) GoString() string {
	return s.String()
}

// SetPaginationToken sets the PaginationToken field's value.
func (s *GetTagValuesOutput) SetPaginationToken(v string) *GetTagValuesOutput {
	s.PaginationToken = &v
	return s
}

// SetTagValues sets the TagValues field's value.
func (s *GetTagValuesOutput) SetTagValues(v []*string) *GetTagValuesOutput {
	s.TagValues = v
	return s
}

// A list of resource ARNs and the tags (keys and values) that are associated
// with each.
type ResourceTagMapping struct {
	_ struct{} `type:"structure"`

	// An array of resource ARN(s).
	ResourceARN *string `min:"1" type:"string"`

	// The tags that have been applied to one or more AWS resources.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s ResourceTagMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceTagMapping) GoString() string {
	return s.String()
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ResourceTagMapping) SetResourceARN(v string) *ResourceTagMapping {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ResourceTagMapping) SetTags(v []*Tag) *ResourceTagMapping {
	s.Tags = v
	return s
}

// The metadata that you apply to AWS resources to help you categorize and organize
// them. Each tag consists of a key and an optional value, both of which you
// define. For more information, see Tag Basics (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-basics)
// in the Amazon EC2 User Guide for Linux Instances.
type Tag struct {
	_ struct{} `type:"structure"`

	// One part of a key-value pair that make up a tag. A key is a general label
	// that acts like a category for more specific tag values.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The optional part of a key-value pair that make up a tag. A value acts as
	// a descriptor within a tag category (key).
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// A list of tags (keys and values) that are used to specify the associated
// resources.
type TagFilter struct {
	_ struct{} `type:"structure"`

	// One part of a key-value pair that make up a tag. A key is a general label
	// that acts like a category for more specific tag values.
	Key *string `min:"1" type:"string"`

	// The optional part of a key-value pair that make up a tag. A value acts as
	// a descriptor within a tag category (key).
	Values []*string `type:"list"`
}

// String returns the string representation
func (s TagFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagFilter"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *TagFilter) SetKey(v string) *TagFilter {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *TagFilter) SetValues(v []*string) *TagFilter {
	s.Values = v
	return s
}

type TagResourcesInput struct {
	_ struct{} `type:"structure"`

	// A list of ARNs. An ARN (Amazon Resource Name) uniquely identifies a resource.
	// You can specify a minimum of 1 and a maximum of 20 ARNs (resources) to tag.
	// An ARN can be set to a maximum of 1600 characters. For more information,
	// see Amazon Resource Names (ARNs) and AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	//
	// ResourceARNList is a required field
	ResourceARNList []*string `min:"1" type:"list" required:"true"`

	// The tags that you want to add to the specified resources. A tag consists
	// of a key and a value that you define.
	//
	// Tags is a required field
	Tags map[string]*string `min:"1" type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourcesInput"}
	if s.ResourceARNList == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARNList"))
	}
	if s.ResourceARNList != nil && len(s.ResourceARNList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARNList", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARNList sets the ResourceARNList field's value.
func (s *TagResourcesInput) SetResourceARNList(v []*string) *TagResourcesInput {
	s.ResourceARNList = v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourcesInput) SetTags(v map[string]*string) *TagResourcesInput {
	s.Tags = v
	return s
}

type TagResourcesOutput struct {
	_ struct{} `type:"structure"`

	// Details of resources that could not be tagged. An error code, status code,
	// and error message are returned for each failed item.
	FailedResourcesMap map[string]*FailureInfo `type:"map"`
}

// String returns the string representation
func (s TagResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourcesOutput) GoString() string {
	return s.String()
}

// SetFailedResourcesMap sets the FailedResourcesMap field's value.
func (s *TagResourcesOutput) SetFailedResourcesMap(v map[string]*FailureInfo) *TagResourcesOutput {
	s.FailedResourcesMap = v
	return s
}

type UntagResourcesInput struct {
	_ struct{} `type:"structure"`

	// A list of ARNs. An ARN (Amazon Resource Name) uniquely identifies a resource.
	// You can specify a minimum of 1 and a maximum of 20 ARNs (resources) to untag.
	// An ARN can be set to a maximum of 1600 characters. For more information,
	// see Amazon Resource Names (ARNs) and AWS Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	//
	// ResourceARNList is a required field
	ResourceARNList []*string `min:"1" type:"list" required:"true"`

	// A list of the tag keys that you want to remove from the specified resources.
	//
	// TagKeys is a required field
	TagKeys []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourcesInput"}
	if s.ResourceARNList == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARNList"))
	}
	if s.ResourceARNList != nil && len(s.ResourceARNList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARNList", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARNList sets the ResourceARNList field's value.
func (s *UntagResourcesInput) SetResourceARNList(v []*string) *UntagResourcesInput {
	s.ResourceARNList = v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourcesInput) SetTagKeys(v []*string) *UntagResourcesInput {
	s.TagKeys = v
	return s
}

type UntagResourcesOutput struct {
	_ struct{} `type:"structure"`

	// Details of resources that could not be untagged. An error code, status code,
	// and error message are returned for each failed item.
	FailedResourcesMap map[string]*FailureInfo `type:"map"`
}

// String returns the string representation
func (s UntagResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourcesOutput) GoString() string {
	return s.String()
}

// SetFailedResourcesMap sets the FailedResourcesMap field's value.
func (s *UntagResourcesOutput) SetFailedResourcesMap(v map[string]*FailureInfo) *UntagResourcesOutput {
	s.FailedResourcesMap = v
	return s
}

const (
	// ErrorCodeInternalServiceException is a ErrorCode enum value
	ErrorCodeInternalServiceException = "InternalServiceException"

	// ErrorCodeInvalidParameterException is a ErrorCode enum value
	ErrorCodeInvalidParameterException = "InvalidParameterException"
)
