package sql

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AuthenticationType enumerates the values for authentication type.
type AuthenticationType string

const (
	// ADPassword ...
	ADPassword AuthenticationType = "ADPassword"
	// SQL ...
	SQL AuthenticationType = "SQL"
)

// PossibleAuthenticationTypeValues returns an array of possible values for the AuthenticationType const type.
func PossibleAuthenticationTypeValues() []AuthenticationType {
	return []AuthenticationType{ADPassword, SQL}
}

// BlobAuditingPolicyState enumerates the values for blob auditing policy state.
type BlobAuditingPolicyState string

const (
	// Disabled ...
	Disabled BlobAuditingPolicyState = "Disabled"
	// Enabled ...
	Enabled BlobAuditingPolicyState = "Enabled"
)

// PossibleBlobAuditingPolicyStateValues returns an array of possible values for the BlobAuditingPolicyState const type.
func PossibleBlobAuditingPolicyStateValues() []BlobAuditingPolicyState {
	return []BlobAuditingPolicyState{Disabled, Enabled}
}

// CapabilityStatus enumerates the values for capability status.
type CapabilityStatus string

const (
	// CapabilityStatusAvailable ...
	CapabilityStatusAvailable CapabilityStatus = "Available"
	// CapabilityStatusDefault ...
	CapabilityStatusDefault CapabilityStatus = "Default"
	// CapabilityStatusDisabled ...
	CapabilityStatusDisabled CapabilityStatus = "Disabled"
	// CapabilityStatusVisible ...
	CapabilityStatusVisible CapabilityStatus = "Visible"
)

// PossibleCapabilityStatusValues returns an array of possible values for the CapabilityStatus const type.
func PossibleCapabilityStatusValues() []CapabilityStatus {
	return []CapabilityStatus{CapabilityStatusAvailable, CapabilityStatusDefault, CapabilityStatusDisabled, CapabilityStatusVisible}
}

// CheckNameAvailabilityReason enumerates the values for check name availability reason.
type CheckNameAvailabilityReason string

const (
	// AlreadyExists ...
	AlreadyExists CheckNameAvailabilityReason = "AlreadyExists"
	// Invalid ...
	Invalid CheckNameAvailabilityReason = "Invalid"
)

// PossibleCheckNameAvailabilityReasonValues returns an array of possible values for the CheckNameAvailabilityReason const type.
func PossibleCheckNameAvailabilityReasonValues() []CheckNameAvailabilityReason {
	return []CheckNameAvailabilityReason{AlreadyExists, Invalid}
}

// CreateMode enumerates the values for create mode.
type CreateMode string

const (
	// Copy ...
	Copy CreateMode = "Copy"
	// Default ...
	Default CreateMode = "Default"
	// NonReadableSecondary ...
	NonReadableSecondary CreateMode = "NonReadableSecondary"
	// OnlineSecondary ...
	OnlineSecondary CreateMode = "OnlineSecondary"
	// PointInTimeRestore ...
	PointInTimeRestore CreateMode = "PointInTimeRestore"
	// Recovery ...
	Recovery CreateMode = "Recovery"
	// Restore ...
	Restore CreateMode = "Restore"
	// RestoreLongTermRetentionBackup ...
	RestoreLongTermRetentionBackup CreateMode = "RestoreLongTermRetentionBackup"
)

// PossibleCreateModeValues returns an array of possible values for the CreateMode const type.
func PossibleCreateModeValues() []CreateMode {
	return []CreateMode{Copy, Default, NonReadableSecondary, OnlineSecondary, PointInTimeRestore, Recovery, Restore, RestoreLongTermRetentionBackup}
}

// DatabaseEdition enumerates the values for database edition.
type DatabaseEdition string

const (
	// Basic ...
	Basic DatabaseEdition = "Basic"
	// Business ...
	Business DatabaseEdition = "Business"
	// BusinessCritical ...
	BusinessCritical DatabaseEdition = "BusinessCritical"
	// DataWarehouse ...
	DataWarehouse DatabaseEdition = "DataWarehouse"
	// Free ...
	Free DatabaseEdition = "Free"
	// GeneralPurpose ...
	GeneralPurpose DatabaseEdition = "GeneralPurpose"
	// Hyperscale ...
	Hyperscale DatabaseEdition = "Hyperscale"
	// Premium ...
	Premium DatabaseEdition = "Premium"
	// PremiumRS ...
	PremiumRS DatabaseEdition = "PremiumRS"
	// Standard ...
	Standard DatabaseEdition = "Standard"
	// Stretch ...
	Stretch DatabaseEdition = "Stretch"
	// System ...
	System DatabaseEdition = "System"
	// System2 ...
	System2 DatabaseEdition = "System2"
	// Web ...
	Web DatabaseEdition = "Web"
)

// PossibleDatabaseEditionValues returns an array of possible values for the DatabaseEdition const type.
func PossibleDatabaseEditionValues() []DatabaseEdition {
	return []DatabaseEdition{Basic, Business, BusinessCritical, DataWarehouse, Free, GeneralPurpose, Hyperscale, Premium, PremiumRS, Standard, Stretch, System, System2, Web}
}

// DataMaskingFunction enumerates the values for data masking function.
type DataMaskingFunction string

const (
	// DataMaskingFunctionCCN ...
	DataMaskingFunctionCCN DataMaskingFunction = "CCN"
	// DataMaskingFunctionDefault ...
	DataMaskingFunctionDefault DataMaskingFunction = "Default"
	// DataMaskingFunctionEmail ...
	DataMaskingFunctionEmail DataMaskingFunction = "Email"
	// DataMaskingFunctionNumber ...
	DataMaskingFunctionNumber DataMaskingFunction = "Number"
	// DataMaskingFunctionSSN ...
	DataMaskingFunctionSSN DataMaskingFunction = "SSN"
	// DataMaskingFunctionText ...
	DataMaskingFunctionText DataMaskingFunction = "Text"
)

// PossibleDataMaskingFunctionValues returns an array of possible values for the DataMaskingFunction const type.
func PossibleDataMaskingFunctionValues() []DataMaskingFunction {
	return []DataMaskingFunction{DataMaskingFunctionCCN, DataMaskingFunctionDefault, DataMaskingFunctionEmail, DataMaskingFunctionNumber, DataMaskingFunctionSSN, DataMaskingFunctionText}
}

// DataMaskingRuleState enumerates the values for data masking rule state.
type DataMaskingRuleState string

const (
	// DataMaskingRuleStateDisabled ...
	DataMaskingRuleStateDisabled DataMaskingRuleState = "Disabled"
	// DataMaskingRuleStateEnabled ...
	DataMaskingRuleStateEnabled DataMaskingRuleState = "Enabled"
)

// PossibleDataMaskingRuleStateValues returns an array of possible values for the DataMaskingRuleState const type.
func PossibleDataMaskingRuleStateValues() []DataMaskingRuleState {
	return []DataMaskingRuleState{DataMaskingRuleStateDisabled, DataMaskingRuleStateEnabled}
}

// DataMaskingState enumerates the values for data masking state.
type DataMaskingState string

const (
	// DataMaskingStateDisabled ...
	DataMaskingStateDisabled DataMaskingState = "Disabled"
	// DataMaskingStateEnabled ...
	DataMaskingStateEnabled DataMaskingState = "Enabled"
)

// PossibleDataMaskingStateValues returns an array of possible values for the DataMaskingState const type.
func PossibleDataMaskingStateValues() []DataMaskingState {
	return []DataMaskingState{DataMaskingStateDisabled, DataMaskingStateEnabled}
}

// ElasticPoolEdition enumerates the values for elastic pool edition.
type ElasticPoolEdition string

const (
	// ElasticPoolEditionBasic ...
	ElasticPoolEditionBasic ElasticPoolEdition = "Basic"
	// ElasticPoolEditionBusinessCritical ...
	ElasticPoolEditionBusinessCritical ElasticPoolEdition = "BusinessCritical"
	// ElasticPoolEditionGeneralPurpose ...
	ElasticPoolEditionGeneralPurpose ElasticPoolEdition = "GeneralPurpose"
	// ElasticPoolEditionPremium ...
	ElasticPoolEditionPremium ElasticPoolEdition = "Premium"
	// ElasticPoolEditionStandard ...
	ElasticPoolEditionStandard ElasticPoolEdition = "Standard"
)

// PossibleElasticPoolEditionValues returns an array of possible values for the ElasticPoolEdition const type.
func PossibleElasticPoolEditionValues() []ElasticPoolEdition {
	return []ElasticPoolEdition{ElasticPoolEditionBasic, ElasticPoolEditionBusinessCritical, ElasticPoolEditionGeneralPurpose, ElasticPoolEditionPremium, ElasticPoolEditionStandard}
}

// ElasticPoolState enumerates the values for elastic pool state.
type ElasticPoolState string

const (
	// ElasticPoolStateCreating ...
	ElasticPoolStateCreating ElasticPoolState = "Creating"
	// ElasticPoolStateDisabled ...
	ElasticPoolStateDisabled ElasticPoolState = "Disabled"
	// ElasticPoolStateReady ...
	ElasticPoolStateReady ElasticPoolState = "Ready"
)

// PossibleElasticPoolStateValues returns an array of possible values for the ElasticPoolState const type.
func PossibleElasticPoolStateValues() []ElasticPoolState {
	return []ElasticPoolState{ElasticPoolStateCreating, ElasticPoolStateDisabled, ElasticPoolStateReady}
}

// FailoverGroupReplicationRole enumerates the values for failover group replication role.
type FailoverGroupReplicationRole string

const (
	// Primary ...
	Primary FailoverGroupReplicationRole = "Primary"
	// Secondary ...
	Secondary FailoverGroupReplicationRole = "Secondary"
)

// PossibleFailoverGroupReplicationRoleValues returns an array of possible values for the FailoverGroupReplicationRole const type.
func PossibleFailoverGroupReplicationRoleValues() []FailoverGroupReplicationRole {
	return []FailoverGroupReplicationRole{Primary, Secondary}
}

// GeoBackupPolicyState enumerates the values for geo backup policy state.
type GeoBackupPolicyState string

const (
	// GeoBackupPolicyStateDisabled ...
	GeoBackupPolicyStateDisabled GeoBackupPolicyState = "Disabled"
	// GeoBackupPolicyStateEnabled ...
	GeoBackupPolicyStateEnabled GeoBackupPolicyState = "Enabled"
)

// PossibleGeoBackupPolicyStateValues returns an array of possible values for the GeoBackupPolicyState const type.
func PossibleGeoBackupPolicyStateValues() []GeoBackupPolicyState {
	return []GeoBackupPolicyState{GeoBackupPolicyStateDisabled, GeoBackupPolicyStateEnabled}
}

// IdentityType enumerates the values for identity type.
type IdentityType string

const (
	// SystemAssigned ...
	SystemAssigned IdentityType = "SystemAssigned"
)

// PossibleIdentityTypeValues returns an array of possible values for the IdentityType const type.
func PossibleIdentityTypeValues() []IdentityType {
	return []IdentityType{SystemAssigned}
}

// ManagedInstanceLicenseType enumerates the values for managed instance license type.
type ManagedInstanceLicenseType string

const (
	// BasePrice ...
	BasePrice ManagedInstanceLicenseType = "BasePrice"
	// LicenseIncluded ...
	LicenseIncluded ManagedInstanceLicenseType = "LicenseIncluded"
)

// PossibleManagedInstanceLicenseTypeValues returns an array of possible values for the ManagedInstanceLicenseType const type.
func PossibleManagedInstanceLicenseTypeValues() []ManagedInstanceLicenseType {
	return []ManagedInstanceLicenseType{BasePrice, LicenseIncluded}
}

// ManagedInstanceProxyOverride enumerates the values for managed instance proxy override.
type ManagedInstanceProxyOverride string

const (
	// ManagedInstanceProxyOverrideDefault ...
	ManagedInstanceProxyOverrideDefault ManagedInstanceProxyOverride = "Default"
	// ManagedInstanceProxyOverrideProxy ...
	ManagedInstanceProxyOverrideProxy ManagedInstanceProxyOverride = "Proxy"
	// ManagedInstanceProxyOverrideRedirect ...
	ManagedInstanceProxyOverrideRedirect ManagedInstanceProxyOverride = "Redirect"
)

// PossibleManagedInstanceProxyOverrideValues returns an array of possible values for the ManagedInstanceProxyOverride const type.
func PossibleManagedInstanceProxyOverrideValues() []ManagedInstanceProxyOverride {
	return []ManagedInstanceProxyOverride{ManagedInstanceProxyOverrideDefault, ManagedInstanceProxyOverrideProxy, ManagedInstanceProxyOverrideRedirect}
}

// ManagedServerCreateMode enumerates the values for managed server create mode.
type ManagedServerCreateMode string

const (
	// ManagedServerCreateModeDefault ...
	ManagedServerCreateModeDefault ManagedServerCreateMode = "Default"
	// ManagedServerCreateModePointInTimeRestore ...
	ManagedServerCreateModePointInTimeRestore ManagedServerCreateMode = "PointInTimeRestore"
)

// PossibleManagedServerCreateModeValues returns an array of possible values for the ManagedServerCreateMode const type.
func PossibleManagedServerCreateModeValues() []ManagedServerCreateMode {
	return []ManagedServerCreateMode{ManagedServerCreateModeDefault, ManagedServerCreateModePointInTimeRestore}
}

// MaxSizeUnits enumerates the values for max size units.
type MaxSizeUnits string

const (
	// Gigabytes ...
	Gigabytes MaxSizeUnits = "Gigabytes"
	// Megabytes ...
	Megabytes MaxSizeUnits = "Megabytes"
	// Petabytes ...
	Petabytes MaxSizeUnits = "Petabytes"
	// Terabytes ...
	Terabytes MaxSizeUnits = "Terabytes"
)

// PossibleMaxSizeUnitsValues returns an array of possible values for the MaxSizeUnits const type.
func PossibleMaxSizeUnitsValues() []MaxSizeUnits {
	return []MaxSizeUnits{Gigabytes, Megabytes, Petabytes, Terabytes}
}

// OperationOrigin enumerates the values for operation origin.
type OperationOrigin string

const (
	// OperationOriginSystem ...
	OperationOriginSystem OperationOrigin = "system"
	// OperationOriginUser ...
	OperationOriginUser OperationOrigin = "user"
)

// PossibleOperationOriginValues returns an array of possible values for the OperationOrigin const type.
func PossibleOperationOriginValues() []OperationOrigin {
	return []OperationOrigin{OperationOriginSystem, OperationOriginUser}
}

// PerformanceLevelUnit enumerates the values for performance level unit.
type PerformanceLevelUnit string

const (
	// DTU ...
	DTU PerformanceLevelUnit = "DTU"
)

// PossiblePerformanceLevelUnitValues returns an array of possible values for the PerformanceLevelUnit const type.
func PossiblePerformanceLevelUnitValues() []PerformanceLevelUnit {
	return []PerformanceLevelUnit{DTU}
}

// PrimaryAggregationType enumerates the values for primary aggregation type.
type PrimaryAggregationType string

const (
	// Average ...
	Average PrimaryAggregationType = "Average"
	// Count ...
	Count PrimaryAggregationType = "Count"
	// Maximum ...
	Maximum PrimaryAggregationType = "Maximum"
	// Minimum ...
	Minimum PrimaryAggregationType = "Minimum"
	// None ...
	None PrimaryAggregationType = "None"
	// Total ...
	Total PrimaryAggregationType = "Total"
)

// PossiblePrimaryAggregationTypeValues returns an array of possible values for the PrimaryAggregationType const type.
func PossiblePrimaryAggregationTypeValues() []PrimaryAggregationType {
	return []PrimaryAggregationType{Average, Count, Maximum, Minimum, None, Total}
}

// ReadOnlyEndpointFailoverPolicy enumerates the values for read only endpoint failover policy.
type ReadOnlyEndpointFailoverPolicy string

const (
	// ReadOnlyEndpointFailoverPolicyDisabled ...
	ReadOnlyEndpointFailoverPolicyDisabled ReadOnlyEndpointFailoverPolicy = "Disabled"
	// ReadOnlyEndpointFailoverPolicyEnabled ...
	ReadOnlyEndpointFailoverPolicyEnabled ReadOnlyEndpointFailoverPolicy = "Enabled"
)

// PossibleReadOnlyEndpointFailoverPolicyValues returns an array of possible values for the ReadOnlyEndpointFailoverPolicy const type.
func PossibleReadOnlyEndpointFailoverPolicyValues() []ReadOnlyEndpointFailoverPolicy {
	return []ReadOnlyEndpointFailoverPolicy{ReadOnlyEndpointFailoverPolicyDisabled, ReadOnlyEndpointFailoverPolicyEnabled}
}

// ReadScale enumerates the values for read scale.
type ReadScale string

const (
	// ReadScaleDisabled ...
	ReadScaleDisabled ReadScale = "Disabled"
	// ReadScaleEnabled ...
	ReadScaleEnabled ReadScale = "Enabled"
)

// PossibleReadScaleValues returns an array of possible values for the ReadScale const type.
func PossibleReadScaleValues() []ReadScale {
	return []ReadScale{ReadScaleDisabled, ReadScaleEnabled}
}

// ReadWriteEndpointFailoverPolicy enumerates the values for read write endpoint failover policy.
type ReadWriteEndpointFailoverPolicy string

const (
	// Automatic ...
	Automatic ReadWriteEndpointFailoverPolicy = "Automatic"
	// Manual ...
	Manual ReadWriteEndpointFailoverPolicy = "Manual"
)

// PossibleReadWriteEndpointFailoverPolicyValues returns an array of possible values for the ReadWriteEndpointFailoverPolicy const type.
func PossibleReadWriteEndpointFailoverPolicyValues() []ReadWriteEndpointFailoverPolicy {
	return []ReadWriteEndpointFailoverPolicy{Automatic, Manual}
}

// RecommendedIndexAction enumerates the values for recommended index action.
type RecommendedIndexAction string

const (
	// Create ...
	Create RecommendedIndexAction = "Create"
	// Drop ...
	Drop RecommendedIndexAction = "Drop"
	// Rebuild ...
	Rebuild RecommendedIndexAction = "Rebuild"
)

// PossibleRecommendedIndexActionValues returns an array of possible values for the RecommendedIndexAction const type.
func PossibleRecommendedIndexActionValues() []RecommendedIndexAction {
	return []RecommendedIndexAction{Create, Drop, Rebuild}
}

// RecommendedIndexState enumerates the values for recommended index state.
type RecommendedIndexState string

const (
	// Active ...
	Active RecommendedIndexState = "Active"
	// Blocked ...
	Blocked RecommendedIndexState = "Blocked"
	// Executing ...
	Executing RecommendedIndexState = "Executing"
	// Expired ...
	Expired RecommendedIndexState = "Expired"
	// Ignored ...
	Ignored RecommendedIndexState = "Ignored"
	// Pending ...
	Pending RecommendedIndexState = "Pending"
	// PendingRevert ...
	PendingRevert RecommendedIndexState = "Pending Revert"
	// Reverted ...
	Reverted RecommendedIndexState = "Reverted"
	// Reverting ...
	Reverting RecommendedIndexState = "Reverting"
	// Success ...
	Success RecommendedIndexState = "Success"
	// Verifying ...
	Verifying RecommendedIndexState = "Verifying"
)

// PossibleRecommendedIndexStateValues returns an array of possible values for the RecommendedIndexState const type.
func PossibleRecommendedIndexStateValues() []RecommendedIndexState {
	return []RecommendedIndexState{Active, Blocked, Executing, Expired, Ignored, Pending, PendingRevert, Reverted, Reverting, Success, Verifying}
}

// RecommendedIndexType enumerates the values for recommended index type.
type RecommendedIndexType string

const (
	// CLUSTERED ...
	CLUSTERED RecommendedIndexType = "CLUSTERED"
	// CLUSTEREDCOLUMNSTORE ...
	CLUSTEREDCOLUMNSTORE RecommendedIndexType = "CLUSTERED COLUMNSTORE"
	// COLUMNSTORE ...
	COLUMNSTORE RecommendedIndexType = "COLUMNSTORE"
	// NONCLUSTERED ...
	NONCLUSTERED RecommendedIndexType = "NONCLUSTERED"
)

// PossibleRecommendedIndexTypeValues returns an array of possible values for the RecommendedIndexType const type.
func PossibleRecommendedIndexTypeValues() []RecommendedIndexType {
	return []RecommendedIndexType{CLUSTERED, CLUSTEREDCOLUMNSTORE, COLUMNSTORE, NONCLUSTERED}
}

// ReplicationRole enumerates the values for replication role.
type ReplicationRole string

const (
	// ReplicationRoleCopy ...
	ReplicationRoleCopy ReplicationRole = "Copy"
	// ReplicationRoleNonReadableSecondary ...
	ReplicationRoleNonReadableSecondary ReplicationRole = "NonReadableSecondary"
	// ReplicationRolePrimary ...
	ReplicationRolePrimary ReplicationRole = "Primary"
	// ReplicationRoleSecondary ...
	ReplicationRoleSecondary ReplicationRole = "Secondary"
	// ReplicationRoleSource ...
	ReplicationRoleSource ReplicationRole = "Source"
)

// PossibleReplicationRoleValues returns an array of possible values for the ReplicationRole const type.
func PossibleReplicationRoleValues() []ReplicationRole {
	return []ReplicationRole{ReplicationRoleCopy, ReplicationRoleNonReadableSecondary, ReplicationRolePrimary, ReplicationRoleSecondary, ReplicationRoleSource}
}

// ReplicationState enumerates the values for replication state.
type ReplicationState string

const (
	// CATCHUP ...
	CATCHUP ReplicationState = "CATCH_UP"
	// PENDING ...
	PENDING ReplicationState = "PENDING"
	// SEEDING ...
	SEEDING ReplicationState = "SEEDING"
	// SUSPENDED ...
	SUSPENDED ReplicationState = "SUSPENDED"
)

// PossibleReplicationStateValues returns an array of possible values for the ReplicationState const type.
func PossibleReplicationStateValues() []ReplicationState {
	return []ReplicationState{CATCHUP, PENDING, SEEDING, SUSPENDED}
}

// RestorePointType enumerates the values for restore point type.
type RestorePointType string

const (
	// CONTINUOUS ...
	CONTINUOUS RestorePointType = "CONTINUOUS"
	// DISCRETE ...
	DISCRETE RestorePointType = "DISCRETE"
)

// PossibleRestorePointTypeValues returns an array of possible values for the RestorePointType const type.
func PossibleRestorePointTypeValues() []RestorePointType {
	return []RestorePointType{CONTINUOUS, DISCRETE}
}

// SampleName enumerates the values for sample name.
type SampleName string

const (
	// AdventureWorksLT ...
	AdventureWorksLT SampleName = "AdventureWorksLT"
)

// PossibleSampleNameValues returns an array of possible values for the SampleName const type.
func PossibleSampleNameValues() []SampleName {
	return []SampleName{AdventureWorksLT}
}

// SecurityAlertPolicyEmailAccountAdmins enumerates the values for security alert policy email account admins.
type SecurityAlertPolicyEmailAccountAdmins string

const (
	// SecurityAlertPolicyEmailAccountAdminsDisabled ...
	SecurityAlertPolicyEmailAccountAdminsDisabled SecurityAlertPolicyEmailAccountAdmins = "Disabled"
	// SecurityAlertPolicyEmailAccountAdminsEnabled ...
	SecurityAlertPolicyEmailAccountAdminsEnabled SecurityAlertPolicyEmailAccountAdmins = "Enabled"
)

// PossibleSecurityAlertPolicyEmailAccountAdminsValues returns an array of possible values for the SecurityAlertPolicyEmailAccountAdmins const type.
func PossibleSecurityAlertPolicyEmailAccountAdminsValues() []SecurityAlertPolicyEmailAccountAdmins {
	return []SecurityAlertPolicyEmailAccountAdmins{SecurityAlertPolicyEmailAccountAdminsDisabled, SecurityAlertPolicyEmailAccountAdminsEnabled}
}

// SecurityAlertPolicyState enumerates the values for security alert policy state.
type SecurityAlertPolicyState string

const (
	// SecurityAlertPolicyStateDisabled ...
	SecurityAlertPolicyStateDisabled SecurityAlertPolicyState = "Disabled"
	// SecurityAlertPolicyStateEnabled ...
	SecurityAlertPolicyStateEnabled SecurityAlertPolicyState = "Enabled"
	// SecurityAlertPolicyStateNew ...
	SecurityAlertPolicyStateNew SecurityAlertPolicyState = "New"
)

// PossibleSecurityAlertPolicyStateValues returns an array of possible values for the SecurityAlertPolicyState const type.
func PossibleSecurityAlertPolicyStateValues() []SecurityAlertPolicyState {
	return []SecurityAlertPolicyState{SecurityAlertPolicyStateDisabled, SecurityAlertPolicyStateEnabled, SecurityAlertPolicyStateNew}
}

// SecurityAlertPolicyUseServerDefault enumerates the values for security alert policy use server default.
type SecurityAlertPolicyUseServerDefault string

const (
	// SecurityAlertPolicyUseServerDefaultDisabled ...
	SecurityAlertPolicyUseServerDefaultDisabled SecurityAlertPolicyUseServerDefault = "Disabled"
	// SecurityAlertPolicyUseServerDefaultEnabled ...
	SecurityAlertPolicyUseServerDefaultEnabled SecurityAlertPolicyUseServerDefault = "Enabled"
)

// PossibleSecurityAlertPolicyUseServerDefaultValues returns an array of possible values for the SecurityAlertPolicyUseServerDefault const type.
func PossibleSecurityAlertPolicyUseServerDefaultValues() []SecurityAlertPolicyUseServerDefault {
	return []SecurityAlertPolicyUseServerDefault{SecurityAlertPolicyUseServerDefaultDisabled, SecurityAlertPolicyUseServerDefaultEnabled}
}

// ServerConnectionType enumerates the values for server connection type.
type ServerConnectionType string

const (
	// ServerConnectionTypeDefault ...
	ServerConnectionTypeDefault ServerConnectionType = "Default"
	// ServerConnectionTypeProxy ...
	ServerConnectionTypeProxy ServerConnectionType = "Proxy"
	// ServerConnectionTypeRedirect ...
	ServerConnectionTypeRedirect ServerConnectionType = "Redirect"
)

// PossibleServerConnectionTypeValues returns an array of possible values for the ServerConnectionType const type.
func PossibleServerConnectionTypeValues() []ServerConnectionType {
	return []ServerConnectionType{ServerConnectionTypeDefault, ServerConnectionTypeProxy, ServerConnectionTypeRedirect}
}

// ServerKeyType enumerates the values for server key type.
type ServerKeyType string

const (
	// AzureKeyVault ...
	AzureKeyVault ServerKeyType = "AzureKeyVault"
	// ServiceManaged ...
	ServiceManaged ServerKeyType = "ServiceManaged"
)

// PossibleServerKeyTypeValues returns an array of possible values for the ServerKeyType const type.
func PossibleServerKeyTypeValues() []ServerKeyType {
	return []ServerKeyType{AzureKeyVault, ServiceManaged}
}

// ServiceObjectiveName enumerates the values for service objective name.
type ServiceObjectiveName string

const (
	// ServiceObjectiveNameBasic ...
	ServiceObjectiveNameBasic ServiceObjectiveName = "Basic"
	// ServiceObjectiveNameDS100 ...
	ServiceObjectiveNameDS100 ServiceObjectiveName = "DS100"
	// ServiceObjectiveNameDS1000 ...
	ServiceObjectiveNameDS1000 ServiceObjectiveName = "DS1000"
	// ServiceObjectiveNameDS1200 ...
	ServiceObjectiveNameDS1200 ServiceObjectiveName = "DS1200"
	// ServiceObjectiveNameDS1500 ...
	ServiceObjectiveNameDS1500 ServiceObjectiveName = "DS1500"
	// ServiceObjectiveNameDS200 ...
	ServiceObjectiveNameDS200 ServiceObjectiveName = "DS200"
	// ServiceObjectiveNameDS2000 ...
	ServiceObjectiveNameDS2000 ServiceObjectiveName = "DS2000"
	// ServiceObjectiveNameDS300 ...
	ServiceObjectiveNameDS300 ServiceObjectiveName = "DS300"
	// ServiceObjectiveNameDS400 ...
	ServiceObjectiveNameDS400 ServiceObjectiveName = "DS400"
	// ServiceObjectiveNameDS500 ...
	ServiceObjectiveNameDS500 ServiceObjectiveName = "DS500"
	// ServiceObjectiveNameDS600 ...
	ServiceObjectiveNameDS600 ServiceObjectiveName = "DS600"
	// ServiceObjectiveNameDW100 ...
	ServiceObjectiveNameDW100 ServiceObjectiveName = "DW100"
	// ServiceObjectiveNameDW1000 ...
	ServiceObjectiveNameDW1000 ServiceObjectiveName = "DW1000"
	// ServiceObjectiveNameDW10000c ...
	ServiceObjectiveNameDW10000c ServiceObjectiveName = "DW10000c"
	// ServiceObjectiveNameDW1000c ...
	ServiceObjectiveNameDW1000c ServiceObjectiveName = "DW1000c"
	// ServiceObjectiveNameDW1200 ...
	ServiceObjectiveNameDW1200 ServiceObjectiveName = "DW1200"
	// ServiceObjectiveNameDW1500 ...
	ServiceObjectiveNameDW1500 ServiceObjectiveName = "DW1500"
	// ServiceObjectiveNameDW15000c ...
	ServiceObjectiveNameDW15000c ServiceObjectiveName = "DW15000c"
	// ServiceObjectiveNameDW1500c ...
	ServiceObjectiveNameDW1500c ServiceObjectiveName = "DW1500c"
	// ServiceObjectiveNameDW200 ...
	ServiceObjectiveNameDW200 ServiceObjectiveName = "DW200"
	// ServiceObjectiveNameDW2000 ...
	ServiceObjectiveNameDW2000 ServiceObjectiveName = "DW2000"
	// ServiceObjectiveNameDW2000c ...
	ServiceObjectiveNameDW2000c ServiceObjectiveName = "DW2000c"
	// ServiceObjectiveNameDW2500c ...
	ServiceObjectiveNameDW2500c ServiceObjectiveName = "DW2500c"
	// ServiceObjectiveNameDW300 ...
	ServiceObjectiveNameDW300 ServiceObjectiveName = "DW300"
	// ServiceObjectiveNameDW3000 ...
	ServiceObjectiveNameDW3000 ServiceObjectiveName = "DW3000"
	// ServiceObjectiveNameDW30000c ...
	ServiceObjectiveNameDW30000c ServiceObjectiveName = "DW30000c"
	// ServiceObjectiveNameDW3000c ...
	ServiceObjectiveNameDW3000c ServiceObjectiveName = "DW3000c"
	// ServiceObjectiveNameDW400 ...
	ServiceObjectiveNameDW400 ServiceObjectiveName = "DW400"
	// ServiceObjectiveNameDW500 ...
	ServiceObjectiveNameDW500 ServiceObjectiveName = "DW500"
	// ServiceObjectiveNameDW5000c ...
	ServiceObjectiveNameDW5000c ServiceObjectiveName = "DW5000c"
	// ServiceObjectiveNameDW600 ...
	ServiceObjectiveNameDW600 ServiceObjectiveName = "DW600"
	// ServiceObjectiveNameDW6000 ...
	ServiceObjectiveNameDW6000 ServiceObjectiveName = "DW6000"
	// ServiceObjectiveNameDW6000c ...
	ServiceObjectiveNameDW6000c ServiceObjectiveName = "DW6000c"
	// ServiceObjectiveNameDW7500c ...
	ServiceObjectiveNameDW7500c ServiceObjectiveName = "DW7500c"
	// ServiceObjectiveNameElasticPool ...
	ServiceObjectiveNameElasticPool ServiceObjectiveName = "ElasticPool"
	// ServiceObjectiveNameFree ...
	ServiceObjectiveNameFree ServiceObjectiveName = "Free"
	// ServiceObjectiveNameP1 ...
	ServiceObjectiveNameP1 ServiceObjectiveName = "P1"
	// ServiceObjectiveNameP11 ...
	ServiceObjectiveNameP11 ServiceObjectiveName = "P11"
	// ServiceObjectiveNameP15 ...
	ServiceObjectiveNameP15 ServiceObjectiveName = "P15"
	// ServiceObjectiveNameP2 ...
	ServiceObjectiveNameP2 ServiceObjectiveName = "P2"
	// ServiceObjectiveNameP3 ...
	ServiceObjectiveNameP3 ServiceObjectiveName = "P3"
	// ServiceObjectiveNameP4 ...
	ServiceObjectiveNameP4 ServiceObjectiveName = "P4"
	// ServiceObjectiveNameP6 ...
	ServiceObjectiveNameP6 ServiceObjectiveName = "P6"
	// ServiceObjectiveNamePRS1 ...
	ServiceObjectiveNamePRS1 ServiceObjectiveName = "PRS1"
	// ServiceObjectiveNamePRS2 ...
	ServiceObjectiveNamePRS2 ServiceObjectiveName = "PRS2"
	// ServiceObjectiveNamePRS4 ...
	ServiceObjectiveNamePRS4 ServiceObjectiveName = "PRS4"
	// ServiceObjectiveNamePRS6 ...
	ServiceObjectiveNamePRS6 ServiceObjectiveName = "PRS6"
	// ServiceObjectiveNameS0 ...
	ServiceObjectiveNameS0 ServiceObjectiveName = "S0"
	// ServiceObjectiveNameS1 ...
	ServiceObjectiveNameS1 ServiceObjectiveName = "S1"
	// ServiceObjectiveNameS12 ...
	ServiceObjectiveNameS12 ServiceObjectiveName = "S12"
	// ServiceObjectiveNameS2 ...
	ServiceObjectiveNameS2 ServiceObjectiveName = "S2"
	// ServiceObjectiveNameS3 ...
	ServiceObjectiveNameS3 ServiceObjectiveName = "S3"
	// ServiceObjectiveNameS4 ...
	ServiceObjectiveNameS4 ServiceObjectiveName = "S4"
	// ServiceObjectiveNameS6 ...
	ServiceObjectiveNameS6 ServiceObjectiveName = "S6"
	// ServiceObjectiveNameS7 ...
	ServiceObjectiveNameS7 ServiceObjectiveName = "S7"
	// ServiceObjectiveNameS9 ...
	ServiceObjectiveNameS9 ServiceObjectiveName = "S9"
	// ServiceObjectiveNameSystem ...
	ServiceObjectiveNameSystem ServiceObjectiveName = "System"
	// ServiceObjectiveNameSystem0 ...
	ServiceObjectiveNameSystem0 ServiceObjectiveName = "System0"
	// ServiceObjectiveNameSystem1 ...
	ServiceObjectiveNameSystem1 ServiceObjectiveName = "System1"
	// ServiceObjectiveNameSystem2 ...
	ServiceObjectiveNameSystem2 ServiceObjectiveName = "System2"
	// ServiceObjectiveNameSystem2L ...
	ServiceObjectiveNameSystem2L ServiceObjectiveName = "System2L"
	// ServiceObjectiveNameSystem3 ...
	ServiceObjectiveNameSystem3 ServiceObjectiveName = "System3"
	// ServiceObjectiveNameSystem3L ...
	ServiceObjectiveNameSystem3L ServiceObjectiveName = "System3L"
	// ServiceObjectiveNameSystem4 ...
	ServiceObjectiveNameSystem4 ServiceObjectiveName = "System4"
	// ServiceObjectiveNameSystem4L ...
	ServiceObjectiveNameSystem4L ServiceObjectiveName = "System4L"
)

// PossibleServiceObjectiveNameValues returns an array of possible values for the ServiceObjectiveName const type.
func PossibleServiceObjectiveNameValues() []ServiceObjectiveName {
	return []ServiceObjectiveName{ServiceObjectiveNameBasic, ServiceObjectiveNameDS100, ServiceObjectiveNameDS1000, ServiceObjectiveNameDS1200, ServiceObjectiveNameDS1500, ServiceObjectiveNameDS200, ServiceObjectiveNameDS2000, ServiceObjectiveNameDS300, ServiceObjectiveNameDS400, ServiceObjectiveNameDS500, ServiceObjectiveNameDS600, ServiceObjectiveNameDW100, ServiceObjectiveNameDW1000, ServiceObjectiveNameDW10000c, ServiceObjectiveNameDW1000c, ServiceObjectiveNameDW1200, ServiceObjectiveNameDW1500, ServiceObjectiveNameDW15000c, ServiceObjectiveNameDW1500c, ServiceObjectiveNameDW200, ServiceObjectiveNameDW2000, ServiceObjectiveNameDW2000c, ServiceObjectiveNameDW2500c, ServiceObjectiveNameDW300, ServiceObjectiveNameDW3000, ServiceObjectiveNameDW30000c, ServiceObjectiveNameDW3000c, ServiceObjectiveNameDW400, ServiceObjectiveNameDW500, ServiceObjectiveNameDW5000c, ServiceObjectiveNameDW600, ServiceObjectiveNameDW6000, ServiceObjectiveNameDW6000c, ServiceObjectiveNameDW7500c, ServiceObjectiveNameElasticPool, ServiceObjectiveNameFree, ServiceObjectiveNameP1, ServiceObjectiveNameP11, ServiceObjectiveNameP15, ServiceObjectiveNameP2, ServiceObjectiveNameP3, ServiceObjectiveNameP4, ServiceObjectiveNameP6, ServiceObjectiveNamePRS1, ServiceObjectiveNamePRS2, ServiceObjectiveNamePRS4, ServiceObjectiveNamePRS6, ServiceObjectiveNameS0, ServiceObjectiveNameS1, ServiceObjectiveNameS12, ServiceObjectiveNameS2, ServiceObjectiveNameS3, ServiceObjectiveNameS4, ServiceObjectiveNameS6, ServiceObjectiveNameS7, ServiceObjectiveNameS9, ServiceObjectiveNameSystem, ServiceObjectiveNameSystem0, ServiceObjectiveNameSystem1, ServiceObjectiveNameSystem2, ServiceObjectiveNameSystem2L, ServiceObjectiveNameSystem3, ServiceObjectiveNameSystem3L, ServiceObjectiveNameSystem4, ServiceObjectiveNameSystem4L}
}

// StorageKeyType enumerates the values for storage key type.
type StorageKeyType string

const (
	// SharedAccessKey ...
	SharedAccessKey StorageKeyType = "SharedAccessKey"
	// StorageAccessKey ...
	StorageAccessKey StorageKeyType = "StorageAccessKey"
)

// PossibleStorageKeyTypeValues returns an array of possible values for the StorageKeyType const type.
func PossibleStorageKeyTypeValues() []StorageKeyType {
	return []StorageKeyType{SharedAccessKey, StorageAccessKey}
}

// SyncAgentState enumerates the values for sync agent state.
type SyncAgentState string

const (
	// NeverConnected ...
	NeverConnected SyncAgentState = "NeverConnected"
	// Offline ...
	Offline SyncAgentState = "Offline"
	// Online ...
	Online SyncAgentState = "Online"
)

// PossibleSyncAgentStateValues returns an array of possible values for the SyncAgentState const type.
func PossibleSyncAgentStateValues() []SyncAgentState {
	return []SyncAgentState{NeverConnected, Offline, Online}
}

// SyncConflictResolutionPolicy enumerates the values for sync conflict resolution policy.
type SyncConflictResolutionPolicy string

const (
	// HubWin ...
	HubWin SyncConflictResolutionPolicy = "HubWin"
	// MemberWin ...
	MemberWin SyncConflictResolutionPolicy = "MemberWin"
)

// PossibleSyncConflictResolutionPolicyValues returns an array of possible values for the SyncConflictResolutionPolicy const type.
func PossibleSyncConflictResolutionPolicyValues() []SyncConflictResolutionPolicy {
	return []SyncConflictResolutionPolicy{HubWin, MemberWin}
}

// SyncDirection enumerates the values for sync direction.
type SyncDirection string

const (
	// Bidirectional ...
	Bidirectional SyncDirection = "Bidirectional"
	// OneWayHubToMember ...
	OneWayHubToMember SyncDirection = "OneWayHubToMember"
	// OneWayMemberToHub ...
	OneWayMemberToHub SyncDirection = "OneWayMemberToHub"
)

// PossibleSyncDirectionValues returns an array of possible values for the SyncDirection const type.
func PossibleSyncDirectionValues() []SyncDirection {
	return []SyncDirection{Bidirectional, OneWayHubToMember, OneWayMemberToHub}
}

// SyncGroupLogType enumerates the values for sync group log type.
type SyncGroupLogType string

const (
	// SyncGroupLogTypeAll ...
	SyncGroupLogTypeAll SyncGroupLogType = "All"
	// SyncGroupLogTypeError ...
	SyncGroupLogTypeError SyncGroupLogType = "Error"
	// SyncGroupLogTypeSuccess ...
	SyncGroupLogTypeSuccess SyncGroupLogType = "Success"
	// SyncGroupLogTypeWarning ...
	SyncGroupLogTypeWarning SyncGroupLogType = "Warning"
)

// PossibleSyncGroupLogTypeValues returns an array of possible values for the SyncGroupLogType const type.
func PossibleSyncGroupLogTypeValues() []SyncGroupLogType {
	return []SyncGroupLogType{SyncGroupLogTypeAll, SyncGroupLogTypeError, SyncGroupLogTypeSuccess, SyncGroupLogTypeWarning}
}

// SyncGroupState enumerates the values for sync group state.
type SyncGroupState string

const (
	// Error ...
	Error SyncGroupState = "Error"
	// Good ...
	Good SyncGroupState = "Good"
	// NotReady ...
	NotReady SyncGroupState = "NotReady"
	// Progressing ...
	Progressing SyncGroupState = "Progressing"
	// Warning ...
	Warning SyncGroupState = "Warning"
)

// PossibleSyncGroupStateValues returns an array of possible values for the SyncGroupState const type.
func PossibleSyncGroupStateValues() []SyncGroupState {
	return []SyncGroupState{Error, Good, NotReady, Progressing, Warning}
}

// SyncMemberDbType enumerates the values for sync member db type.
type SyncMemberDbType string

const (
	// AzureSQLDatabase ...
	AzureSQLDatabase SyncMemberDbType = "AzureSqlDatabase"
	// SQLServerDatabase ...
	SQLServerDatabase SyncMemberDbType = "SqlServerDatabase"
)

// PossibleSyncMemberDbTypeValues returns an array of possible values for the SyncMemberDbType const type.
func PossibleSyncMemberDbTypeValues() []SyncMemberDbType {
	return []SyncMemberDbType{AzureSQLDatabase, SQLServerDatabase}
}

// SyncMemberState enumerates the values for sync member state.
type SyncMemberState string

const (
	// DeProvisioned ...
	DeProvisioned SyncMemberState = "DeProvisioned"
	// DeProvisionFailed ...
	DeProvisionFailed SyncMemberState = "DeProvisionFailed"
	// DeProvisioning ...
	DeProvisioning SyncMemberState = "DeProvisioning"
	// DisabledBackupRestore ...
	DisabledBackupRestore SyncMemberState = "DisabledBackupRestore"
	// DisabledTombstoneCleanup ...
	DisabledTombstoneCleanup SyncMemberState = "DisabledTombstoneCleanup"
	// Provisioned ...
	Provisioned SyncMemberState = "Provisioned"
	// ProvisionFailed ...
	ProvisionFailed SyncMemberState = "ProvisionFailed"
	// Provisioning ...
	Provisioning SyncMemberState = "Provisioning"
	// ReprovisionFailed ...
	ReprovisionFailed SyncMemberState = "ReprovisionFailed"
	// Reprovisioning ...
	Reprovisioning SyncMemberState = "Reprovisioning"
	// SyncCancelled ...
	SyncCancelled SyncMemberState = "SyncCancelled"
	// SyncCancelling ...
	SyncCancelling SyncMemberState = "SyncCancelling"
	// SyncFailed ...
	SyncFailed SyncMemberState = "SyncFailed"
	// SyncInProgress ...
	SyncInProgress SyncMemberState = "SyncInProgress"
	// SyncSucceeded ...
	SyncSucceeded SyncMemberState = "SyncSucceeded"
	// SyncSucceededWithWarnings ...
	SyncSucceededWithWarnings SyncMemberState = "SyncSucceededWithWarnings"
	// UnProvisioned ...
	UnProvisioned SyncMemberState = "UnProvisioned"
	// UnReprovisioned ...
	UnReprovisioned SyncMemberState = "UnReprovisioned"
)

// PossibleSyncMemberStateValues returns an array of possible values for the SyncMemberState const type.
func PossibleSyncMemberStateValues() []SyncMemberState {
	return []SyncMemberState{DeProvisioned, DeProvisionFailed, DeProvisioning, DisabledBackupRestore, DisabledTombstoneCleanup, Provisioned, ProvisionFailed, Provisioning, ReprovisionFailed, Reprovisioning, SyncCancelled, SyncCancelling, SyncFailed, SyncInProgress, SyncSucceeded, SyncSucceededWithWarnings, UnProvisioned, UnReprovisioned}
}

// TransparentDataEncryptionActivityStatus enumerates the values for transparent data encryption activity
// status.
type TransparentDataEncryptionActivityStatus string

const (
	// Decrypting ...
	Decrypting TransparentDataEncryptionActivityStatus = "Decrypting"
	// Encrypting ...
	Encrypting TransparentDataEncryptionActivityStatus = "Encrypting"
)

// PossibleTransparentDataEncryptionActivityStatusValues returns an array of possible values for the TransparentDataEncryptionActivityStatus const type.
func PossibleTransparentDataEncryptionActivityStatusValues() []TransparentDataEncryptionActivityStatus {
	return []TransparentDataEncryptionActivityStatus{Decrypting, Encrypting}
}

// TransparentDataEncryptionStatus enumerates the values for transparent data encryption status.
type TransparentDataEncryptionStatus string

const (
	// TransparentDataEncryptionStatusDisabled ...
	TransparentDataEncryptionStatusDisabled TransparentDataEncryptionStatus = "Disabled"
	// TransparentDataEncryptionStatusEnabled ...
	TransparentDataEncryptionStatusEnabled TransparentDataEncryptionStatus = "Enabled"
)

// PossibleTransparentDataEncryptionStatusValues returns an array of possible values for the TransparentDataEncryptionStatus const type.
func PossibleTransparentDataEncryptionStatusValues() []TransparentDataEncryptionStatus {
	return []TransparentDataEncryptionStatus{TransparentDataEncryptionStatusDisabled, TransparentDataEncryptionStatusEnabled}
}

// UnitDefinitionType enumerates the values for unit definition type.
type UnitDefinitionType string

const (
	// UnitDefinitionTypeBytes ...
	UnitDefinitionTypeBytes UnitDefinitionType = "Bytes"
	// UnitDefinitionTypeBytesPerSecond ...
	UnitDefinitionTypeBytesPerSecond UnitDefinitionType = "BytesPerSecond"
	// UnitDefinitionTypeCount ...
	UnitDefinitionTypeCount UnitDefinitionType = "Count"
	// UnitDefinitionTypeCountPerSecond ...
	UnitDefinitionTypeCountPerSecond UnitDefinitionType = "CountPerSecond"
	// UnitDefinitionTypePercent ...
	UnitDefinitionTypePercent UnitDefinitionType = "Percent"
	// UnitDefinitionTypeSeconds ...
	UnitDefinitionTypeSeconds UnitDefinitionType = "Seconds"
)

// PossibleUnitDefinitionTypeValues returns an array of possible values for the UnitDefinitionType const type.
func PossibleUnitDefinitionTypeValues() []UnitDefinitionType {
	return []UnitDefinitionType{UnitDefinitionTypeBytes, UnitDefinitionTypeBytesPerSecond, UnitDefinitionTypeCount, UnitDefinitionTypeCountPerSecond, UnitDefinitionTypePercent, UnitDefinitionTypeSeconds}
}

// UnitType enumerates the values for unit type.
type UnitType string

const (
	// UnitTypeBytes ...
	UnitTypeBytes UnitType = "bytes"
	// UnitTypeBytesPerSecond ...
	UnitTypeBytesPerSecond UnitType = "bytesPerSecond"
	// UnitTypeCount ...
	UnitTypeCount UnitType = "count"
	// UnitTypeCountPerSecond ...
	UnitTypeCountPerSecond UnitType = "countPerSecond"
	// UnitTypePercent ...
	UnitTypePercent UnitType = "percent"
	// UnitTypeSeconds ...
	UnitTypeSeconds UnitType = "seconds"
)

// PossibleUnitTypeValues returns an array of possible values for the UnitType const type.
func PossibleUnitTypeValues() []UnitType {
	return []UnitType{UnitTypeBytes, UnitTypeBytesPerSecond, UnitTypeCount, UnitTypeCountPerSecond, UnitTypePercent, UnitTypeSeconds}
}

// VirtualNetworkRuleState enumerates the values for virtual network rule state.
type VirtualNetworkRuleState string

const (
	// Deleting ...
	Deleting VirtualNetworkRuleState = "Deleting"
	// Initializing ...
	Initializing VirtualNetworkRuleState = "Initializing"
	// InProgress ...
	InProgress VirtualNetworkRuleState = "InProgress"
	// Ready ...
	Ready VirtualNetworkRuleState = "Ready"
	// Unknown ...
	Unknown VirtualNetworkRuleState = "Unknown"
)

// PossibleVirtualNetworkRuleStateValues returns an array of possible values for the VirtualNetworkRuleState const type.
func PossibleVirtualNetworkRuleStateValues() []VirtualNetworkRuleState {
	return []VirtualNetworkRuleState{Deleting, Initializing, InProgress, Ready, Unknown}
}
