// Code generated by Thrift Compiler (0.16.0). DO NOT EDIT.

package osquery

import (
	"bytes"
	"context"
	"database/sql/driver"
	"errors"
	"fmt"
	thrift "github.com/apache/thrift/lib/go/thrift"
	"time"
)

// (needed to ensure safety because of naive import list construction.)
var _ = thrift.ZERO
var _ = fmt.Printf
var _ = context.Background
var _ = time.Now
var _ = bytes.Equal

type ExtensionCode int64

const (
	ExtensionCode_EXT_SUCCESS ExtensionCode = 0
	ExtensionCode_EXT_FAILED  ExtensionCode = 1
	ExtensionCode_EXT_FATAL   ExtensionCode = 2
)

func (p ExtensionCode) String() string {
	switch p {
	case ExtensionCode_EXT_SUCCESS:
		return "EXT_SUCCESS"
	case ExtensionCode_EXT_FAILED:
		return "EXT_FAILED"
	case ExtensionCode_EXT_FATAL:
		return "EXT_FATAL"
	}
	return "<UNSET>"
}

func ExtensionCodeFromString(s string) (ExtensionCode, error) {
	switch s {
	case "EXT_SUCCESS":
		return ExtensionCode_EXT_SUCCESS, nil
	case "EXT_FAILED":
		return ExtensionCode_EXT_FAILED, nil
	case "EXT_FATAL":
		return ExtensionCode_EXT_FATAL, nil
	}
	return ExtensionCode(0), fmt.Errorf("not a valid ExtensionCode string")
}

func ExtensionCodePtr(v ExtensionCode) *ExtensionCode { return &v }

func (p ExtensionCode) MarshalText() ([]byte, error) {
	return []byte(p.String()), nil
}

func (p *ExtensionCode) UnmarshalText(text []byte) error {
	q, err := ExtensionCodeFromString(string(text))
	if err != nil {
		return err
	}
	*p = q
	return nil
}

func (p *ExtensionCode) Scan(value interface{}) error {
	v, ok := value.(int64)
	if !ok {
		return errors.New("Scan value is not int64")
	}
	*p = ExtensionCode(v)
	return nil
}

func (p *ExtensionCode) Value() (driver.Value, error) {
	if p == nil {
		return nil, nil
	}
	return int64(*p), nil
}

type ExtensionPluginRequest map[string]string

func ExtensionPluginRequestPtr(v ExtensionPluginRequest) *ExtensionPluginRequest { return &v }

type ExtensionPluginResponse []map[string]string

func ExtensionPluginResponsePtr(v ExtensionPluginResponse) *ExtensionPluginResponse { return &v }

type InternalOptionList map[string]*InternalOptionInfo

func InternalOptionListPtr(v InternalOptionList) *InternalOptionList { return &v }

type ExtensionRouteUUID int64

func ExtensionRouteUUIDPtr(v ExtensionRouteUUID) *ExtensionRouteUUID { return &v }

type ExtensionRouteTable map[string]ExtensionPluginResponse

func ExtensionRouteTablePtr(v ExtensionRouteTable) *ExtensionRouteTable { return &v }

type ExtensionRegistry map[string]ExtensionRouteTable

func ExtensionRegistryPtr(v ExtensionRegistry) *ExtensionRegistry { return &v }

type InternalExtensionList map[ExtensionRouteUUID]*InternalExtensionInfo

func InternalExtensionListPtr(v InternalExtensionList) *InternalExtensionList { return &v }

// Attributes:
//  - Value
//  - DefaultValue
//  - Type
type InternalOptionInfo struct {
	Value        string `thrift:"value,1" db:"value" json:"value"`
	DefaultValue string `thrift:"default_value,2" db:"default_value" json:"default_value"`
	Type         string `thrift:"type,3" db:"type" json:"type"`
}

func NewInternalOptionInfo() *InternalOptionInfo {
	return &InternalOptionInfo{}
}

func (p *InternalOptionInfo) GetValue() string {
	return p.Value
}

func (p *InternalOptionInfo) GetDefaultValue() string {
	return p.DefaultValue
}

func (p *InternalOptionInfo) GetType() string {
	return p.Type
}
func (p *InternalOptionInfo) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *InternalOptionInfo) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.Value = v
	}
	return nil
}

func (p *InternalOptionInfo) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.DefaultValue = v
	}
	return nil
}

func (p *InternalOptionInfo) ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.Type = v
	}
	return nil
}

func (p *InternalOptionInfo) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "InternalOptionInfo"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField3(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *InternalOptionInfo) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "value", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:value: ", p), err)
	}
	if err := oprot.WriteString(ctx, string(p.Value)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.value (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:value: ", p), err)
	}
	return err
}

func (p *InternalOptionInfo) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "default_value", thrift.STRING, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:default_value: ", p), err)
	}
	if err := oprot.WriteString(ctx, string(p.DefaultValue)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.default_value (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:default_value: ", p), err)
	}
	return err
}

func (p *InternalOptionInfo) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "type", thrift.STRING, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:type: ", p), err)
	}
	if err := oprot.WriteString(ctx, string(p.Type)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.type (3) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:type: ", p), err)
	}
	return err
}

func (p *InternalOptionInfo) Equals(other *InternalOptionInfo) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.Value != other.Value {
		return false
	}
	if p.DefaultValue != other.DefaultValue {
		return false
	}
	if p.Type != other.Type {
		return false
	}
	return true
}

func (p *InternalOptionInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("InternalOptionInfo(%+v)", *p)
}

// Attributes:
//  - Name
//  - Version
//  - SdkVersion
//  - MinSdkVersion
type InternalExtensionInfo struct {
	Name          string `thrift:"name,1" db:"name" json:"name"`
	Version       string `thrift:"version,2" db:"version" json:"version"`
	SdkVersion    string `thrift:"sdk_version,3" db:"sdk_version" json:"sdk_version"`
	MinSdkVersion string `thrift:"min_sdk_version,4" db:"min_sdk_version" json:"min_sdk_version"`
}

func NewInternalExtensionInfo() *InternalExtensionInfo {
	return &InternalExtensionInfo{}
}

func (p *InternalExtensionInfo) GetName() string {
	return p.Name
}

func (p *InternalExtensionInfo) GetVersion() string {
	return p.Version
}

func (p *InternalExtensionInfo) GetSdkVersion() string {
	return p.SdkVersion
}

func (p *InternalExtensionInfo) GetMinSdkVersion() string {
	return p.MinSdkVersion
}
func (p *InternalExtensionInfo) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 4:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField4(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *InternalExtensionInfo) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.Name = v
	}
	return nil
}

func (p *InternalExtensionInfo) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.Version = v
	}
	return nil
}

func (p *InternalExtensionInfo) ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		p.SdkVersion = v
	}
	return nil
}

func (p *InternalExtensionInfo) ReadField4(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 4: ", err)
	} else {
		p.MinSdkVersion = v
	}
	return nil
}

func (p *InternalExtensionInfo) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "InternalExtensionInfo"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField3(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField4(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *InternalExtensionInfo) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "name", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:name: ", p), err)
	}
	if err := oprot.WriteString(ctx, string(p.Name)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.name (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:name: ", p), err)
	}
	return err
}

func (p *InternalExtensionInfo) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "version", thrift.STRING, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:version: ", p), err)
	}
	if err := oprot.WriteString(ctx, string(p.Version)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.version (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:version: ", p), err)
	}
	return err
}

func (p *InternalExtensionInfo) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "sdk_version", thrift.STRING, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:sdk_version: ", p), err)
	}
	if err := oprot.WriteString(ctx, string(p.SdkVersion)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.sdk_version (3) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:sdk_version: ", p), err)
	}
	return err
}

func (p *InternalExtensionInfo) writeField4(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "min_sdk_version", thrift.STRING, 4); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 4:min_sdk_version: ", p), err)
	}
	if err := oprot.WriteString(ctx, string(p.MinSdkVersion)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.min_sdk_version (4) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 4:min_sdk_version: ", p), err)
	}
	return err
}

func (p *InternalExtensionInfo) Equals(other *InternalExtensionInfo) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.Name != other.Name {
		return false
	}
	if p.Version != other.Version {
		return false
	}
	if p.SdkVersion != other.SdkVersion {
		return false
	}
	if p.MinSdkVersion != other.MinSdkVersion {
		return false
	}
	return true
}

func (p *InternalExtensionInfo) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("InternalExtensionInfo(%+v)", *p)
}

// Attributes:
//  - Code
//  - Message
//  - UUID
type ExtensionStatus struct {
	Code    int32              `thrift:"code,1" db:"code" json:"code"`
	Message string             `thrift:"message,2" db:"message" json:"message"`
	UUID    ExtensionRouteUUID `thrift:"uuid,3" db:"uuid" json:"uuid"`
}

func NewExtensionStatus() *ExtensionStatus {
	return &ExtensionStatus{}
}

func (p *ExtensionStatus) GetCode() int32 {
	return p.Code
}

func (p *ExtensionStatus) GetMessage() string {
	return p.Message
}

func (p *ExtensionStatus) GetUUID() ExtensionRouteUUID {
	return p.UUID
}
func (p *ExtensionStatus) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ExtensionStatus) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.Code = v
	}
	return nil
}

func (p *ExtensionStatus) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.Message = v
	}
	return nil
}

func (p *ExtensionStatus) ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		temp := ExtensionRouteUUID(v)
		p.UUID = temp
	}
	return nil
}

func (p *ExtensionStatus) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "ExtensionStatus"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField3(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ExtensionStatus) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "code", thrift.I32, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:code: ", p), err)
	}
	if err := oprot.WriteI32(ctx, int32(p.Code)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.code (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:code: ", p), err)
	}
	return err
}

func (p *ExtensionStatus) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "message", thrift.STRING, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:message: ", p), err)
	}
	if err := oprot.WriteString(ctx, string(p.Message)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.message (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:message: ", p), err)
	}
	return err
}

func (p *ExtensionStatus) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "uuid", thrift.I64, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:uuid: ", p), err)
	}
	if err := oprot.WriteI64(ctx, int64(p.UUID)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.uuid (3) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:uuid: ", p), err)
	}
	return err
}

func (p *ExtensionStatus) Equals(other *ExtensionStatus) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.Code != other.Code {
		return false
	}
	if p.Message != other.Message {
		return false
	}
	if p.UUID != other.UUID {
		return false
	}
	return true
}

func (p *ExtensionStatus) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ExtensionStatus(%+v)", *p)
}

// Attributes:
//  - Status
//  - Response
type ExtensionResponse struct {
	Status   *ExtensionStatus        `thrift:"status,1" db:"status" json:"status"`
	Response ExtensionPluginResponse `thrift:"response,2" db:"response" json:"response"`
}

func NewExtensionResponse() *ExtensionResponse {
	return &ExtensionResponse{}
}

var ExtensionResponse_Status_DEFAULT *ExtensionStatus

func (p *ExtensionResponse) GetStatus() *ExtensionStatus {
	if !p.IsSetStatus() {
		return ExtensionResponse_Status_DEFAULT
	}
	return p.Status
}

func (p *ExtensionResponse) GetResponse() ExtensionPluginResponse {
	return p.Response
}
func (p *ExtensionResponse) IsSetStatus() bool {
	return p.Status != nil
}

func (p *ExtensionResponse) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.LIST {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ExtensionResponse) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Status = &ExtensionStatus{}
	if err := p.Status.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Status), err)
	}
	return nil
}

func (p *ExtensionResponse) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	_, size, err := iprot.ReadListBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading list begin: ", err)
	}
	tSlice := make(ExtensionPluginResponse, 0, size)
	p.Response = tSlice
	for i := 0; i < size; i++ {
		_, _, size, err := iprot.ReadMapBegin(ctx)
		if err != nil {
			return thrift.PrependError("error reading map begin: ", err)
		}
		tMap := make(map[string]string, size)
		_elem0 := tMap
		for i := 0; i < size; i++ {
			var _key1 string
			if v, err := iprot.ReadString(ctx); err != nil {
				return thrift.PrependError("error reading field 0: ", err)
			} else {
				_key1 = v
			}
			var _val2 string
			if v, err := iprot.ReadString(ctx); err != nil {
				return thrift.PrependError("error reading field 0: ", err)
			} else {
				_val2 = v
			}
			_elem0[_key1] = _val2
		}
		if err := iprot.ReadMapEnd(ctx); err != nil {
			return thrift.PrependError("error reading map end: ", err)
		}
		p.Response = append(p.Response, _elem0)
	}
	if err := iprot.ReadListEnd(ctx); err != nil {
		return thrift.PrependError("error reading list end: ", err)
	}
	return nil
}

func (p *ExtensionResponse) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "ExtensionResponse"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ExtensionResponse) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "status", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:status: ", p), err)
	}
	if err := p.Status.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Status), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:status: ", p), err)
	}
	return err
}

func (p *ExtensionResponse) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "response", thrift.LIST, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:response: ", p), err)
	}
	if err := oprot.WriteListBegin(ctx, thrift.MAP, len(p.Response)); err != nil {
		return thrift.PrependError("error writing list begin: ", err)
	}
	for _, v := range p.Response {
		if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.STRING, len(v)); err != nil {
			return thrift.PrependError("error writing map begin: ", err)
		}
		for k, v := range v {
			if err := oprot.WriteString(ctx, string(k)); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err)
			}
			if err := oprot.WriteString(ctx, string(v)); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err)
			}
		}
		if err := oprot.WriteMapEnd(ctx); err != nil {
			return thrift.PrependError("error writing map end: ", err)
		}
	}
	if err := oprot.WriteListEnd(ctx); err != nil {
		return thrift.PrependError("error writing list end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:response: ", p), err)
	}
	return err
}

func (p *ExtensionResponse) Equals(other *ExtensionResponse) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if !p.Status.Equals(other.Status) {
		return false
	}
	if len(p.Response) != len(other.Response) {
		return false
	}
	for i, _tgt := range p.Response {
		_src3 := other.Response[i]
		if len(_tgt) != len(_src3) {
			return false
		}
		for k, _tgt := range _tgt {
			_src4 := _src3[k]
			if _tgt != _src4 {
				return false
			}
		}
	}
	return true
}

func (p *ExtensionResponse) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ExtensionResponse(%+v)", *p)
}

// Attributes:
//  - Code
//  - Message
//  - UUID
type ExtensionException struct {
	Code    int32              `thrift:"code,1" db:"code" json:"code"`
	Message string             `thrift:"message,2" db:"message" json:"message"`
	UUID    ExtensionRouteUUID `thrift:"uuid,3" db:"uuid" json:"uuid"`
}

func NewExtensionException() *ExtensionException {
	return &ExtensionException{}
}

func (p *ExtensionException) GetCode() int32 {
	return p.Code
}

func (p *ExtensionException) GetMessage() string {
	return p.Message
}

func (p *ExtensionException) GetUUID() ExtensionRouteUUID {
	return p.UUID
}
func (p *ExtensionException) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I32 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ExtensionException) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI32(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.Code = v
	}
	return nil
}

func (p *ExtensionException) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.Message = v
	}
	return nil
}

func (p *ExtensionException) ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 3: ", err)
	} else {
		temp := ExtensionRouteUUID(v)
		p.UUID = temp
	}
	return nil
}

func (p *ExtensionException) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "ExtensionException"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField3(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ExtensionException) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "code", thrift.I32, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:code: ", p), err)
	}
	if err := oprot.WriteI32(ctx, int32(p.Code)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.code (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:code: ", p), err)
	}
	return err
}

func (p *ExtensionException) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "message", thrift.STRING, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:message: ", p), err)
	}
	if err := oprot.WriteString(ctx, string(p.Message)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.message (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:message: ", p), err)
	}
	return err
}

func (p *ExtensionException) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "uuid", thrift.I64, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:uuid: ", p), err)
	}
	if err := oprot.WriteI64(ctx, int64(p.UUID)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.uuid (3) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:uuid: ", p), err)
	}
	return err
}

func (p *ExtensionException) Equals(other *ExtensionException) bool {
	if p == other {
		return true
	} else if p == nil || other == nil {
		return false
	}
	if p.Code != other.Code {
		return false
	}
	if p.Message != other.Message {
		return false
	}
	if p.UUID != other.UUID {
		return false
	}
	return true
}

func (p *ExtensionException) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ExtensionException(%+v)", *p)
}

func (p *ExtensionException) Error() string {
	return p.String()
}

func (ExtensionException) TExceptionType() thrift.TExceptionType {
	return thrift.TExceptionTypeCompiled
}

var _ thrift.TException = (*ExtensionException)(nil)

type Extension interface {
	Ping(ctx context.Context) (_r *ExtensionStatus, _err error)
	// Parameters:
	//  - Registry
	//  - Item
	//  - Request
	Call(ctx context.Context, registry string, item string, request ExtensionPluginRequest) (_r *ExtensionResponse, _err error)
	Shutdown(ctx context.Context) (_err error)
}

type ExtensionClient struct {
	c    thrift.TClient
	meta thrift.ResponseMeta
}

func NewExtensionClientFactory(t thrift.TTransport, f thrift.TProtocolFactory) *ExtensionClient {
	return &ExtensionClient{
		c: thrift.NewTStandardClient(f.GetProtocol(t), f.GetProtocol(t)),
	}
}

func NewExtensionClientProtocol(t thrift.TTransport, iprot thrift.TProtocol, oprot thrift.TProtocol) *ExtensionClient {
	return &ExtensionClient{
		c: thrift.NewTStandardClient(iprot, oprot),
	}
}

func NewExtensionClient(c thrift.TClient) *ExtensionClient {
	return &ExtensionClient{
		c: c,
	}
}

func (p *ExtensionClient) Client_() thrift.TClient {
	return p.c
}

func (p *ExtensionClient) LastResponseMeta_() thrift.ResponseMeta {
	return p.meta
}

func (p *ExtensionClient) SetLastResponseMeta_(meta thrift.ResponseMeta) {
	p.meta = meta
}

func (p *ExtensionClient) Ping(ctx context.Context) (_r *ExtensionStatus, _err error) {
	var _args5 ExtensionPingArgs
	var _result7 ExtensionPingResult
	var _meta6 thrift.ResponseMeta
	_meta6, _err = p.Client_().Call(ctx, "ping", &_args5, &_result7)
	p.SetLastResponseMeta_(_meta6)
	if _err != nil {
		return
	}
	if _ret8 := _result7.GetSuccess(); _ret8 != nil {
		return _ret8, nil
	}
	return nil, thrift.NewTApplicationException(thrift.MISSING_RESULT, "ping failed: unknown result")
}

// Parameters:
//  - Registry
//  - Item
//  - Request
func (p *ExtensionClient) Call(ctx context.Context, registry string, item string, request ExtensionPluginRequest) (_r *ExtensionResponse, _err error) {
	var _args9 ExtensionCallArgs
	_args9.Registry = registry
	_args9.Item = item
	_args9.Request = request
	var _result11 ExtensionCallResult
	var _meta10 thrift.ResponseMeta
	_meta10, _err = p.Client_().Call(ctx, "call", &_args9, &_result11)
	p.SetLastResponseMeta_(_meta10)
	if _err != nil {
		return
	}
	if _ret12 := _result11.GetSuccess(); _ret12 != nil {
		return _ret12, nil
	}
	return nil, thrift.NewTApplicationException(thrift.MISSING_RESULT, "call failed: unknown result")
}

func (p *ExtensionClient) Shutdown(ctx context.Context) (_err error) {
	var _args13 ExtensionShutdownArgs
	var _result15 ExtensionShutdownResult
	var _meta14 thrift.ResponseMeta
	_meta14, _err = p.Client_().Call(ctx, "shutdown", &_args13, &_result15)
	p.SetLastResponseMeta_(_meta14)
	if _err != nil {
		return
	}
	return nil
}

type ExtensionProcessor struct {
	processorMap map[string]thrift.TProcessorFunction
	handler      Extension
}

func (p *ExtensionProcessor) AddToProcessorMap(key string, processor thrift.TProcessorFunction) {
	p.processorMap[key] = processor
}

func (p *ExtensionProcessor) GetProcessorFunction(key string) (processor thrift.TProcessorFunction, ok bool) {
	processor, ok = p.processorMap[key]
	return processor, ok
}

func (p *ExtensionProcessor) ProcessorMap() map[string]thrift.TProcessorFunction {
	return p.processorMap
}

func NewExtensionProcessor(handler Extension) *ExtensionProcessor {

	self16 := &ExtensionProcessor{handler: handler, processorMap: make(map[string]thrift.TProcessorFunction)}
	self16.processorMap["ping"] = &extensionProcessorPing{handler: handler}
	self16.processorMap["call"] = &extensionProcessorCall{handler: handler}
	self16.processorMap["shutdown"] = &extensionProcessorShutdown{handler: handler}
	return self16
}

func (p *ExtensionProcessor) Process(ctx context.Context, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	name, _, seqId, err2 := iprot.ReadMessageBegin(ctx)
	if err2 != nil {
		return false, thrift.WrapTException(err2)
	}
	if processor, ok := p.GetProcessorFunction(name); ok {
		return processor.Process(ctx, seqId, iprot, oprot)
	}
	iprot.Skip(ctx, thrift.STRUCT)
	iprot.ReadMessageEnd(ctx)
	x17 := thrift.NewTApplicationException(thrift.UNKNOWN_METHOD, "Unknown function "+name)
	oprot.WriteMessageBegin(ctx, name, thrift.EXCEPTION, seqId)
	x17.Write(ctx, oprot)
	oprot.WriteMessageEnd(ctx)
	oprot.Flush(ctx)
	return false, x17

}

type extensionProcessorPing struct {
	handler Extension
}

func (p *extensionProcessorPing) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := ExtensionPingArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "ping", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := ExtensionPingResult{}
	var retval *ExtensionStatus
	if retval, err2 = p.handler.Ping(ctx); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing ping: "+err2.Error())
		oprot.WriteMessageBegin(ctx, "ping", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "ping", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type extensionProcessorCall struct {
	handler Extension
}

func (p *extensionProcessorCall) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := ExtensionCallArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "call", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := ExtensionCallResult{}
	var retval *ExtensionResponse
	if retval, err2 = p.handler.Call(ctx, args.Registry, args.Item, args.Request); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing call: "+err2.Error())
		oprot.WriteMessageBegin(ctx, "call", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "call", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type extensionProcessorShutdown struct {
	handler Extension
}

func (p *extensionProcessorShutdown) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := ExtensionShutdownArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "shutdown", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := ExtensionShutdownResult{}
	if err2 = p.handler.Shutdown(ctx); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing shutdown: "+err2.Error())
		oprot.WriteMessageBegin(ctx, "shutdown", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "shutdown", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

// HELPER FUNCTIONS AND STRUCTURES

type ExtensionPingArgs struct {
}

func NewExtensionPingArgs() *ExtensionPingArgs {
	return &ExtensionPingArgs{}
}

func (p *ExtensionPingArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(ctx, fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ExtensionPingArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "ping_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ExtensionPingArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ExtensionPingArgs(%+v)", *p)
}

// Attributes:
//  - Success
type ExtensionPingResult struct {
	Success *ExtensionStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewExtensionPingResult() *ExtensionPingResult {
	return &ExtensionPingResult{}
}

var ExtensionPingResult_Success_DEFAULT *ExtensionStatus

func (p *ExtensionPingResult) GetSuccess() *ExtensionStatus {
	if !p.IsSetSuccess() {
		return ExtensionPingResult_Success_DEFAULT
	}
	return p.Success
}
func (p *ExtensionPingResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *ExtensionPingResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ExtensionPingResult) ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &ExtensionStatus{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *ExtensionPingResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "ping_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ExtensionPingResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *ExtensionPingResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ExtensionPingResult(%+v)", *p)
}

// Attributes:
//  - Registry
//  - Item
//  - Request
type ExtensionCallArgs struct {
	Registry string                 `thrift:"registry,1" db:"registry" json:"registry"`
	Item     string                 `thrift:"item,2" db:"item" json:"item"`
	Request  ExtensionPluginRequest `thrift:"request,3" db:"request" json:"request"`
}

func NewExtensionCallArgs() *ExtensionCallArgs {
	return &ExtensionCallArgs{}
}

func (p *ExtensionCallArgs) GetRegistry() string {
	return p.Registry
}

func (p *ExtensionCallArgs) GetItem() string {
	return p.Item
}

func (p *ExtensionCallArgs) GetRequest() ExtensionPluginRequest {
	return p.Request
}
func (p *ExtensionCallArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 3:
			if fieldTypeId == thrift.MAP {
				if err := p.ReadField3(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ExtensionCallArgs) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.Registry = v
	}
	return nil
}

func (p *ExtensionCallArgs) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 2: ", err)
	} else {
		p.Item = v
	}
	return nil
}

func (p *ExtensionCallArgs) ReadField3(ctx context.Context, iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading map begin: ", err)
	}
	tMap := make(ExtensionPluginRequest, size)
	p.Request = tMap
	for i := 0; i < size; i++ {
		var _key18 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_key18 = v
		}
		var _val19 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_val19 = v
		}
		p.Request[_key18] = _val19
	}
	if err := iprot.ReadMapEnd(ctx); err != nil {
		return thrift.PrependError("error reading map end: ", err)
	}
	return nil
}

func (p *ExtensionCallArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "call_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField3(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ExtensionCallArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "registry", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:registry: ", p), err)
	}
	if err := oprot.WriteString(ctx, string(p.Registry)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.registry (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:registry: ", p), err)
	}
	return err
}

func (p *ExtensionCallArgs) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "item", thrift.STRING, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:item: ", p), err)
	}
	if err := oprot.WriteString(ctx, string(p.Item)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.item (2) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:item: ", p), err)
	}
	return err
}

func (p *ExtensionCallArgs) writeField3(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "request", thrift.MAP, 3); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 3:request: ", p), err)
	}
	if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.STRING, len(p.Request)); err != nil {
		return thrift.PrependError("error writing map begin: ", err)
	}
	for k, v := range p.Request {
		if err := oprot.WriteString(ctx, string(k)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err)
		}
		if err := oprot.WriteString(ctx, string(v)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err)
		}
	}
	if err := oprot.WriteMapEnd(ctx); err != nil {
		return thrift.PrependError("error writing map end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 3:request: ", p), err)
	}
	return err
}

func (p *ExtensionCallArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ExtensionCallArgs(%+v)", *p)
}

// Attributes:
//  - Success
type ExtensionCallResult struct {
	Success *ExtensionResponse `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewExtensionCallResult() *ExtensionCallResult {
	return &ExtensionCallResult{}
}

var ExtensionCallResult_Success_DEFAULT *ExtensionResponse

func (p *ExtensionCallResult) GetSuccess() *ExtensionResponse {
	if !p.IsSetSuccess() {
		return ExtensionCallResult_Success_DEFAULT
	}
	return p.Success
}
func (p *ExtensionCallResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *ExtensionCallResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ExtensionCallResult) ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &ExtensionResponse{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *ExtensionCallResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "call_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ExtensionCallResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *ExtensionCallResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ExtensionCallResult(%+v)", *p)
}

type ExtensionShutdownArgs struct {
}

func NewExtensionShutdownArgs() *ExtensionShutdownArgs {
	return &ExtensionShutdownArgs{}
}

func (p *ExtensionShutdownArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(ctx, fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ExtensionShutdownArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "shutdown_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ExtensionShutdownArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ExtensionShutdownArgs(%+v)", *p)
}

type ExtensionShutdownResult struct {
}

func NewExtensionShutdownResult() *ExtensionShutdownResult {
	return &ExtensionShutdownResult{}
}

func (p *ExtensionShutdownResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(ctx, fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ExtensionShutdownResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "shutdown_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ExtensionShutdownResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ExtensionShutdownResult(%+v)", *p)
}

type ExtensionManager interface {
	Extension

	Extensions(ctx context.Context) (_r InternalExtensionList, _err error)
	Options(ctx context.Context) (_r InternalOptionList, _err error)
	// Parameters:
	//  - Info
	//  - Registry
	RegisterExtension(ctx context.Context, info *InternalExtensionInfo, registry ExtensionRegistry) (_r *ExtensionStatus, _err error)
	// Parameters:
	//  - UUID
	DeregisterExtension(ctx context.Context, uuid ExtensionRouteUUID) (_r *ExtensionStatus, _err error)
	// Parameters:
	//  - Sql
	Query(ctx context.Context, sql string) (_r *ExtensionResponse, _err error)
	// Parameters:
	//  - Sql
	GetQueryColumns(ctx context.Context, sql string) (_r *ExtensionResponse, _err error)
}

type ExtensionManagerClient struct {
	*ExtensionClient
}

func NewExtensionManagerClientFactory(t thrift.TTransport, f thrift.TProtocolFactory) *ExtensionManagerClient {
	return &ExtensionManagerClient{ExtensionClient: NewExtensionClientFactory(t, f)}
}

func NewExtensionManagerClientProtocol(t thrift.TTransport, iprot thrift.TProtocol, oprot thrift.TProtocol) *ExtensionManagerClient {
	return &ExtensionManagerClient{ExtensionClient: NewExtensionClientProtocol(t, iprot, oprot)}
}

func NewExtensionManagerClient(c thrift.TClient) *ExtensionManagerClient {
	return &ExtensionManagerClient{
		ExtensionClient: NewExtensionClient(c),
	}
}

func (p *ExtensionManagerClient) Extensions(ctx context.Context) (_r InternalExtensionList, _err error) {
	var _args28 ExtensionManagerExtensionsArgs
	var _result30 ExtensionManagerExtensionsResult
	var _meta29 thrift.ResponseMeta
	_meta29, _err = p.Client_().Call(ctx, "extensions", &_args28, &_result30)
	p.SetLastResponseMeta_(_meta29)
	if _err != nil {
		return
	}
	return _result30.GetSuccess(), nil
}

func (p *ExtensionManagerClient) Options(ctx context.Context) (_r InternalOptionList, _err error) {
	var _args31 ExtensionManagerOptionsArgs
	var _result33 ExtensionManagerOptionsResult
	var _meta32 thrift.ResponseMeta
	_meta32, _err = p.Client_().Call(ctx, "options", &_args31, &_result33)
	p.SetLastResponseMeta_(_meta32)
	if _err != nil {
		return
	}
	return _result33.GetSuccess(), nil
}

// Parameters:
//  - Info
//  - Registry
func (p *ExtensionManagerClient) RegisterExtension(ctx context.Context, info *InternalExtensionInfo, registry ExtensionRegistry) (_r *ExtensionStatus, _err error) {
	var _args34 ExtensionManagerRegisterExtensionArgs
	_args34.Info = info
	_args34.Registry = registry
	var _result36 ExtensionManagerRegisterExtensionResult
	var _meta35 thrift.ResponseMeta
	_meta35, _err = p.Client_().Call(ctx, "registerExtension", &_args34, &_result36)
	p.SetLastResponseMeta_(_meta35)
	if _err != nil {
		return
	}
	if _ret37 := _result36.GetSuccess(); _ret37 != nil {
		return _ret37, nil
	}
	return nil, thrift.NewTApplicationException(thrift.MISSING_RESULT, "registerExtension failed: unknown result")
}

// Parameters:
//  - UUID
func (p *ExtensionManagerClient) DeregisterExtension(ctx context.Context, uuid ExtensionRouteUUID) (_r *ExtensionStatus, _err error) {
	var _args38 ExtensionManagerDeregisterExtensionArgs
	_args38.UUID = uuid
	var _result40 ExtensionManagerDeregisterExtensionResult
	var _meta39 thrift.ResponseMeta
	_meta39, _err = p.Client_().Call(ctx, "deregisterExtension", &_args38, &_result40)
	p.SetLastResponseMeta_(_meta39)
	if _err != nil {
		return
	}
	if _ret41 := _result40.GetSuccess(); _ret41 != nil {
		return _ret41, nil
	}
	return nil, thrift.NewTApplicationException(thrift.MISSING_RESULT, "deregisterExtension failed: unknown result")
}

// Parameters:
//  - Sql
func (p *ExtensionManagerClient) Query(ctx context.Context, sql string) (_r *ExtensionResponse, _err error) {
	var _args42 ExtensionManagerQueryArgs
	_args42.Sql = sql
	var _result44 ExtensionManagerQueryResult
	var _meta43 thrift.ResponseMeta
	_meta43, _err = p.Client_().Call(ctx, "query", &_args42, &_result44)
	p.SetLastResponseMeta_(_meta43)
	if _err != nil {
		return
	}
	if _ret45 := _result44.GetSuccess(); _ret45 != nil {
		return _ret45, nil
	}
	return nil, thrift.NewTApplicationException(thrift.MISSING_RESULT, "query failed: unknown result")
}

// Parameters:
//  - Sql
func (p *ExtensionManagerClient) GetQueryColumns(ctx context.Context, sql string) (_r *ExtensionResponse, _err error) {
	var _args46 ExtensionManagerGetQueryColumnsArgs
	_args46.Sql = sql
	var _result48 ExtensionManagerGetQueryColumnsResult
	var _meta47 thrift.ResponseMeta
	_meta47, _err = p.Client_().Call(ctx, "getQueryColumns", &_args46, &_result48)
	p.SetLastResponseMeta_(_meta47)
	if _err != nil {
		return
	}
	if _ret49 := _result48.GetSuccess(); _ret49 != nil {
		return _ret49, nil
	}
	return nil, thrift.NewTApplicationException(thrift.MISSING_RESULT, "getQueryColumns failed: unknown result")
}

type ExtensionManagerProcessor struct {
	*ExtensionProcessor
}

func NewExtensionManagerProcessor(handler ExtensionManager) *ExtensionManagerProcessor {
	self50 := &ExtensionManagerProcessor{NewExtensionProcessor(handler)}
	self50.AddToProcessorMap("extensions", &extensionManagerProcessorExtensions{handler: handler})
	self50.AddToProcessorMap("options", &extensionManagerProcessorOptions{handler: handler})
	self50.AddToProcessorMap("registerExtension", &extensionManagerProcessorRegisterExtension{handler: handler})
	self50.AddToProcessorMap("deregisterExtension", &extensionManagerProcessorDeregisterExtension{handler: handler})
	self50.AddToProcessorMap("query", &extensionManagerProcessorQuery{handler: handler})
	self50.AddToProcessorMap("getQueryColumns", &extensionManagerProcessorGetQueryColumns{handler: handler})
	return self50
}

type extensionManagerProcessorExtensions struct {
	handler ExtensionManager
}

func (p *extensionManagerProcessorExtensions) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := ExtensionManagerExtensionsArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "extensions", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := ExtensionManagerExtensionsResult{}
	var retval InternalExtensionList
	if retval, err2 = p.handler.Extensions(ctx); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing extensions: "+err2.Error())
		oprot.WriteMessageBegin(ctx, "extensions", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "extensions", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type extensionManagerProcessorOptions struct {
	handler ExtensionManager
}

func (p *extensionManagerProcessorOptions) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := ExtensionManagerOptionsArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "options", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := ExtensionManagerOptionsResult{}
	var retval InternalOptionList
	if retval, err2 = p.handler.Options(ctx); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing options: "+err2.Error())
		oprot.WriteMessageBegin(ctx, "options", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "options", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type extensionManagerProcessorRegisterExtension struct {
	handler ExtensionManager
}

func (p *extensionManagerProcessorRegisterExtension) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := ExtensionManagerRegisterExtensionArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "registerExtension", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := ExtensionManagerRegisterExtensionResult{}
	var retval *ExtensionStatus
	if retval, err2 = p.handler.RegisterExtension(ctx, args.Info, args.Registry); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing registerExtension: "+err2.Error())
		oprot.WriteMessageBegin(ctx, "registerExtension", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "registerExtension", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type extensionManagerProcessorDeregisterExtension struct {
	handler ExtensionManager
}

func (p *extensionManagerProcessorDeregisterExtension) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := ExtensionManagerDeregisterExtensionArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "deregisterExtension", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := ExtensionManagerDeregisterExtensionResult{}
	var retval *ExtensionStatus
	if retval, err2 = p.handler.DeregisterExtension(ctx, args.UUID); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing deregisterExtension: "+err2.Error())
		oprot.WriteMessageBegin(ctx, "deregisterExtension", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "deregisterExtension", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type extensionManagerProcessorQuery struct {
	handler ExtensionManager
}

func (p *extensionManagerProcessorQuery) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := ExtensionManagerQueryArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "query", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := ExtensionManagerQueryResult{}
	var retval *ExtensionResponse
	if retval, err2 = p.handler.Query(ctx, args.Sql); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing query: "+err2.Error())
		oprot.WriteMessageBegin(ctx, "query", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "query", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

type extensionManagerProcessorGetQueryColumns struct {
	handler ExtensionManager
}

func (p *extensionManagerProcessorGetQueryColumns) Process(ctx context.Context, seqId int32, iprot, oprot thrift.TProtocol) (success bool, err thrift.TException) {
	args := ExtensionManagerGetQueryColumnsArgs{}
	var err2 error
	if err2 = args.Read(ctx, iprot); err2 != nil {
		iprot.ReadMessageEnd(ctx)
		x := thrift.NewTApplicationException(thrift.PROTOCOL_ERROR, err2.Error())
		oprot.WriteMessageBegin(ctx, "getQueryColumns", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return false, thrift.WrapTException(err2)
	}
	iprot.ReadMessageEnd(ctx)

	tickerCancel := func() {}
	// Start a goroutine to do server side connectivity check.
	if thrift.ServerConnectivityCheckInterval > 0 {
		var cancel context.CancelFunc
		ctx, cancel = context.WithCancel(ctx)
		defer cancel()
		var tickerCtx context.Context
		tickerCtx, tickerCancel = context.WithCancel(context.Background())
		defer tickerCancel()
		go func(ctx context.Context, cancel context.CancelFunc) {
			ticker := time.NewTicker(thrift.ServerConnectivityCheckInterval)
			defer ticker.Stop()
			for {
				select {
				case <-ctx.Done():
					return
				case <-ticker.C:
					if !iprot.Transport().IsOpen() {
						cancel()
						return
					}
				}
			}
		}(tickerCtx, cancel)
	}

	result := ExtensionManagerGetQueryColumnsResult{}
	var retval *ExtensionResponse
	if retval, err2 = p.handler.GetQueryColumns(ctx, args.Sql); err2 != nil {
		tickerCancel()
		if err2 == thrift.ErrAbandonRequest {
			return false, thrift.WrapTException(err2)
		}
		x := thrift.NewTApplicationException(thrift.INTERNAL_ERROR, "Internal error processing getQueryColumns: "+err2.Error())
		oprot.WriteMessageBegin(ctx, "getQueryColumns", thrift.EXCEPTION, seqId)
		x.Write(ctx, oprot)
		oprot.WriteMessageEnd(ctx)
		oprot.Flush(ctx)
		return true, thrift.WrapTException(err2)
	} else {
		result.Success = retval
	}
	tickerCancel()
	if err2 = oprot.WriteMessageBegin(ctx, "getQueryColumns", thrift.REPLY, seqId); err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = result.Write(ctx, oprot); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.WriteMessageEnd(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err2 = oprot.Flush(ctx); err == nil && err2 != nil {
		err = thrift.WrapTException(err2)
	}
	if err != nil {
		return
	}
	return true, err
}

// HELPER FUNCTIONS AND STRUCTURES

type ExtensionManagerExtensionsArgs struct {
}

func NewExtensionManagerExtensionsArgs() *ExtensionManagerExtensionsArgs {
	return &ExtensionManagerExtensionsArgs{}
}

func (p *ExtensionManagerExtensionsArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(ctx, fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ExtensionManagerExtensionsArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "extensions_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ExtensionManagerExtensionsArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ExtensionManagerExtensionsArgs(%+v)", *p)
}

// Attributes:
//  - Success
type ExtensionManagerExtensionsResult struct {
	Success InternalExtensionList `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewExtensionManagerExtensionsResult() *ExtensionManagerExtensionsResult {
	return &ExtensionManagerExtensionsResult{}
}

var ExtensionManagerExtensionsResult_Success_DEFAULT InternalExtensionList

func (p *ExtensionManagerExtensionsResult) GetSuccess() InternalExtensionList {
	return p.Success
}
func (p *ExtensionManagerExtensionsResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *ExtensionManagerExtensionsResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.MAP {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ExtensionManagerExtensionsResult) ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading map begin: ", err)
	}
	tMap := make(InternalExtensionList, size)
	p.Success = tMap
	for i := 0; i < size; i++ {
		var _key51 ExtensionRouteUUID
		if v, err := iprot.ReadI64(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			temp := ExtensionRouteUUID(v)
			_key51 = temp
		}
		_val52 := &InternalExtensionInfo{}
		if err := _val52.Read(ctx, iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _val52), err)
		}
		p.Success[_key51] = _val52
	}
	if err := iprot.ReadMapEnd(ctx); err != nil {
		return thrift.PrependError("error reading map end: ", err)
	}
	return nil
}

func (p *ExtensionManagerExtensionsResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "extensions_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ExtensionManagerExtensionsResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.MAP, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := oprot.WriteMapBegin(ctx, thrift.I64, thrift.STRUCT, len(p.Success)); err != nil {
			return thrift.PrependError("error writing map begin: ", err)
		}
		for k, v := range p.Success {
			if err := oprot.WriteI64(ctx, int64(k)); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err)
			}
			if err := v.Write(ctx, oprot); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
			}
		}
		if err := oprot.WriteMapEnd(ctx); err != nil {
			return thrift.PrependError("error writing map end: ", err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *ExtensionManagerExtensionsResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ExtensionManagerExtensionsResult(%+v)", *p)
}

type ExtensionManagerOptionsArgs struct {
}

func NewExtensionManagerOptionsArgs() *ExtensionManagerOptionsArgs {
	return &ExtensionManagerOptionsArgs{}
}

func (p *ExtensionManagerOptionsArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		if err := iprot.Skip(ctx, fieldTypeId); err != nil {
			return err
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ExtensionManagerOptionsArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "options_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ExtensionManagerOptionsArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ExtensionManagerOptionsArgs(%+v)", *p)
}

// Attributes:
//  - Success
type ExtensionManagerOptionsResult struct {
	Success InternalOptionList `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewExtensionManagerOptionsResult() *ExtensionManagerOptionsResult {
	return &ExtensionManagerOptionsResult{}
}

var ExtensionManagerOptionsResult_Success_DEFAULT InternalOptionList

func (p *ExtensionManagerOptionsResult) GetSuccess() InternalOptionList {
	return p.Success
}
func (p *ExtensionManagerOptionsResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *ExtensionManagerOptionsResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.MAP {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ExtensionManagerOptionsResult) ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading map begin: ", err)
	}
	tMap := make(InternalOptionList, size)
	p.Success = tMap
	for i := 0; i < size; i++ {
		var _key53 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_key53 = v
		}
		_val54 := &InternalOptionInfo{}
		if err := _val54.Read(ctx, iprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", _val54), err)
		}
		p.Success[_key53] = _val54
	}
	if err := iprot.ReadMapEnd(ctx); err != nil {
		return thrift.PrependError("error reading map end: ", err)
	}
	return nil
}

func (p *ExtensionManagerOptionsResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "options_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ExtensionManagerOptionsResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.MAP, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.STRUCT, len(p.Success)); err != nil {
			return thrift.PrependError("error writing map begin: ", err)
		}
		for k, v := range p.Success {
			if err := oprot.WriteString(ctx, string(k)); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err)
			}
			if err := v.Write(ctx, oprot); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", v), err)
			}
		}
		if err := oprot.WriteMapEnd(ctx); err != nil {
			return thrift.PrependError("error writing map end: ", err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *ExtensionManagerOptionsResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ExtensionManagerOptionsResult(%+v)", *p)
}

// Attributes:
//  - Info
//  - Registry
type ExtensionManagerRegisterExtensionArgs struct {
	Info     *InternalExtensionInfo `thrift:"info,1" db:"info" json:"info"`
	Registry ExtensionRegistry      `thrift:"registry,2" db:"registry" json:"registry"`
}

func NewExtensionManagerRegisterExtensionArgs() *ExtensionManagerRegisterExtensionArgs {
	return &ExtensionManagerRegisterExtensionArgs{}
}

var ExtensionManagerRegisterExtensionArgs_Info_DEFAULT *InternalExtensionInfo

func (p *ExtensionManagerRegisterExtensionArgs) GetInfo() *InternalExtensionInfo {
	if !p.IsSetInfo() {
		return ExtensionManagerRegisterExtensionArgs_Info_DEFAULT
	}
	return p.Info
}

func (p *ExtensionManagerRegisterExtensionArgs) GetRegistry() ExtensionRegistry {
	return p.Registry
}
func (p *ExtensionManagerRegisterExtensionArgs) IsSetInfo() bool {
	return p.Info != nil
}

func (p *ExtensionManagerRegisterExtensionArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		case 2:
			if fieldTypeId == thrift.MAP {
				if err := p.ReadField2(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ExtensionManagerRegisterExtensionArgs) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	p.Info = &InternalExtensionInfo{}
	if err := p.Info.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Info), err)
	}
	return nil
}

func (p *ExtensionManagerRegisterExtensionArgs) ReadField2(ctx context.Context, iprot thrift.TProtocol) error {
	_, _, size, err := iprot.ReadMapBegin(ctx)
	if err != nil {
		return thrift.PrependError("error reading map begin: ", err)
	}
	tMap := make(ExtensionRegistry, size)
	p.Registry = tMap
	for i := 0; i < size; i++ {
		var _key55 string
		if v, err := iprot.ReadString(ctx); err != nil {
			return thrift.PrependError("error reading field 0: ", err)
		} else {
			_key55 = v
		}
		_, _, size, err := iprot.ReadMapBegin(ctx)
		if err != nil {
			return thrift.PrependError("error reading map begin: ", err)
		}
		tMap := make(ExtensionRouteTable, size)
		_val56 := tMap
		for i := 0; i < size; i++ {
			var _key57 string
			if v, err := iprot.ReadString(ctx); err != nil {
				return thrift.PrependError("error reading field 0: ", err)
			} else {
				_key57 = v
			}
			_, size, err := iprot.ReadListBegin(ctx)
			if err != nil {
				return thrift.PrependError("error reading list begin: ", err)
			}
			tSlice := make(ExtensionPluginResponse, 0, size)
			_val58 := tSlice
			for i := 0; i < size; i++ {
				_, _, size, err := iprot.ReadMapBegin(ctx)
				if err != nil {
					return thrift.PrependError("error reading map begin: ", err)
				}
				tMap := make(map[string]string, size)
				_elem59 := tMap
				for i := 0; i < size; i++ {
					var _key60 string
					if v, err := iprot.ReadString(ctx); err != nil {
						return thrift.PrependError("error reading field 0: ", err)
					} else {
						_key60 = v
					}
					var _val61 string
					if v, err := iprot.ReadString(ctx); err != nil {
						return thrift.PrependError("error reading field 0: ", err)
					} else {
						_val61 = v
					}
					_elem59[_key60] = _val61
				}
				if err := iprot.ReadMapEnd(ctx); err != nil {
					return thrift.PrependError("error reading map end: ", err)
				}
				_val58 = append(_val58, _elem59)
			}
			if err := iprot.ReadListEnd(ctx); err != nil {
				return thrift.PrependError("error reading list end: ", err)
			}
			_val56[_key57] = _val58
		}
		if err := iprot.ReadMapEnd(ctx); err != nil {
			return thrift.PrependError("error reading map end: ", err)
		}
		p.Registry[_key55] = _val56
	}
	if err := iprot.ReadMapEnd(ctx); err != nil {
		return thrift.PrependError("error reading map end: ", err)
	}
	return nil
}

func (p *ExtensionManagerRegisterExtensionArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "registerExtension_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
		if err := p.writeField2(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ExtensionManagerRegisterExtensionArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "info", thrift.STRUCT, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:info: ", p), err)
	}
	if err := p.Info.Write(ctx, oprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Info), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:info: ", p), err)
	}
	return err
}

func (p *ExtensionManagerRegisterExtensionArgs) writeField2(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "registry", thrift.MAP, 2); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 2:registry: ", p), err)
	}
	if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.MAP, len(p.Registry)); err != nil {
		return thrift.PrependError("error writing map begin: ", err)
	}
	for k, v := range p.Registry {
		if err := oprot.WriteString(ctx, string(k)); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err)
		}
		if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.LIST, len(v)); err != nil {
			return thrift.PrependError("error writing map begin: ", err)
		}
		for k, v := range v {
			if err := oprot.WriteString(ctx, string(k)); err != nil {
				return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err)
			}
			if err := oprot.WriteListBegin(ctx, thrift.MAP, len(v)); err != nil {
				return thrift.PrependError("error writing list begin: ", err)
			}
			for _, v := range v {
				if err := oprot.WriteMapBegin(ctx, thrift.STRING, thrift.STRING, len(v)); err != nil {
					return thrift.PrependError("error writing map begin: ", err)
				}
				for k, v := range v {
					if err := oprot.WriteString(ctx, string(k)); err != nil {
						return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err)
					}
					if err := oprot.WriteString(ctx, string(v)); err != nil {
						return thrift.PrependError(fmt.Sprintf("%T. (0) field write error: ", p), err)
					}
				}
				if err := oprot.WriteMapEnd(ctx); err != nil {
					return thrift.PrependError("error writing map end: ", err)
				}
			}
			if err := oprot.WriteListEnd(ctx); err != nil {
				return thrift.PrependError("error writing list end: ", err)
			}
		}
		if err := oprot.WriteMapEnd(ctx); err != nil {
			return thrift.PrependError("error writing map end: ", err)
		}
	}
	if err := oprot.WriteMapEnd(ctx); err != nil {
		return thrift.PrependError("error writing map end: ", err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 2:registry: ", p), err)
	}
	return err
}

func (p *ExtensionManagerRegisterExtensionArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ExtensionManagerRegisterExtensionArgs(%+v)", *p)
}

// Attributes:
//  - Success
type ExtensionManagerRegisterExtensionResult struct {
	Success *ExtensionStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewExtensionManagerRegisterExtensionResult() *ExtensionManagerRegisterExtensionResult {
	return &ExtensionManagerRegisterExtensionResult{}
}

var ExtensionManagerRegisterExtensionResult_Success_DEFAULT *ExtensionStatus

func (p *ExtensionManagerRegisterExtensionResult) GetSuccess() *ExtensionStatus {
	if !p.IsSetSuccess() {
		return ExtensionManagerRegisterExtensionResult_Success_DEFAULT
	}
	return p.Success
}
func (p *ExtensionManagerRegisterExtensionResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *ExtensionManagerRegisterExtensionResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ExtensionManagerRegisterExtensionResult) ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &ExtensionStatus{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *ExtensionManagerRegisterExtensionResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "registerExtension_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ExtensionManagerRegisterExtensionResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *ExtensionManagerRegisterExtensionResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ExtensionManagerRegisterExtensionResult(%+v)", *p)
}

// Attributes:
//  - UUID
type ExtensionManagerDeregisterExtensionArgs struct {
	UUID ExtensionRouteUUID `thrift:"uuid,1" db:"uuid" json:"uuid"`
}

func NewExtensionManagerDeregisterExtensionArgs() *ExtensionManagerDeregisterExtensionArgs {
	return &ExtensionManagerDeregisterExtensionArgs{}
}

func (p *ExtensionManagerDeregisterExtensionArgs) GetUUID() ExtensionRouteUUID {
	return p.UUID
}
func (p *ExtensionManagerDeregisterExtensionArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.I64 {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ExtensionManagerDeregisterExtensionArgs) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadI64(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		temp := ExtensionRouteUUID(v)
		p.UUID = temp
	}
	return nil
}

func (p *ExtensionManagerDeregisterExtensionArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "deregisterExtension_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ExtensionManagerDeregisterExtensionArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "uuid", thrift.I64, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:uuid: ", p), err)
	}
	if err := oprot.WriteI64(ctx, int64(p.UUID)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.uuid (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:uuid: ", p), err)
	}
	return err
}

func (p *ExtensionManagerDeregisterExtensionArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ExtensionManagerDeregisterExtensionArgs(%+v)", *p)
}

// Attributes:
//  - Success
type ExtensionManagerDeregisterExtensionResult struct {
	Success *ExtensionStatus `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewExtensionManagerDeregisterExtensionResult() *ExtensionManagerDeregisterExtensionResult {
	return &ExtensionManagerDeregisterExtensionResult{}
}

var ExtensionManagerDeregisterExtensionResult_Success_DEFAULT *ExtensionStatus

func (p *ExtensionManagerDeregisterExtensionResult) GetSuccess() *ExtensionStatus {
	if !p.IsSetSuccess() {
		return ExtensionManagerDeregisterExtensionResult_Success_DEFAULT
	}
	return p.Success
}
func (p *ExtensionManagerDeregisterExtensionResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *ExtensionManagerDeregisterExtensionResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ExtensionManagerDeregisterExtensionResult) ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &ExtensionStatus{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *ExtensionManagerDeregisterExtensionResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "deregisterExtension_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ExtensionManagerDeregisterExtensionResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *ExtensionManagerDeregisterExtensionResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ExtensionManagerDeregisterExtensionResult(%+v)", *p)
}

// Attributes:
//  - Sql
type ExtensionManagerQueryArgs struct {
	Sql string `thrift:"sql,1" db:"sql" json:"sql"`
}

func NewExtensionManagerQueryArgs() *ExtensionManagerQueryArgs {
	return &ExtensionManagerQueryArgs{}
}

func (p *ExtensionManagerQueryArgs) GetSql() string {
	return p.Sql
}
func (p *ExtensionManagerQueryArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ExtensionManagerQueryArgs) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.Sql = v
	}
	return nil
}

func (p *ExtensionManagerQueryArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "query_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ExtensionManagerQueryArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "sql", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sql: ", p), err)
	}
	if err := oprot.WriteString(ctx, string(p.Sql)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.sql (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sql: ", p), err)
	}
	return err
}

func (p *ExtensionManagerQueryArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ExtensionManagerQueryArgs(%+v)", *p)
}

// Attributes:
//  - Success
type ExtensionManagerQueryResult struct {
	Success *ExtensionResponse `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewExtensionManagerQueryResult() *ExtensionManagerQueryResult {
	return &ExtensionManagerQueryResult{}
}

var ExtensionManagerQueryResult_Success_DEFAULT *ExtensionResponse

func (p *ExtensionManagerQueryResult) GetSuccess() *ExtensionResponse {
	if !p.IsSetSuccess() {
		return ExtensionManagerQueryResult_Success_DEFAULT
	}
	return p.Success
}
func (p *ExtensionManagerQueryResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *ExtensionManagerQueryResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ExtensionManagerQueryResult) ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &ExtensionResponse{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *ExtensionManagerQueryResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "query_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ExtensionManagerQueryResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *ExtensionManagerQueryResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ExtensionManagerQueryResult(%+v)", *p)
}

// Attributes:
//  - Sql
type ExtensionManagerGetQueryColumnsArgs struct {
	Sql string `thrift:"sql,1" db:"sql" json:"sql"`
}

func NewExtensionManagerGetQueryColumnsArgs() *ExtensionManagerGetQueryColumnsArgs {
	return &ExtensionManagerGetQueryColumnsArgs{}
}

func (p *ExtensionManagerGetQueryColumnsArgs) GetSql() string {
	return p.Sql
}
func (p *ExtensionManagerGetQueryColumnsArgs) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 1:
			if fieldTypeId == thrift.STRING {
				if err := p.ReadField1(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ExtensionManagerGetQueryColumnsArgs) ReadField1(ctx context.Context, iprot thrift.TProtocol) error {
	if v, err := iprot.ReadString(ctx); err != nil {
		return thrift.PrependError("error reading field 1: ", err)
	} else {
		p.Sql = v
	}
	return nil
}

func (p *ExtensionManagerGetQueryColumnsArgs) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "getQueryColumns_args"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField1(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ExtensionManagerGetQueryColumnsArgs) writeField1(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if err := oprot.WriteFieldBegin(ctx, "sql", thrift.STRING, 1); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field begin error 1:sql: ", p), err)
	}
	if err := oprot.WriteString(ctx, string(p.Sql)); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T.sql (1) field write error: ", p), err)
	}
	if err := oprot.WriteFieldEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write field end error 1:sql: ", p), err)
	}
	return err
}

func (p *ExtensionManagerGetQueryColumnsArgs) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ExtensionManagerGetQueryColumnsArgs(%+v)", *p)
}

// Attributes:
//  - Success
type ExtensionManagerGetQueryColumnsResult struct {
	Success *ExtensionResponse `thrift:"success,0" db:"success" json:"success,omitempty"`
}

func NewExtensionManagerGetQueryColumnsResult() *ExtensionManagerGetQueryColumnsResult {
	return &ExtensionManagerGetQueryColumnsResult{}
}

var ExtensionManagerGetQueryColumnsResult_Success_DEFAULT *ExtensionResponse

func (p *ExtensionManagerGetQueryColumnsResult) GetSuccess() *ExtensionResponse {
	if !p.IsSetSuccess() {
		return ExtensionManagerGetQueryColumnsResult_Success_DEFAULT
	}
	return p.Success
}
func (p *ExtensionManagerGetQueryColumnsResult) IsSetSuccess() bool {
	return p.Success != nil
}

func (p *ExtensionManagerGetQueryColumnsResult) Read(ctx context.Context, iprot thrift.TProtocol) error {
	if _, err := iprot.ReadStructBegin(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read error: ", p), err)
	}

	for {
		_, fieldTypeId, fieldId, err := iprot.ReadFieldBegin(ctx)
		if err != nil {
			return thrift.PrependError(fmt.Sprintf("%T field %d read error: ", p, fieldId), err)
		}
		if fieldTypeId == thrift.STOP {
			break
		}
		switch fieldId {
		case 0:
			if fieldTypeId == thrift.STRUCT {
				if err := p.ReadField0(ctx, iprot); err != nil {
					return err
				}
			} else {
				if err := iprot.Skip(ctx, fieldTypeId); err != nil {
					return err
				}
			}
		default:
			if err := iprot.Skip(ctx, fieldTypeId); err != nil {
				return err
			}
		}
		if err := iprot.ReadFieldEnd(ctx); err != nil {
			return err
		}
	}
	if err := iprot.ReadStructEnd(ctx); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T read struct end error: ", p), err)
	}
	return nil
}

func (p *ExtensionManagerGetQueryColumnsResult) ReadField0(ctx context.Context, iprot thrift.TProtocol) error {
	p.Success = &ExtensionResponse{}
	if err := p.Success.Read(ctx, iprot); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T error reading struct: ", p.Success), err)
	}
	return nil
}

func (p *ExtensionManagerGetQueryColumnsResult) Write(ctx context.Context, oprot thrift.TProtocol) error {
	if err := oprot.WriteStructBegin(ctx, "getQueryColumns_result"); err != nil {
		return thrift.PrependError(fmt.Sprintf("%T write struct begin error: ", p), err)
	}
	if p != nil {
		if err := p.writeField0(ctx, oprot); err != nil {
			return err
		}
	}
	if err := oprot.WriteFieldStop(ctx); err != nil {
		return thrift.PrependError("write field stop error: ", err)
	}
	if err := oprot.WriteStructEnd(ctx); err != nil {
		return thrift.PrependError("write struct stop error: ", err)
	}
	return nil
}

func (p *ExtensionManagerGetQueryColumnsResult) writeField0(ctx context.Context, oprot thrift.TProtocol) (err error) {
	if p.IsSetSuccess() {
		if err := oprot.WriteFieldBegin(ctx, "success", thrift.STRUCT, 0); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field begin error 0:success: ", p), err)
		}
		if err := p.Success.Write(ctx, oprot); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T error writing struct: ", p.Success), err)
		}
		if err := oprot.WriteFieldEnd(ctx); err != nil {
			return thrift.PrependError(fmt.Sprintf("%T write field end error 0:success: ", p), err)
		}
	}
	return err
}

func (p *ExtensionManagerGetQueryColumnsResult) String() string {
	if p == nil {
		return "<nil>"
	}
	return fmt.Sprintf("ExtensionManagerGetQueryColumnsResult(%+v)", *p)
}
