// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package awsendpointdiscoverytest

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type TestDiscoveryRequiredInput struct {
	_ struct{} `type:"structure"`

	Sdk *string `type:"string"`
}

// String returns the string representation
func (s TestDiscoveryRequiredInput) String() string {
	return awsutil.Prettify(s)
}

type TestDiscoveryRequiredOutput struct {
	_ struct{} `type:"structure"`

	RequestSuccessful *bool `type:"boolean"`
}

// String returns the string representation
func (s TestDiscoveryRequiredOutput) String() string {
	return awsutil.Prettify(s)
}

const opTestDiscoveryRequired = "TestDiscoveryRequired"

// TestDiscoveryRequiredRequest returns a request value for making API operation for
// AwsEndpointDiscoveryTest.
//
//    // Example sending a request using TestDiscoveryRequiredRequest.
//    req := client.TestDiscoveryRequiredRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) TestDiscoveryRequiredRequest(input *TestDiscoveryRequiredInput) TestDiscoveryRequiredRequest {
	op := &aws.Operation{
		Name:       opTestDiscoveryRequired,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TestDiscoveryRequiredInput{}
	}

	req := c.newRequest(op, input, &TestDiscoveryRequiredOutput{})

	if req.Config.EnableEndpointDiscovery {
		de := discovererDescribeEndpoints{
			Client:        c,
			Required:      false,
			EndpointCache: c.endpointCache,
			Params: map[string]*string{
				"op": &req.Operation.Name,
			},
		}

		for k, v := range de.Params {
			if v == nil {
				delete(de.Params, k)
			}
		}

		req.Handlers.Build.PushFrontNamed(aws.NamedHandler{
			Name: "crr.endpointdiscovery",
			Fn:   de.Handler,
		})
	}

	return TestDiscoveryRequiredRequest{Request: req, Input: input, Copy: c.TestDiscoveryRequiredRequest}
}

// TestDiscoveryRequiredRequest is the request type for the
// TestDiscoveryRequired API operation.
type TestDiscoveryRequiredRequest struct {
	*aws.Request
	Input *TestDiscoveryRequiredInput
	Copy  func(*TestDiscoveryRequiredInput) TestDiscoveryRequiredRequest
}

// Send marshals and sends the TestDiscoveryRequired API request.
func (r TestDiscoveryRequiredRequest) Send(ctx context.Context) (*TestDiscoveryRequiredResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &TestDiscoveryRequiredResponse{
		TestDiscoveryRequiredOutput: r.Request.Data.(*TestDiscoveryRequiredOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// TestDiscoveryRequiredResponse is the response type for the
// TestDiscoveryRequired API operation.
type TestDiscoveryRequiredResponse struct {
	*TestDiscoveryRequiredOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// TestDiscoveryRequired request.
func (r *TestDiscoveryRequiredResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
