// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package restjsonservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type OtherOperationInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s OtherOperationInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OtherOperationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	return nil
}

type OtherOperationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s OtherOperationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OtherOperationOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opOtherOperation = "OtherOperation"

// OtherOperationRequest returns a request value for making API operation for
// REST JSON Service.
//
//    // Example sending a request using OtherOperationRequest.
//    req := client.OtherOperationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/RESTJSONService-0000-00-00/OtherOperation
func (c *Client) OtherOperationRequest(input *OtherOperationInput) OtherOperationRequest {
	op := &aws.Operation{
		Name:       opOtherOperation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &OtherOperationInput{}
	}

	req := c.newRequest(op, input, &OtherOperationOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return OtherOperationRequest{Request: req, Input: input, Copy: c.OtherOperationRequest}
}

// OtherOperationRequest is the request type for the
// OtherOperation API operation.
type OtherOperationRequest struct {
	*aws.Request
	Input *OtherOperationInput
	Copy  func(*OtherOperationInput) OtherOperationRequest
}

// Send marshals and sends the OtherOperation API request.
func (r OtherOperationRequest) Send(ctx context.Context) (*OtherOperationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &OtherOperationResponse{
		OtherOperationOutput: r.Request.Data.(*OtherOperationOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// OtherOperationResponse is the response type for the
// OtherOperation API operation.
type OtherOperationResponse struct {
	*OtherOperationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// OtherOperation request.
func (r *OtherOperationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
