// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package accessanalyzer

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Retrieves an analyzed resource.
type GetAnalyzedResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the analyzer to retrieve information from.
	//
	// AnalyzerArn is a required field
	AnalyzerArn *string `location:"querystring" locationName:"analyzerArn" type:"string" required:"true"`

	// The ARN of the resource to retrieve information about.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"querystring" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAnalyzedResourceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAnalyzedResourceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetAnalyzedResourceInput"}

	if s.AnalyzerArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("AnalyzerArn"))
	}

	if s.ResourceArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetAnalyzedResourceInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AnalyzerArn != nil {
		v := *s.AnalyzerArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "analyzerArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceArn != nil {
		v := *s.ResourceArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "resourceArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The response to the request.
type GetAnalyzedResourceOutput struct {
	_ struct{} `type:"structure"`

	// An AnalyedResource object that contains information that Access Analyzer
	// found when it analyzed the resource.
	Resource *AnalyzedResource `locationName:"resource" type:"structure"`
}

// String returns the string representation
func (s GetAnalyzedResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetAnalyzedResourceOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Resource != nil {
		v := s.Resource

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "resource", v, metadata)
	}
	return nil
}

const opGetAnalyzedResource = "GetAnalyzedResource"

// GetAnalyzedResourceRequest returns a request value for making API operation for
// Access Analyzer.
//
// Retrieves information about a resource that was analyzed.
//
//    // Example sending a request using GetAnalyzedResourceRequest.
//    req := client.GetAnalyzedResourceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetAnalyzedResource
func (c *Client) GetAnalyzedResourceRequest(input *GetAnalyzedResourceInput) GetAnalyzedResourceRequest {
	op := &aws.Operation{
		Name:       opGetAnalyzedResource,
		HTTPMethod: "GET",
		HTTPPath:   "/analyzed-resource",
	}

	if input == nil {
		input = &GetAnalyzedResourceInput{}
	}

	req := c.newRequest(op, input, &GetAnalyzedResourceOutput{})

	return GetAnalyzedResourceRequest{Request: req, Input: input, Copy: c.GetAnalyzedResourceRequest}
}

// GetAnalyzedResourceRequest is the request type for the
// GetAnalyzedResource API operation.
type GetAnalyzedResourceRequest struct {
	*aws.Request
	Input *GetAnalyzedResourceInput
	Copy  func(*GetAnalyzedResourceInput) GetAnalyzedResourceRequest
}

// Send marshals and sends the GetAnalyzedResource API request.
func (r GetAnalyzedResourceRequest) Send(ctx context.Context) (*GetAnalyzedResourceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetAnalyzedResourceResponse{
		GetAnalyzedResourceOutput: r.Request.Data.(*GetAnalyzedResourceOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetAnalyzedResourceResponse is the response type for the
// GetAnalyzedResource API operation.
type GetAnalyzedResourceResponse struct {
	*GetAnalyzedResourceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetAnalyzedResource request.
func (r *GetAnalyzedResourceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
