// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package accessanalyzer

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Retrieves an archive rule.
type GetArchiveRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the analyzer to retrieve rules from.
	//
	// AnalyzerName is a required field
	AnalyzerName *string `location:"uri" locationName:"analyzerName" min:"1" type:"string" required:"true"`

	// The name of the rule to retrieve.
	//
	// RuleName is a required field
	RuleName *string `location:"uri" locationName:"ruleName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetArchiveRuleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetArchiveRuleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetArchiveRuleInput"}

	if s.AnalyzerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AnalyzerName"))
	}
	if s.AnalyzerName != nil && len(*s.AnalyzerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AnalyzerName", 1))
	}

	if s.RuleName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RuleName"))
	}
	if s.RuleName != nil && len(*s.RuleName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetArchiveRuleInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AnalyzerName != nil {
		v := *s.AnalyzerName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "analyzerName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RuleName != nil {
		v := *s.RuleName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ruleName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The response to the request.
type GetArchiveRuleOutput struct {
	_ struct{} `type:"structure"`

	// Contains information about an archive rule.
	//
	// ArchiveRule is a required field
	ArchiveRule *ArchiveRuleSummary `locationName:"archiveRule" type:"structure" required:"true"`
}

// String returns the string representation
func (s GetArchiveRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetArchiveRuleOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ArchiveRule != nil {
		v := s.ArchiveRule

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "archiveRule", v, metadata)
	}
	return nil
}

const opGetArchiveRule = "GetArchiveRule"

// GetArchiveRuleRequest returns a request value for making API operation for
// Access Analyzer.
//
// Retrieves information about an archive rule.
//
//    // Example sending a request using GetArchiveRuleRequest.
//    req := client.GetArchiveRuleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/GetArchiveRule
func (c *Client) GetArchiveRuleRequest(input *GetArchiveRuleInput) GetArchiveRuleRequest {
	op := &aws.Operation{
		Name:       opGetArchiveRule,
		HTTPMethod: "GET",
		HTTPPath:   "/analyzer/{analyzerName}/archive-rule/{ruleName}",
	}

	if input == nil {
		input = &GetArchiveRuleInput{}
	}

	req := c.newRequest(op, input, &GetArchiveRuleOutput{})

	return GetArchiveRuleRequest{Request: req, Input: input, Copy: c.GetArchiveRuleRequest}
}

// GetArchiveRuleRequest is the request type for the
// GetArchiveRule API operation.
type GetArchiveRuleRequest struct {
	*aws.Request
	Input *GetArchiveRuleInput
	Copy  func(*GetArchiveRuleInput) GetArchiveRuleRequest
}

// Send marshals and sends the GetArchiveRule API request.
func (r GetArchiveRuleRequest) Send(ctx context.Context) (*GetArchiveRuleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetArchiveRuleResponse{
		GetArchiveRuleOutput: r.Request.Data.(*GetArchiveRuleOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetArchiveRuleResponse is the response type for the
// GetArchiveRule API operation.
type GetArchiveRuleResponse struct {
	*GetArchiveRuleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetArchiveRule request.
func (r *GetArchiveRuleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
