// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package accessanalyzer

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Retrieves a list of resources that have been analyzed.
type ListAnalyzedResourcesInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the analyzer to retrieve a list of analyzed resources from.
	//
	// AnalyzerArn is a required field
	AnalyzerArn *string `locationName:"analyzerArn" type:"string" required:"true"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// A token used for pagination of results returned.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The type of resource.
	ResourceType ResourceType `locationName:"resourceType" type:"string" enum:"true"`
}

// String returns the string representation
func (s ListAnalyzedResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAnalyzedResourcesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListAnalyzedResourcesInput"}

	if s.AnalyzerArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("AnalyzerArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListAnalyzedResourcesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AnalyzerArn != nil {
		v := *s.AnalyzerArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "analyzerArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ResourceType) > 0 {
		v := s.ResourceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resourceType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// The response to the request.
type ListAnalyzedResourcesOutput struct {
	_ struct{} `type:"structure"`

	// A list of resources that were analyzed.
	//
	// AnalyzedResources is a required field
	AnalyzedResources []AnalyzedResourceSummary `locationName:"analyzedResources" type:"list" required:"true"`

	// A token used for pagination of results returned.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListAnalyzedResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListAnalyzedResourcesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AnalyzedResources != nil {
		v := s.AnalyzedResources

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "analyzedResources", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListAnalyzedResources = "ListAnalyzedResources"

// ListAnalyzedResourcesRequest returns a request value for making API operation for
// Access Analyzer.
//
// Retrieves a list of resources of the specified type that have been analyzed
// by the specified analyzer..
//
//    // Example sending a request using ListAnalyzedResourcesRequest.
//    req := client.ListAnalyzedResourcesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/ListAnalyzedResources
func (c *Client) ListAnalyzedResourcesRequest(input *ListAnalyzedResourcesInput) ListAnalyzedResourcesRequest {
	op := &aws.Operation{
		Name:       opListAnalyzedResources,
		HTTPMethod: "POST",
		HTTPPath:   "/analyzed-resource",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAnalyzedResourcesInput{}
	}

	req := c.newRequest(op, input, &ListAnalyzedResourcesOutput{})

	return ListAnalyzedResourcesRequest{Request: req, Input: input, Copy: c.ListAnalyzedResourcesRequest}
}

// ListAnalyzedResourcesRequest is the request type for the
// ListAnalyzedResources API operation.
type ListAnalyzedResourcesRequest struct {
	*aws.Request
	Input *ListAnalyzedResourcesInput
	Copy  func(*ListAnalyzedResourcesInput) ListAnalyzedResourcesRequest
}

// Send marshals and sends the ListAnalyzedResources API request.
func (r ListAnalyzedResourcesRequest) Send(ctx context.Context) (*ListAnalyzedResourcesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListAnalyzedResourcesResponse{
		ListAnalyzedResourcesOutput: r.Request.Data.(*ListAnalyzedResourcesOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListAnalyzedResourcesRequestPaginator returns a paginator for ListAnalyzedResources.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListAnalyzedResourcesRequest(input)
//   p := accessanalyzer.NewListAnalyzedResourcesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListAnalyzedResourcesPaginator(req ListAnalyzedResourcesRequest) ListAnalyzedResourcesPaginator {
	return ListAnalyzedResourcesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListAnalyzedResourcesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListAnalyzedResourcesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListAnalyzedResourcesPaginator struct {
	aws.Pager
}

func (p *ListAnalyzedResourcesPaginator) CurrentPage() *ListAnalyzedResourcesOutput {
	return p.Pager.CurrentPage().(*ListAnalyzedResourcesOutput)
}

// ListAnalyzedResourcesResponse is the response type for the
// ListAnalyzedResources API operation.
type ListAnalyzedResourcesResponse struct {
	*ListAnalyzedResourcesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListAnalyzedResources request.
func (r *ListAnalyzedResourcesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
