// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package acm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ExportCertificateInput struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) of the issued certificate. This must be of
	// the form:
	//
	// arn:aws:acm:region:account:certificate/12345678-1234-1234-1234-123456789012
	//
	// CertificateArn is a required field
	CertificateArn *string `min:"20" type:"string" required:"true"`

	// Passphrase to associate with the encrypted exported private key. If you want
	// to later decrypt the private key, you must have the passphrase. You can use
	// the following OpenSSL command to decrypt a private key:
	//
	// openssl rsa -in encrypted_key.pem -out decrypted_key.pem
	//
	// Passphrase is automatically base64 encoded/decoded by the SDK.
	//
	// Passphrase is a required field
	Passphrase []byte `min:"4" type:"blob" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s ExportCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportCertificateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ExportCertificateInput"}

	if s.CertificateArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("CertificateArn"))
	}
	if s.CertificateArn != nil && len(*s.CertificateArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("CertificateArn", 20))
	}

	if s.Passphrase == nil {
		invalidParams.Add(aws.NewErrParamRequired("Passphrase"))
	}
	if s.Passphrase != nil && len(s.Passphrase) < 4 {
		invalidParams.Add(aws.NewErrParamMinLen("Passphrase", 4))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ExportCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The base64 PEM-encoded certificate.
	Certificate *string `min:"1" type:"string"`

	// The base64 PEM-encoded certificate chain. This does not include the certificate
	// that you are exporting.
	CertificateChain *string `min:"1" type:"string"`

	// The encrypted private key associated with the public key in the certificate.
	// The key is output in PKCS #8 format and is base64 PEM-encoded.
	PrivateKey *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s ExportCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

const opExportCertificate = "ExportCertificate"

// ExportCertificateRequest returns a request value for making API operation for
// AWS Certificate Manager.
//
// Exports a private certificate issued by a private certificate authority (CA)
// for use anywhere. The exported file contains the certificate, the certificate
// chain, and the encrypted private 2048-bit RSA key associated with the public
// key that is embedded in the certificate. For security, you must assign a
// passphrase for the private key when exporting it.
//
// For information about exporting and formatting a certificate using the ACM
// console or CLI, see Export a Private Certificate (https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-export-private.html).
//
//    // Example sending a request using ExportCertificateRequest.
//    req := client.ExportCertificateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/ExportCertificate
func (c *Client) ExportCertificateRequest(input *ExportCertificateInput) ExportCertificateRequest {
	op := &aws.Operation{
		Name:       opExportCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExportCertificateInput{}
	}

	req := c.newRequest(op, input, &ExportCertificateOutput{})

	return ExportCertificateRequest{Request: req, Input: input, Copy: c.ExportCertificateRequest}
}

// ExportCertificateRequest is the request type for the
// ExportCertificate API operation.
type ExportCertificateRequest struct {
	*aws.Request
	Input *ExportCertificateInput
	Copy  func(*ExportCertificateInput) ExportCertificateRequest
}

// Send marshals and sends the ExportCertificate API request.
func (r ExportCertificateRequest) Send(ctx context.Context) (*ExportCertificateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ExportCertificateResponse{
		ExportCertificateOutput: r.Request.Data.(*ExportCertificateOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ExportCertificateResponse is the response type for the
// ExportCertificate API operation.
type ExportCertificateResponse struct {
	*ExportCertificateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ExportCertificate request.
func (r *ExportCertificateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
