// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package acm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type RenewCertificateInput struct {
	_ struct{} `type:"structure"`

	// String that contains the ARN of the ACM certificate to be renewed. This must
	// be of the form:
	//
	// arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// CertificateArn is a required field
	CertificateArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s RenewCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RenewCertificateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RenewCertificateInput"}

	if s.CertificateArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("CertificateArn"))
	}
	if s.CertificateArn != nil && len(*s.CertificateArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("CertificateArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RenewCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RenewCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

const opRenewCertificate = "RenewCertificate"

// RenewCertificateRequest returns a request value for making API operation for
// AWS Certificate Manager.
//
// Renews an eligable ACM certificate. At this time, only exported private certificates
// can be renewed with this operation. In order to renew your ACM PCA certificates
// with ACM, you must first grant the ACM service principal permission to do
// so (https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaPermissions.html).
// For more information, see Testing Managed Renewal (https://docs.aws.amazon.com/acm/latest/userguide/manual-renewal.html)
// in the ACM User Guide.
//
//    // Example sending a request using RenewCertificateRequest.
//    req := client.RenewCertificateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/acm-2015-12-08/RenewCertificate
func (c *Client) RenewCertificateRequest(input *RenewCertificateInput) RenewCertificateRequest {
	op := &aws.Operation{
		Name:       opRenewCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RenewCertificateInput{}
	}

	req := c.newRequest(op, input, &RenewCertificateOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return RenewCertificateRequest{Request: req, Input: input, Copy: c.RenewCertificateRequest}
}

// RenewCertificateRequest is the request type for the
// RenewCertificate API operation.
type RenewCertificateRequest struct {
	*aws.Request
	Input *RenewCertificateInput
	Copy  func(*RenewCertificateInput) RenewCertificateRequest
}

// Send marshals and sends the RenewCertificate API request.
func (r RenewCertificateRequest) Send(ctx context.Context) (*RenewCertificateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RenewCertificateResponse{
		RenewCertificateOutput: r.Request.Data.(*RenewCertificateOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RenewCertificateResponse is the response type for the
// RenewCertificate API operation.
type RenewCertificateResponse struct {
	*RenewCertificateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RenewCertificate request.
func (r *RenewCertificateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
