// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package acmpca

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListCertificateAuthoritiesInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter when paginating results to specify the maximum number
	// of items to return in the response on each page. If additional items exist
	// beyond the number you specify, the NextToken element is sent in the response.
	// Use this NextToken value in a subsequent request to retrieve additional items.
	MaxResults *int64 `min:"1" type:"integer"`

	// Use this parameter when paginating results in a subsequent request after
	// you receive a response with truncated results. Set it to the value of the
	// NextToken parameter from the response you just received.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListCertificateAuthoritiesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCertificateAuthoritiesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListCertificateAuthoritiesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListCertificateAuthoritiesOutput struct {
	_ struct{} `type:"structure"`

	// Summary information about each certificate authority you have created.
	CertificateAuthorities []CertificateAuthority `type:"list"`

	// When the list is truncated, this value is present and should be used for
	// the NextToken parameter in a subsequent pagination request.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListCertificateAuthoritiesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListCertificateAuthorities = "ListCertificateAuthorities"

// ListCertificateAuthoritiesRequest returns a request value for making API operation for
// AWS Certificate Manager Private Certificate Authority.
//
// Lists the private certificate authorities that you created by using the CreateCertificateAuthority
// action.
//
//    // Example sending a request using ListCertificateAuthoritiesRequest.
//    req := client.ListCertificateAuthoritiesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/ListCertificateAuthorities
func (c *Client) ListCertificateAuthoritiesRequest(input *ListCertificateAuthoritiesInput) ListCertificateAuthoritiesRequest {
	op := &aws.Operation{
		Name:       opListCertificateAuthorities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCertificateAuthoritiesInput{}
	}

	req := c.newRequest(op, input, &ListCertificateAuthoritiesOutput{})

	return ListCertificateAuthoritiesRequest{Request: req, Input: input, Copy: c.ListCertificateAuthoritiesRequest}
}

// ListCertificateAuthoritiesRequest is the request type for the
// ListCertificateAuthorities API operation.
type ListCertificateAuthoritiesRequest struct {
	*aws.Request
	Input *ListCertificateAuthoritiesInput
	Copy  func(*ListCertificateAuthoritiesInput) ListCertificateAuthoritiesRequest
}

// Send marshals and sends the ListCertificateAuthorities API request.
func (r ListCertificateAuthoritiesRequest) Send(ctx context.Context) (*ListCertificateAuthoritiesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListCertificateAuthoritiesResponse{
		ListCertificateAuthoritiesOutput: r.Request.Data.(*ListCertificateAuthoritiesOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListCertificateAuthoritiesRequestPaginator returns a paginator for ListCertificateAuthorities.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListCertificateAuthoritiesRequest(input)
//   p := acmpca.NewListCertificateAuthoritiesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListCertificateAuthoritiesPaginator(req ListCertificateAuthoritiesRequest) ListCertificateAuthoritiesPaginator {
	return ListCertificateAuthoritiesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListCertificateAuthoritiesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListCertificateAuthoritiesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListCertificateAuthoritiesPaginator struct {
	aws.Pager
}

func (p *ListCertificateAuthoritiesPaginator) CurrentPage() *ListCertificateAuthoritiesOutput {
	return p.Pager.CurrentPage().(*ListCertificateAuthoritiesOutput)
}

// ListCertificateAuthoritiesResponse is the response type for the
// ListCertificateAuthorities API operation.
type ListCertificateAuthoritiesResponse struct {
	*ListCertificateAuthoritiesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListCertificateAuthorities request.
func (r *ListCertificateAuthoritiesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
