// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type AssociateContactWithAddressBookInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the address book with which to associate the contact.
	//
	// AddressBookArn is a required field
	AddressBookArn *string `type:"string" required:"true"`

	// The ARN of the contact to associate with an address book.
	//
	// ContactArn is a required field
	ContactArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateContactWithAddressBookInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateContactWithAddressBookInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssociateContactWithAddressBookInput"}

	if s.AddressBookArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("AddressBookArn"))
	}

	if s.ContactArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ContactArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AssociateContactWithAddressBookOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateContactWithAddressBookOutput) String() string {
	return awsutil.Prettify(s)
}

const opAssociateContactWithAddressBook = "AssociateContactWithAddressBook"

// AssociateContactWithAddressBookRequest returns a request value for making API operation for
// Alexa For Business.
//
// Associates a contact with a given address book.
//
//    // Example sending a request using AssociateContactWithAddressBookRequest.
//    req := client.AssociateContactWithAddressBookRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/AssociateContactWithAddressBook
func (c *Client) AssociateContactWithAddressBookRequest(input *AssociateContactWithAddressBookInput) AssociateContactWithAddressBookRequest {
	op := &aws.Operation{
		Name:       opAssociateContactWithAddressBook,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateContactWithAddressBookInput{}
	}

	req := c.newRequest(op, input, &AssociateContactWithAddressBookOutput{})

	return AssociateContactWithAddressBookRequest{Request: req, Input: input, Copy: c.AssociateContactWithAddressBookRequest}
}

// AssociateContactWithAddressBookRequest is the request type for the
// AssociateContactWithAddressBook API operation.
type AssociateContactWithAddressBookRequest struct {
	*aws.Request
	Input *AssociateContactWithAddressBookInput
	Copy  func(*AssociateContactWithAddressBookInput) AssociateContactWithAddressBookRequest
}

// Send marshals and sends the AssociateContactWithAddressBook API request.
func (r AssociateContactWithAddressBookRequest) Send(ctx context.Context) (*AssociateContactWithAddressBookResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AssociateContactWithAddressBookResponse{
		AssociateContactWithAddressBookOutput: r.Request.Data.(*AssociateContactWithAddressBookOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AssociateContactWithAddressBookResponse is the response type for the
// AssociateContactWithAddressBook API operation.
type AssociateContactWithAddressBookResponse struct {
	*AssociateContactWithAddressBookOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AssociateContactWithAddressBook request.
func (r *AssociateContactWithAddressBookResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
