// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetRoomInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the room for which to request details. Required.
	RoomArn *string `type:"string"`
}

// String returns the string representation
func (s GetRoomInput) String() string {
	return awsutil.Prettify(s)
}

type GetRoomOutput struct {
	_ struct{} `type:"structure"`

	// The details of the room requested.
	Room *Room `type:"structure"`
}

// String returns the string representation
func (s GetRoomOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetRoom = "GetRoom"

// GetRoomRequest returns a request value for making API operation for
// Alexa For Business.
//
// Gets room details by room ARN.
//
//    // Example sending a request using GetRoomRequest.
//    req := client.GetRoomRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/GetRoom
func (c *Client) GetRoomRequest(input *GetRoomInput) GetRoomRequest {
	op := &aws.Operation{
		Name:       opGetRoom,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRoomInput{}
	}

	req := c.newRequest(op, input, &GetRoomOutput{})

	return GetRoomRequest{Request: req, Input: input, Copy: c.GetRoomRequest}
}

// GetRoomRequest is the request type for the
// GetRoom API operation.
type GetRoomRequest struct {
	*aws.Request
	Input *GetRoomInput
	Copy  func(*GetRoomInput) GetRoomRequest
}

// Send marshals and sends the GetRoom API request.
func (r GetRoomRequest) Send(ctx context.Context) (*GetRoomResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetRoomResponse{
		GetRoomOutput: r.Request.Data.(*GetRoomOutput),
		response:      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetRoomResponse is the response type for the
// GetRoom API operation.
type GetRoomResponse struct {
	*GetRoomOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetRoom request.
func (r *GetRoomResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
