// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListConferenceProvidersInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of conference providers to be returned, per paginated
	// calls.
	MaxResults *int64 `min:"1" type:"integer"`

	// The tokens used for pagination.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListConferenceProvidersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListConferenceProvidersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListConferenceProvidersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListConferenceProvidersOutput struct {
	_ struct{} `type:"structure"`

	// The conference providers.
	ConferenceProviders []ConferenceProvider `type:"list"`

	// The tokens used for pagination.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListConferenceProvidersOutput) String() string {
	return awsutil.Prettify(s)
}

const opListConferenceProviders = "ListConferenceProviders"

// ListConferenceProvidersRequest returns a request value for making API operation for
// Alexa For Business.
//
// Lists conference providers under a specific AWS account.
//
//    // Example sending a request using ListConferenceProvidersRequest.
//    req := client.ListConferenceProvidersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/ListConferenceProviders
func (c *Client) ListConferenceProvidersRequest(input *ListConferenceProvidersInput) ListConferenceProvidersRequest {
	op := &aws.Operation{
		Name:       opListConferenceProviders,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListConferenceProvidersInput{}
	}

	req := c.newRequest(op, input, &ListConferenceProvidersOutput{})

	return ListConferenceProvidersRequest{Request: req, Input: input, Copy: c.ListConferenceProvidersRequest}
}

// ListConferenceProvidersRequest is the request type for the
// ListConferenceProviders API operation.
type ListConferenceProvidersRequest struct {
	*aws.Request
	Input *ListConferenceProvidersInput
	Copy  func(*ListConferenceProvidersInput) ListConferenceProvidersRequest
}

// Send marshals and sends the ListConferenceProviders API request.
func (r ListConferenceProvidersRequest) Send(ctx context.Context) (*ListConferenceProvidersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListConferenceProvidersResponse{
		ListConferenceProvidersOutput: r.Request.Data.(*ListConferenceProvidersOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListConferenceProvidersRequestPaginator returns a paginator for ListConferenceProviders.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListConferenceProvidersRequest(input)
//   p := alexaforbusiness.NewListConferenceProvidersRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListConferenceProvidersPaginator(req ListConferenceProvidersRequest) ListConferenceProvidersPaginator {
	return ListConferenceProvidersPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListConferenceProvidersInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListConferenceProvidersPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListConferenceProvidersPaginator struct {
	aws.Pager
}

func (p *ListConferenceProvidersPaginator) CurrentPage() *ListConferenceProvidersOutput {
	return p.Pager.CurrentPage().(*ListConferenceProvidersOutput)
}

// ListConferenceProvidersResponse is the response type for the
// ListConferenceProviders API operation.
type ListConferenceProvidersResponse struct {
	*ListConferenceProvidersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListConferenceProviders request.
func (r *ListConferenceProvidersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
