// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type SearchAddressBooksInput struct {
	_ struct{} `type:"structure"`

	// The filters to use to list a specified set of address books. The supported
	// filter key is AddressBookName.
	Filters []Filter `type:"list"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	MaxResults *int64 `min:"1" type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// only includes results beyond the token, up to the value specified by MaxResults.
	NextToken *string `min:"1" type:"string"`

	// The sort order to use in listing the specified set of address books. The
	// supported sort key is AddressBookName.
	SortCriteria []Sort `type:"list"`
}

// String returns the string representation
func (s SearchAddressBooksInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchAddressBooksInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SearchAddressBooksInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.SortCriteria != nil {
		for i, v := range s.SortCriteria {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SortCriteria", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SearchAddressBooksOutput struct {
	_ struct{} `type:"structure"`

	// The address books that meet the specified set of filter criteria, in sort
	// order.
	AddressBooks []AddressBookData `type:"list"`

	// The token returned to indicate that there is more data available.
	NextToken *string `min:"1" type:"string"`

	// The total number of address books returned.
	TotalCount *int64 `type:"integer"`
}

// String returns the string representation
func (s SearchAddressBooksOutput) String() string {
	return awsutil.Prettify(s)
}

const opSearchAddressBooks = "SearchAddressBooks"

// SearchAddressBooksRequest returns a request value for making API operation for
// Alexa For Business.
//
// Searches address books and lists the ones that meet a set of filter and sort
// criteria.
//
//    // Example sending a request using SearchAddressBooksRequest.
//    req := client.SearchAddressBooksRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/SearchAddressBooks
func (c *Client) SearchAddressBooksRequest(input *SearchAddressBooksInput) SearchAddressBooksRequest {
	op := &aws.Operation{
		Name:       opSearchAddressBooks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchAddressBooksInput{}
	}

	req := c.newRequest(op, input, &SearchAddressBooksOutput{})

	return SearchAddressBooksRequest{Request: req, Input: input, Copy: c.SearchAddressBooksRequest}
}

// SearchAddressBooksRequest is the request type for the
// SearchAddressBooks API operation.
type SearchAddressBooksRequest struct {
	*aws.Request
	Input *SearchAddressBooksInput
	Copy  func(*SearchAddressBooksInput) SearchAddressBooksRequest
}

// Send marshals and sends the SearchAddressBooks API request.
func (r SearchAddressBooksRequest) Send(ctx context.Context) (*SearchAddressBooksResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SearchAddressBooksResponse{
		SearchAddressBooksOutput: r.Request.Data.(*SearchAddressBooksOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewSearchAddressBooksRequestPaginator returns a paginator for SearchAddressBooks.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.SearchAddressBooksRequest(input)
//   p := alexaforbusiness.NewSearchAddressBooksRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewSearchAddressBooksPaginator(req SearchAddressBooksRequest) SearchAddressBooksPaginator {
	return SearchAddressBooksPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *SearchAddressBooksInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// SearchAddressBooksPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type SearchAddressBooksPaginator struct {
	aws.Pager
}

func (p *SearchAddressBooksPaginator) CurrentPage() *SearchAddressBooksOutput {
	return p.Pager.CurrentPage().(*SearchAddressBooksOutput)
}

// SearchAddressBooksResponse is the response type for the
// SearchAddressBooks API operation.
type SearchAddressBooksResponse struct {
	*SearchAddressBooksOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SearchAddressBooks request.
func (r *SearchAddressBooksResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
