// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateAddressBookInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the room to update.
	//
	// AddressBookArn is a required field
	AddressBookArn *string `type:"string" required:"true"`

	// The updated description of the room.
	Description *string `min:"1" type:"string"`

	// The updated name of the room.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateAddressBookInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAddressBookInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateAddressBookInput"}

	if s.AddressBookArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("AddressBookArn"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateAddressBookOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateAddressBookOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateAddressBook = "UpdateAddressBook"

// UpdateAddressBookRequest returns a request value for making API operation for
// Alexa For Business.
//
// Updates address book details by the address book ARN.
//
//    // Example sending a request using UpdateAddressBookRequest.
//    req := client.UpdateAddressBookRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/UpdateAddressBook
func (c *Client) UpdateAddressBookRequest(input *UpdateAddressBookInput) UpdateAddressBookRequest {
	op := &aws.Operation{
		Name:       opUpdateAddressBook,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAddressBookInput{}
	}

	req := c.newRequest(op, input, &UpdateAddressBookOutput{})

	return UpdateAddressBookRequest{Request: req, Input: input, Copy: c.UpdateAddressBookRequest}
}

// UpdateAddressBookRequest is the request type for the
// UpdateAddressBook API operation.
type UpdateAddressBookRequest struct {
	*aws.Request
	Input *UpdateAddressBookInput
	Copy  func(*UpdateAddressBookInput) UpdateAddressBookRequest
}

// Send marshals and sends the UpdateAddressBook API request.
func (r UpdateAddressBookRequest) Send(ctx context.Context) (*UpdateAddressBookResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateAddressBookResponse{
		UpdateAddressBookOutput: r.Request.Data.(*UpdateAddressBookOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateAddressBookResponse is the response type for the
// UpdateAddressBook API operation.
type UpdateAddressBookResponse struct {
	*UpdateAddressBookOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateAddressBook request.
func (r *UpdateAddressBookResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
