// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package amplify

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Represents the different branches of a repository for building, deploying,
// and hosting an Amplify app.
type App struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amplify app.
	//
	// AppArn is a required field
	AppArn *string `locationName:"appArn" type:"string" required:"true"`

	// The unique ID of the Amplify app.
	//
	// AppId is a required field
	AppId *string `locationName:"appId" min:"1" type:"string" required:"true"`

	// Describes the automated branch creation configuration for the Amplify app.
	AutoBranchCreationConfig *AutoBranchCreationConfig `locationName:"autoBranchCreationConfig" type:"structure"`

	// Describes the automated branch creation glob patterns for the Amplify app.
	AutoBranchCreationPatterns []string `locationName:"autoBranchCreationPatterns" type:"list"`

	// The basic authorization credentials for branches for the Amplify app.
	BasicAuthCredentials *string `locationName:"basicAuthCredentials" type:"string" sensitive:"true"`

	// Describes the content of the build specification (build spec) for the Amplify
	// app.
	BuildSpec *string `locationName:"buildSpec" min:"1" type:"string"`

	// Creates a date and time for the Amplify app.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// Describes the custom redirect and rewrite rules for the Amplify app.
	CustomRules []CustomRule `locationName:"customRules" type:"list"`

	// The default domain for the Amplify app.
	//
	// DefaultDomain is a required field
	DefaultDomain *string `locationName:"defaultDomain" min:"1" type:"string" required:"true"`

	// The description for the Amplify app.
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// Enables automated branch creation for the Amplify app.
	EnableAutoBranchCreation *bool `locationName:"enableAutoBranchCreation" type:"boolean"`

	// Enables basic authorization for the Amplify app's branches.
	//
	// EnableBasicAuth is a required field
	EnableBasicAuth *bool `locationName:"enableBasicAuth" type:"boolean" required:"true"`

	// Enables the auto-building of branches for the Amplify app.
	//
	// EnableBranchAutoBuild is a required field
	EnableBranchAutoBuild *bool `locationName:"enableBranchAutoBuild" type:"boolean" required:"true"`

	// Automatically disconnect a branch in the Amplify Console when you delete
	// a branch from your Git repository.
	EnableBranchAutoDeletion *bool `locationName:"enableBranchAutoDeletion" type:"boolean"`

	// The environment variables for the Amplify app.
	//
	// EnvironmentVariables is a required field
	EnvironmentVariables map[string]string `locationName:"environmentVariables" type:"map" required:"true"`

	// The AWS Identity and Access Management (IAM) service role for the Amazon
	// Resource Name (ARN) of the Amplify app.
	IamServiceRoleArn *string `locationName:"iamServiceRoleArn" min:"1" type:"string"`

	// The name for the Amplify app.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The platform for the Amplify app.
	//
	// Platform is a required field
	Platform Platform `locationName:"platform" type:"string" required:"true" enum:"true"`

	// Describes the information about a production branch of the Amplify app.
	ProductionBranch *ProductionBranch `locationName:"productionBranch" type:"structure"`

	// The repository for the Amplify app.
	//
	// Repository is a required field
	Repository *string `locationName:"repository" type:"string" required:"true"`

	// The tag for the Amplify app.
	Tags map[string]string `locationName:"tags" min:"1" type:"map"`

	// Updates the date and time for the Amplify app.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`
}

// String returns the string representation
func (s App) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s App) MarshalFields(e protocol.FieldEncoder) error {
	if s.AppArn != nil {
		v := *s.AppArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "appArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AppId != nil {
		v := *s.AppId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "appId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AutoBranchCreationConfig != nil {
		v := s.AutoBranchCreationConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "autoBranchCreationConfig", v, metadata)
	}
	if s.AutoBranchCreationPatterns != nil {
		v := s.AutoBranchCreationPatterns

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "autoBranchCreationPatterns", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.BasicAuthCredentials != nil {
		v := *s.BasicAuthCredentials

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "basicAuthCredentials", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BuildSpec != nil {
		v := *s.BuildSpec

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "buildSpec", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreateTime != nil {
		v := *s.CreateTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.CustomRules != nil {
		v := s.CustomRules

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "customRules", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.DefaultDomain != nil {
		v := *s.DefaultDomain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "defaultDomain", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EnableAutoBranchCreation != nil {
		v := *s.EnableAutoBranchCreation

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "enableAutoBranchCreation", protocol.BoolValue(v), metadata)
	}
	if s.EnableBasicAuth != nil {
		v := *s.EnableBasicAuth

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "enableBasicAuth", protocol.BoolValue(v), metadata)
	}
	if s.EnableBranchAutoBuild != nil {
		v := *s.EnableBranchAutoBuild

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "enableBranchAutoBuild", protocol.BoolValue(v), metadata)
	}
	if s.EnableBranchAutoDeletion != nil {
		v := *s.EnableBranchAutoDeletion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "enableBranchAutoDeletion", protocol.BoolValue(v), metadata)
	}
	if s.EnvironmentVariables != nil {
		v := s.EnvironmentVariables

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "environmentVariables", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.IamServiceRoleArn != nil {
		v := *s.IamServiceRoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "iamServiceRoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Platform) > 0 {
		v := s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "platform", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ProductionBranch != nil {
		v := s.ProductionBranch

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "productionBranch", v, metadata)
	}
	if s.Repository != nil {
		v := *s.Repository

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "repository", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.UpdateTime != nil {
		v := *s.UpdateTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "updateTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	return nil
}

// Describes an artifact.
type Artifact struct {
	_ struct{} `type:"structure"`

	// The file name for the artifact.
	//
	// ArtifactFileName is a required field
	ArtifactFileName *string `locationName:"artifactFileName" type:"string" required:"true"`

	// The unique ID for the artifact.
	//
	// ArtifactId is a required field
	ArtifactId *string `locationName:"artifactId" type:"string" required:"true"`
}

// String returns the string representation
func (s Artifact) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Artifact) MarshalFields(e protocol.FieldEncoder) error {
	if s.ArtifactFileName != nil {
		v := *s.ArtifactFileName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "artifactFileName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ArtifactId != nil {
		v := *s.ArtifactId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "artifactId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes the automated branch creation configuration.
type AutoBranchCreationConfig struct {
	_ struct{} `type:"structure"`

	// The basic authorization credentials for the autocreated branch.
	BasicAuthCredentials *string `locationName:"basicAuthCredentials" type:"string" sensitive:"true"`

	// The build specification (build spec) for the autocreated branch.
	BuildSpec *string `locationName:"buildSpec" min:"1" type:"string"`

	// Enables auto building for the autocreated branch.
	EnableAutoBuild *bool `locationName:"enableAutoBuild" type:"boolean"`

	// Enables basic authorization for the autocreated branch.
	EnableBasicAuth *bool `locationName:"enableBasicAuth" type:"boolean"`

	// Enables pull request preview for the autocreated branch.
	EnablePullRequestPreview *bool `locationName:"enablePullRequestPreview" type:"boolean"`

	// The environment variables for the autocreated branch.
	EnvironmentVariables map[string]string `locationName:"environmentVariables" type:"map"`

	// The framework for the autocreated branch.
	Framework *string `locationName:"framework" type:"string"`

	// The Amplify environment name for the pull request.
	PullRequestEnvironmentName *string `locationName:"pullRequestEnvironmentName" type:"string"`

	// Describes the current stage for the autocreated branch.
	Stage Stage `locationName:"stage" type:"string" enum:"true"`
}

// String returns the string representation
func (s AutoBranchCreationConfig) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoBranchCreationConfig) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AutoBranchCreationConfig"}
	if s.BuildSpec != nil && len(*s.BuildSpec) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("BuildSpec", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AutoBranchCreationConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.BasicAuthCredentials != nil {
		v := *s.BasicAuthCredentials

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "basicAuthCredentials", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BuildSpec != nil {
		v := *s.BuildSpec

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "buildSpec", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EnableAutoBuild != nil {
		v := *s.EnableAutoBuild

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "enableAutoBuild", protocol.BoolValue(v), metadata)
	}
	if s.EnableBasicAuth != nil {
		v := *s.EnableBasicAuth

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "enableBasicAuth", protocol.BoolValue(v), metadata)
	}
	if s.EnablePullRequestPreview != nil {
		v := *s.EnablePullRequestPreview

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "enablePullRequestPreview", protocol.BoolValue(v), metadata)
	}
	if s.EnvironmentVariables != nil {
		v := s.EnvironmentVariables

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "environmentVariables", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Framework != nil {
		v := *s.Framework

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "framework", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PullRequestEnvironmentName != nil {
		v := *s.PullRequestEnvironmentName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "pullRequestEnvironmentName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Stage) > 0 {
		v := s.Stage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stage", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Describes the backend environment for an Amplify app.
type BackendEnvironment struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for a backend environment that is part of
	// an Amplify app.
	//
	// BackendEnvironmentArn is a required field
	BackendEnvironmentArn *string `locationName:"backendEnvironmentArn" min:"1" type:"string" required:"true"`

	// The creation date and time for a backend environment that is part of an Amplify
	// app.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// The name of deployment artifacts.
	DeploymentArtifacts *string `locationName:"deploymentArtifacts" min:"1" type:"string"`

	// The name for a backend environment that is part of an Amplify app.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `locationName:"environmentName" min:"1" type:"string" required:"true"`

	// The AWS CloudFormation stack name of a backend environment.
	StackName *string `locationName:"stackName" min:"1" type:"string"`

	// The last updated date and time for a backend environment that is part of
	// an Amplify app.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`
}

// String returns the string representation
func (s BackendEnvironment) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BackendEnvironment) MarshalFields(e protocol.FieldEncoder) error {
	if s.BackendEnvironmentArn != nil {
		v := *s.BackendEnvironmentArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "backendEnvironmentArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreateTime != nil {
		v := *s.CreateTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.DeploymentArtifacts != nil {
		v := *s.DeploymentArtifacts

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deploymentArtifacts", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EnvironmentName != nil {
		v := *s.EnvironmentName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "environmentName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StackName != nil {
		v := *s.StackName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stackName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UpdateTime != nil {
		v := *s.UpdateTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "updateTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	return nil
}

// The branch for an Amplify app, which maps to a third-party repository branch.
type Branch struct {
	_ struct{} `type:"structure"`

	// The ID of the active job for a branch of an Amplify app.
	//
	// ActiveJobId is a required field
	ActiveJobId *string `locationName:"activeJobId" type:"string" required:"true"`

	// A list of custom resources that are linked to this branch.
	AssociatedResources []string `locationName:"associatedResources" type:"list"`

	// The Amazon Resource Name (ARN) for a backend environment that is part of
	// an Amplify app.
	BackendEnvironmentArn *string `locationName:"backendEnvironmentArn" min:"1" type:"string"`

	// The basic authorization credentials for a branch of an Amplify app.
	BasicAuthCredentials *string `locationName:"basicAuthCredentials" type:"string" sensitive:"true"`

	// The Amazon Resource Name (ARN) for a branch that is part of an Amplify app.
	//
	// BranchArn is a required field
	BranchArn *string `locationName:"branchArn" type:"string" required:"true"`

	// The name for the branch that is part of an Amplify app.
	//
	// BranchName is a required field
	BranchName *string `locationName:"branchName" min:"1" type:"string" required:"true"`

	// The build specification (build spec) content for the branch of an Amplify
	// app.
	BuildSpec *string `locationName:"buildSpec" min:"1" type:"string"`

	// The creation date and time for a branch that is part of an Amplify app.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// The custom domains for a branch of an Amplify app.
	//
	// CustomDomains is a required field
	CustomDomains []string `locationName:"customDomains" type:"list" required:"true"`

	// The description for the branch that is part of an Amplify app.
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// The destination branch if the branch is a pull request branch.
	DestinationBranch *string `locationName:"destinationBranch" min:"1" type:"string"`

	// The display name for the branch. This is used as the default domain prefix.
	//
	// DisplayName is a required field
	DisplayName *string `locationName:"displayName" type:"string" required:"true"`

	// Enables auto-building on push for a branch of an Amplify app.
	//
	// EnableAutoBuild is a required field
	EnableAutoBuild *bool `locationName:"enableAutoBuild" type:"boolean" required:"true"`

	// Enables basic authorization for a branch of an Amplify app.
	//
	// EnableBasicAuth is a required field
	EnableBasicAuth *bool `locationName:"enableBasicAuth" type:"boolean" required:"true"`

	// Enables notifications for a branch that is part of an Amplify app.
	//
	// EnableNotification is a required field
	EnableNotification *bool `locationName:"enableNotification" type:"boolean" required:"true"`

	// Enables pull request preview for the branch.
	//
	// EnablePullRequestPreview is a required field
	EnablePullRequestPreview *bool `locationName:"enablePullRequestPreview" type:"boolean" required:"true"`

	// The environment variables specific to a branch of an Amplify app.
	//
	// EnvironmentVariables is a required field
	EnvironmentVariables map[string]string `locationName:"environmentVariables" type:"map" required:"true"`

	// The framework for a branch of an Amplify app.
	//
	// Framework is a required field
	Framework *string `locationName:"framework" type:"string" required:"true"`

	// The Amplify environment name for the pull request.
	PullRequestEnvironmentName *string `locationName:"pullRequestEnvironmentName" type:"string"`

	// The source branch if the branch is a pull request branch.
	SourceBranch *string `locationName:"sourceBranch" min:"1" type:"string"`

	// The current stage for the branch that is part of an Amplify app.
	//
	// Stage is a required field
	Stage Stage `locationName:"stage" type:"string" required:"true" enum:"true"`

	// The tag for the branch of an Amplify app.
	Tags map[string]string `locationName:"tags" min:"1" type:"map"`

	// The thumbnail URL for the branch of an Amplify app.
	ThumbnailUrl *string `locationName:"thumbnailUrl" min:"1" type:"string"`

	// The total number of jobs that are part of an Amplify app.
	//
	// TotalNumberOfJobs is a required field
	TotalNumberOfJobs *string `locationName:"totalNumberOfJobs" type:"string" required:"true"`

	// The content Time to Live (TTL) for the website in seconds.
	//
	// Ttl is a required field
	Ttl *string `locationName:"ttl" type:"string" required:"true"`

	// The last updated date and time for a branch that is part of an Amplify app.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`
}

// String returns the string representation
func (s Branch) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Branch) MarshalFields(e protocol.FieldEncoder) error {
	if s.ActiveJobId != nil {
		v := *s.ActiveJobId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "activeJobId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AssociatedResources != nil {
		v := s.AssociatedResources

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "associatedResources", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.BackendEnvironmentArn != nil {
		v := *s.BackendEnvironmentArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "backendEnvironmentArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BasicAuthCredentials != nil {
		v := *s.BasicAuthCredentials

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "basicAuthCredentials", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BranchArn != nil {
		v := *s.BranchArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "branchArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BranchName != nil {
		v := *s.BranchName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "branchName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BuildSpec != nil {
		v := *s.BuildSpec

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "buildSpec", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreateTime != nil {
		v := *s.CreateTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.CustomDomains != nil {
		v := s.CustomDomains

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "customDomains", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DestinationBranch != nil {
		v := *s.DestinationBranch

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "destinationBranch", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DisplayName != nil {
		v := *s.DisplayName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "displayName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EnableAutoBuild != nil {
		v := *s.EnableAutoBuild

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "enableAutoBuild", protocol.BoolValue(v), metadata)
	}
	if s.EnableBasicAuth != nil {
		v := *s.EnableBasicAuth

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "enableBasicAuth", protocol.BoolValue(v), metadata)
	}
	if s.EnableNotification != nil {
		v := *s.EnableNotification

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "enableNotification", protocol.BoolValue(v), metadata)
	}
	if s.EnablePullRequestPreview != nil {
		v := *s.EnablePullRequestPreview

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "enablePullRequestPreview", protocol.BoolValue(v), metadata)
	}
	if s.EnvironmentVariables != nil {
		v := s.EnvironmentVariables

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "environmentVariables", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Framework != nil {
		v := *s.Framework

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "framework", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PullRequestEnvironmentName != nil {
		v := *s.PullRequestEnvironmentName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "pullRequestEnvironmentName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourceBranch != nil {
		v := *s.SourceBranch

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sourceBranch", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Stage) > 0 {
		v := s.Stage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stage", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.ThumbnailUrl != nil {
		v := *s.ThumbnailUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "thumbnailUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TotalNumberOfJobs != nil {
		v := *s.TotalNumberOfJobs

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "totalNumberOfJobs", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Ttl != nil {
		v := *s.Ttl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ttl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UpdateTime != nil {
		v := *s.UpdateTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "updateTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	return nil
}

// Describes a custom rewrite or redirect rule.
type CustomRule struct {
	_ struct{} `type:"structure"`

	// The condition for a URL rewrite or redirect rule, such as a country code.
	Condition *string `locationName:"condition" min:"1" type:"string"`

	// The source pattern for a URL rewrite or redirect rule.
	//
	// Source is a required field
	Source *string `locationName:"source" min:"1" type:"string" required:"true"`

	// The status code for a URL rewrite or redirect rule.
	Status *string `locationName:"status" min:"3" type:"string"`

	// The target pattern for a URL rewrite or redirect rule.
	//
	// Target is a required field
	Target *string `locationName:"target" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CustomRule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomRule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CustomRule"}
	if s.Condition != nil && len(*s.Condition) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Condition", 1))
	}

	if s.Source == nil {
		invalidParams.Add(aws.NewErrParamRequired("Source"))
	}
	if s.Source != nil && len(*s.Source) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Source", 1))
	}
	if s.Status != nil && len(*s.Status) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("Status", 3))
	}

	if s.Target == nil {
		invalidParams.Add(aws.NewErrParamRequired("Target"))
	}
	if s.Target != nil && len(*s.Target) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Target", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CustomRule) MarshalFields(e protocol.FieldEncoder) error {
	if s.Condition != nil {
		v := *s.Condition

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "condition", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Source != nil {
		v := *s.Source

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "source", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Status != nil {
		v := *s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Target != nil {
		v := *s.Target

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "target", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes a domain association that associates a custom domain with an Amplify
// app.
type DomainAssociation struct {
	_ struct{} `type:"structure"`

	// Sets branch patterns for automatic subdomain creation.
	AutoSubDomainCreationPatterns []string `locationName:"autoSubDomainCreationPatterns" type:"list"`

	// The required AWS Identity and Access Management (IAM) service role for the
	// Amazon Resource Name (ARN) for automatically creating subdomains.
	AutoSubDomainIAMRole *string `locationName:"autoSubDomainIAMRole" type:"string"`

	// The DNS record for certificate verification.
	CertificateVerificationDNSRecord *string `locationName:"certificateVerificationDNSRecord" type:"string"`

	// The Amazon Resource Name (ARN) for the domain association.
	//
	// DomainAssociationArn is a required field
	DomainAssociationArn *string `locationName:"domainAssociationArn" type:"string" required:"true"`

	// The name of the domain.
	//
	// DomainName is a required field
	DomainName *string `locationName:"domainName" type:"string" required:"true"`

	// The current status of the domain association.
	//
	// DomainStatus is a required field
	DomainStatus DomainStatus `locationName:"domainStatus" type:"string" required:"true" enum:"true"`

	// Enables the automated creation of subdomains for branches.
	//
	// EnableAutoSubDomain is a required field
	EnableAutoSubDomain *bool `locationName:"enableAutoSubDomain" type:"boolean" required:"true"`

	// The reason for the current status of the domain association.
	//
	// StatusReason is a required field
	StatusReason *string `locationName:"statusReason" type:"string" required:"true"`

	// The subdomains for the domain association.
	//
	// SubDomains is a required field
	SubDomains []SubDomain `locationName:"subDomains" type:"list" required:"true"`
}

// String returns the string representation
func (s DomainAssociation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DomainAssociation) MarshalFields(e protocol.FieldEncoder) error {
	if s.AutoSubDomainCreationPatterns != nil {
		v := s.AutoSubDomainCreationPatterns

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "autoSubDomainCreationPatterns", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.AutoSubDomainIAMRole != nil {
		v := *s.AutoSubDomainIAMRole

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "autoSubDomainIAMRole", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CertificateVerificationDNSRecord != nil {
		v := *s.CertificateVerificationDNSRecord

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "certificateVerificationDNSRecord", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainAssociationArn != nil {
		v := *s.DomainAssociationArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "domainAssociationArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainName != nil {
		v := *s.DomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "domainName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.DomainStatus) > 0 {
		v := s.DomainStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "domainStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.EnableAutoSubDomain != nil {
		v := *s.EnableAutoSubDomain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "enableAutoSubDomain", protocol.BoolValue(v), metadata)
	}
	if s.StatusReason != nil {
		v := *s.StatusReason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "statusReason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SubDomains != nil {
		v := s.SubDomains

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "subDomains", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Describes an execution job for an Amplify app.
type Job struct {
	_ struct{} `type:"structure"`

	// The execution steps for an execution job, for an Amplify app.
	//
	// Steps is a required field
	Steps []Step `locationName:"steps" type:"list" required:"true"`

	// Describes the summary for an execution job for an Amplify app.
	//
	// Summary is a required field
	Summary *JobSummary `locationName:"summary" type:"structure" required:"true"`
}

// String returns the string representation
func (s Job) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Job) MarshalFields(e protocol.FieldEncoder) error {
	if s.Steps != nil {
		v := s.Steps

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "steps", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Summary != nil {
		v := s.Summary

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "summary", v, metadata)
	}
	return nil
}

// Describes the summary for an execution job for an Amplify app.
type JobSummary struct {
	_ struct{} `type:"structure"`

	// The commit ID from a third-party repository provider for the job.
	//
	// CommitId is a required field
	CommitId *string `locationName:"commitId" type:"string" required:"true"`

	// The commit message from a third-party repository provider for the job.
	//
	// CommitMessage is a required field
	CommitMessage *string `locationName:"commitMessage" type:"string" required:"true"`

	// The commit date and time for the job.
	//
	// CommitTime is a required field
	CommitTime *time.Time `locationName:"commitTime" type:"timestamp" required:"true"`

	// The end date and time for the job.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// The Amazon Resource Name (ARN) for the job.
	//
	// JobArn is a required field
	JobArn *string `locationName:"jobArn" type:"string" required:"true"`

	// The unique ID for the job.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	// The type for the job. If the value is RELEASE, the job was manually released
	// from its source by using the StartJob API. If the value is RETRY, the job
	// was manually retried using the StartJob API. If the value is WEB_HOOK, the
	// job was automatically triggered by webhooks.
	//
	// JobType is a required field
	JobType JobType `locationName:"jobType" type:"string" required:"true" enum:"true"`

	// The start date and time for the job.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`

	// The current status for the job.
	//
	// Status is a required field
	Status JobStatus `locationName:"status" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s JobSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JobSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.CommitId != nil {
		v := *s.CommitId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "commitId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CommitMessage != nil {
		v := *s.CommitMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "commitMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CommitTime != nil {
		v := *s.CommitTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "commitTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.EndTime != nil {
		v := *s.EndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "endTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.JobArn != nil {
		v := *s.JobArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.JobId != nil {
		v := *s.JobId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.JobType) > 0 {
		v := s.JobType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "jobType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "startTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Describes the information about a production branch for an Amplify app.
type ProductionBranch struct {
	_ struct{} `type:"structure"`

	// The branch name for the production branch.
	BranchName *string `locationName:"branchName" min:"1" type:"string"`

	// The last deploy time of the production branch.
	LastDeployTime *time.Time `locationName:"lastDeployTime" type:"timestamp"`

	// The status of the production branch.
	Status *string `locationName:"status" min:"3" type:"string"`

	// The thumbnail URL for the production branch.
	ThumbnailUrl *string `locationName:"thumbnailUrl" min:"1" type:"string"`
}

// String returns the string representation
func (s ProductionBranch) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ProductionBranch) MarshalFields(e protocol.FieldEncoder) error {
	if s.BranchName != nil {
		v := *s.BranchName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "branchName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastDeployTime != nil {
		v := *s.LastDeployTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastDeployTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Status != nil {
		v := *s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThumbnailUrl != nil {
		v := *s.ThumbnailUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "thumbnailUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes an execution step, for an execution job, for an Amplify app.
type Step struct {
	_ struct{} `type:"structure"`

	// The URL to the artifact for the execution step.
	ArtifactsUrl *string `locationName:"artifactsUrl" type:"string"`

	// The context for the current step. Includes a build image if the step is build.
	Context *string `locationName:"context" type:"string"`

	// The end date and time of the execution step.
	//
	// EndTime is a required field
	EndTime *time.Time `locationName:"endTime" type:"timestamp" required:"true"`

	// The URL to the logs for the execution step.
	LogUrl *string `locationName:"logUrl" type:"string"`

	// The list of screenshot URLs for the execution step, if relevant.
	Screenshots map[string]string `locationName:"screenshots" type:"map"`

	// The start date and time of the execution step.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`

	// The status of the execution step.
	//
	// Status is a required field
	Status JobStatus `locationName:"status" type:"string" required:"true" enum:"true"`

	// The reason for the current step status.
	StatusReason *string `locationName:"statusReason" type:"string"`

	// The name of the execution step.
	//
	// StepName is a required field
	StepName *string `locationName:"stepName" type:"string" required:"true"`

	// The URL to the test artifact for the execution step.
	TestArtifactsUrl *string `locationName:"testArtifactsUrl" type:"string"`

	// The URL to the test configuration for the execution step.
	TestConfigUrl *string `locationName:"testConfigUrl" type:"string"`
}

// String returns the string representation
func (s Step) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Step) MarshalFields(e protocol.FieldEncoder) error {
	if s.ArtifactsUrl != nil {
		v := *s.ArtifactsUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "artifactsUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Context != nil {
		v := *s.Context

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "context", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EndTime != nil {
		v := *s.EndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "endTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.LogUrl != nil {
		v := *s.LogUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "logUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Screenshots != nil {
		v := s.Screenshots

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "screenshots", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "startTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.StatusReason != nil {
		v := *s.StatusReason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "statusReason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StepName != nil {
		v := *s.StepName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stepName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TestArtifactsUrl != nil {
		v := *s.TestArtifactsUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "testArtifactsUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TestConfigUrl != nil {
		v := *s.TestConfigUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "testConfigUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The subdomain for the domain association.
type SubDomain struct {
	_ struct{} `type:"structure"`

	// The DNS record for the subdomain.
	//
	// DnsRecord is a required field
	DnsRecord *string `locationName:"dnsRecord" type:"string" required:"true"`

	// Describes the settings for the subdomain.
	//
	// SubDomainSetting is a required field
	SubDomainSetting *SubDomainSetting `locationName:"subDomainSetting" type:"structure" required:"true"`

	// The verified status of the subdomain
	//
	// Verified is a required field
	Verified *bool `locationName:"verified" type:"boolean" required:"true"`
}

// String returns the string representation
func (s SubDomain) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SubDomain) MarshalFields(e protocol.FieldEncoder) error {
	if s.DnsRecord != nil {
		v := *s.DnsRecord

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dnsRecord", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SubDomainSetting != nil {
		v := s.SubDomainSetting

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "subDomainSetting", v, metadata)
	}
	if s.Verified != nil {
		v := *s.Verified

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "verified", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Describes the settings for the subdomain.
type SubDomainSetting struct {
	_ struct{} `type:"structure"`

	// The branch name setting for the subdomain.
	//
	// BranchName is a required field
	BranchName *string `locationName:"branchName" min:"1" type:"string" required:"true"`

	// The prefix setting for the subdomain.
	//
	// Prefix is a required field
	Prefix *string `locationName:"prefix" type:"string" required:"true"`
}

// String returns the string representation
func (s SubDomainSetting) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SubDomainSetting) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SubDomainSetting"}

	if s.BranchName == nil {
		invalidParams.Add(aws.NewErrParamRequired("BranchName"))
	}
	if s.BranchName != nil && len(*s.BranchName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("BranchName", 1))
	}

	if s.Prefix == nil {
		invalidParams.Add(aws.NewErrParamRequired("Prefix"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SubDomainSetting) MarshalFields(e protocol.FieldEncoder) error {
	if s.BranchName != nil {
		v := *s.BranchName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "branchName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Prefix != nil {
		v := *s.Prefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "prefix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Describes a webhook that connects repository events to an Amplify app.
type Webhook struct {
	_ struct{} `type:"structure"`

	// The name for a branch that is part of an Amplify app.
	//
	// BranchName is a required field
	BranchName *string `locationName:"branchName" min:"1" type:"string" required:"true"`

	// The create date and time for a webhook.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" required:"true"`

	// The description for a webhook.
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// Updates the date and time for a webhook.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" required:"true"`

	// The Amazon Resource Name (ARN) for the webhook.
	//
	// WebhookArn is a required field
	WebhookArn *string `locationName:"webhookArn" type:"string" required:"true"`

	// The ID of the webhook.
	//
	// WebhookId is a required field
	WebhookId *string `locationName:"webhookId" type:"string" required:"true"`

	// The URL of the webhook.
	//
	// WebhookUrl is a required field
	WebhookUrl *string `locationName:"webhookUrl" type:"string" required:"true"`
}

// String returns the string representation
func (s Webhook) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Webhook) MarshalFields(e protocol.FieldEncoder) error {
	if s.BranchName != nil {
		v := *s.BranchName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "branchName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreateTime != nil {
		v := *s.CreateTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UpdateTime != nil {
		v := *s.UpdateTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "updateTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.WebhookArn != nil {
		v := *s.WebhookArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "webhookArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.WebhookId != nil {
		v := *s.WebhookId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "webhookId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.WebhookUrl != nil {
		v := *s.WebhookUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "webhookUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
