// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Creates a RequestValidator of a given RestApi.
type CreateRequestValidatorInput struct {
	_ struct{} `type:"structure"`

	// The name of the to-be-created RequestValidator.
	Name *string `locationName:"name" type:"string"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// A Boolean flag to indicate whether to validate request body according to
	// the configured model schema for the method (true) or not (false).
	ValidateRequestBody *bool `locationName:"validateRequestBody" type:"boolean"`

	// A Boolean flag to indicate whether to validate request parameters, true,
	// or not false.
	ValidateRequestParameters *bool `locationName:"validateRequestParameters" type:"boolean"`
}

// String returns the string representation
func (s CreateRequestValidatorInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRequestValidatorInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateRequestValidatorInput"}

	if s.RestApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RestApiId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateRequestValidatorInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ValidateRequestBody != nil {
		v := *s.ValidateRequestBody

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "validateRequestBody", protocol.BoolValue(v), metadata)
	}
	if s.ValidateRequestParameters != nil {
		v := *s.ValidateRequestParameters

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "validateRequestParameters", protocol.BoolValue(v), metadata)
	}
	if s.RestApiId != nil {
		v := *s.RestApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "restapi_id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A set of validation rules for incoming Method requests.
//
// In OpenAPI, a RequestValidator of an API is defined by the x-amazon-apigateway-request-validators.requestValidator
// (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions.html#api-gateway-swagger-extensions-request-validators.requestValidator.html)
// object. It the referenced using the x-amazon-apigateway-request-validator
// (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions.html#api-gateway-swagger-extensions-request-validator)
// property.
//
// Enable Basic Request Validation in API Gateway (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-method-request-validation.html)
type CreateRequestValidatorOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of this RequestValidator.
	Id *string `locationName:"id" type:"string"`

	// The name of this RequestValidator
	Name *string `locationName:"name" type:"string"`

	// A Boolean flag to indicate whether to validate a request body according to
	// the configured Model schema.
	ValidateRequestBody *bool `locationName:"validateRequestBody" type:"boolean"`

	// A Boolean flag to indicate whether to validate request parameters (true)
	// or not (false).
	ValidateRequestParameters *bool `locationName:"validateRequestParameters" type:"boolean"`
}

// String returns the string representation
func (s CreateRequestValidatorOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateRequestValidatorOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ValidateRequestBody != nil {
		v := *s.ValidateRequestBody

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "validateRequestBody", protocol.BoolValue(v), metadata)
	}
	if s.ValidateRequestParameters != nil {
		v := *s.ValidateRequestParameters

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "validateRequestParameters", protocol.BoolValue(v), metadata)
	}
	return nil
}

const opCreateRequestValidator = "CreateRequestValidator"

// CreateRequestValidatorRequest returns a request value for making API operation for
// Amazon API Gateway.
//
// Creates a ReqeustValidator of a given RestApi.
//
//    // Example sending a request using CreateRequestValidatorRequest.
//    req := client.CreateRequestValidatorRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) CreateRequestValidatorRequest(input *CreateRequestValidatorInput) CreateRequestValidatorRequest {
	op := &aws.Operation{
		Name:       opCreateRequestValidator,
		HTTPMethod: "POST",
		HTTPPath:   "/restapis/{restapi_id}/requestvalidators",
	}

	if input == nil {
		input = &CreateRequestValidatorInput{}
	}

	req := c.newRequest(op, input, &CreateRequestValidatorOutput{})

	return CreateRequestValidatorRequest{Request: req, Input: input, Copy: c.CreateRequestValidatorRequest}
}

// CreateRequestValidatorRequest is the request type for the
// CreateRequestValidator API operation.
type CreateRequestValidatorRequest struct {
	*aws.Request
	Input *CreateRequestValidatorInput
	Copy  func(*CreateRequestValidatorInput) CreateRequestValidatorRequest
}

// Send marshals and sends the CreateRequestValidator API request.
func (r CreateRequestValidatorRequest) Send(ctx context.Context) (*CreateRequestValidatorResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateRequestValidatorResponse{
		CreateRequestValidatorOutput: r.Request.Data.(*CreateRequestValidatorOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateRequestValidatorResponse is the response type for the
// CreateRequestValidator API operation.
type CreateRequestValidatorResponse struct {
	*CreateRequestValidatorOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateRequestValidator request.
func (r *CreateRequestValidatorResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
