// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

// Deletes a specified RequestValidator of a given RestApi.
type DeleteRequestValidatorInput struct {
	_ struct{} `type:"structure"`

	// [Required] The identifier of the RequestValidator to be deleted.
	//
	// RequestValidatorId is a required field
	RequestValidatorId *string `location:"uri" locationName:"requestvalidator_id" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRequestValidatorInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRequestValidatorInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteRequestValidatorInput"}

	if s.RequestValidatorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RequestValidatorId"))
	}

	if s.RestApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RestApiId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteRequestValidatorInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.RequestValidatorId != nil {
		v := *s.RequestValidatorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "requestvalidator_id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RestApiId != nil {
		v := *s.RestApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "restapi_id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteRequestValidatorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRequestValidatorOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteRequestValidatorOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteRequestValidator = "DeleteRequestValidator"

// DeleteRequestValidatorRequest returns a request value for making API operation for
// Amazon API Gateway.
//
// Deletes a RequestValidator of a given RestApi.
//
//    // Example sending a request using DeleteRequestValidatorRequest.
//    req := client.DeleteRequestValidatorRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DeleteRequestValidatorRequest(input *DeleteRequestValidatorInput) DeleteRequestValidatorRequest {
	op := &aws.Operation{
		Name:       opDeleteRequestValidator,
		HTTPMethod: "DELETE",
		HTTPPath:   "/restapis/{restapi_id}/requestvalidators/{requestvalidator_id}",
	}

	if input == nil {
		input = &DeleteRequestValidatorInput{}
	}

	req := c.newRequest(op, input, &DeleteRequestValidatorOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteRequestValidatorRequest{Request: req, Input: input, Copy: c.DeleteRequestValidatorRequest}
}

// DeleteRequestValidatorRequest is the request type for the
// DeleteRequestValidator API operation.
type DeleteRequestValidatorRequest struct {
	*aws.Request
	Input *DeleteRequestValidatorInput
	Copy  func(*DeleteRequestValidatorInput) DeleteRequestValidatorRequest
}

// Send marshals and sends the DeleteRequestValidator API request.
func (r DeleteRequestValidatorRequest) Send(ctx context.Context) (*DeleteRequestValidatorResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteRequestValidatorResponse{
		DeleteRequestValidatorOutput: r.Request.Data.(*DeleteRequestValidatorOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteRequestValidatorResponse is the response type for the
// DeleteRequestValidator API operation.
type DeleteRequestValidatorResponse struct {
	*DeleteRequestValidatorOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteRequestValidator request.
func (r *DeleteRequestValidatorResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
