// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

// Deletes an existing VpcLink of a specified identifier.
type DeleteVpcLinkInput struct {
	_ struct{} `type:"structure"`

	// [Required] The identifier of the VpcLink. It is used in an Integration to
	// reference this VpcLink.
	//
	// VpcLinkId is a required field
	VpcLinkId *string `location:"uri" locationName:"vpclink_id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVpcLinkInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVpcLinkInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteVpcLinkInput"}

	if s.VpcLinkId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VpcLinkId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteVpcLinkInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.VpcLinkId != nil {
		v := *s.VpcLinkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "vpclink_id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteVpcLinkOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVpcLinkOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteVpcLinkOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteVpcLink = "DeleteVpcLink"

// DeleteVpcLinkRequest returns a request value for making API operation for
// Amazon API Gateway.
//
// Deletes an existing VpcLink of a specified identifier.
//
//    // Example sending a request using DeleteVpcLinkRequest.
//    req := client.DeleteVpcLinkRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DeleteVpcLinkRequest(input *DeleteVpcLinkInput) DeleteVpcLinkRequest {
	op := &aws.Operation{
		Name:       opDeleteVpcLink,
		HTTPMethod: "DELETE",
		HTTPPath:   "/vpclinks/{vpclink_id}",
	}

	if input == nil {
		input = &DeleteVpcLinkInput{}
	}

	req := c.newRequest(op, input, &DeleteVpcLinkOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteVpcLinkRequest{Request: req, Input: input, Copy: c.DeleteVpcLinkRequest}
}

// DeleteVpcLinkRequest is the request type for the
// DeleteVpcLink API operation.
type DeleteVpcLinkRequest struct {
	*aws.Request
	Input *DeleteVpcLinkInput
	Copy  func(*DeleteVpcLinkInput) DeleteVpcLinkRequest
}

// Send marshals and sends the DeleteVpcLink API request.
func (r DeleteVpcLinkRequest) Send(ctx context.Context) (*DeleteVpcLinkResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteVpcLinkResponse{
		DeleteVpcLinkOutput: r.Request.Data.(*DeleteVpcLinkOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteVpcLinkResponse is the response type for the
// DeleteVpcLink API operation.
type DeleteVpcLinkResponse struct {
	*DeleteVpcLinkOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteVpcLink request.
func (r *DeleteVpcLinkResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
