// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigatewayv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type DeleteRouteRequestParameterInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// RequestParameterKey is a required field
	RequestParameterKey *string `location:"uri" locationName:"requestParameterKey" type:"string" required:"true"`

	// RouteId is a required field
	RouteId *string `location:"uri" locationName:"routeId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRouteRequestParameterInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRouteRequestParameterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteRouteRequestParameterInput"}

	if s.ApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApiId"))
	}

	if s.RequestParameterKey == nil {
		invalidParams.Add(aws.NewErrParamRequired("RequestParameterKey"))
	}

	if s.RouteId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RouteId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteRouteRequestParameterInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestParameterKey != nil {
		v := *s.RequestParameterKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "requestParameterKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RouteId != nil {
		v := *s.RouteId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "routeId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteRouteRequestParameterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRouteRequestParameterOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteRouteRequestParameterOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteRouteRequestParameter = "DeleteRouteRequestParameter"

// DeleteRouteRequestParameterRequest returns a request value for making API operation for
// AmazonApiGatewayV2.
//
// Deletes a route request parameter.
//
//    // Example sending a request using DeleteRouteRequestParameterRequest.
//    req := client.DeleteRouteRequestParameterRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteRouteRequestParameter
func (c *Client) DeleteRouteRequestParameterRequest(input *DeleteRouteRequestParameterInput) DeleteRouteRequestParameterRequest {
	op := &aws.Operation{
		Name:       opDeleteRouteRequestParameter,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/apis/{apiId}/routes/{routeId}/requestparameters/{requestParameterKey}",
	}

	if input == nil {
		input = &DeleteRouteRequestParameterInput{}
	}

	req := c.newRequest(op, input, &DeleteRouteRequestParameterOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteRouteRequestParameterRequest{Request: req, Input: input, Copy: c.DeleteRouteRequestParameterRequest}
}

// DeleteRouteRequestParameterRequest is the request type for the
// DeleteRouteRequestParameter API operation.
type DeleteRouteRequestParameterRequest struct {
	*aws.Request
	Input *DeleteRouteRequestParameterInput
	Copy  func(*DeleteRouteRequestParameterInput) DeleteRouteRequestParameterRequest
}

// Send marshals and sends the DeleteRouteRequestParameter API request.
func (r DeleteRouteRequestParameterRequest) Send(ctx context.Context) (*DeleteRouteRequestParameterResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteRouteRequestParameterResponse{
		DeleteRouteRequestParameterOutput: r.Request.Data.(*DeleteRouteRequestParameterOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteRouteRequestParameterResponse is the response type for the
// DeleteRouteRequestParameter API operation.
type DeleteRouteRequestParameterResponse struct {
	*DeleteRouteRequestParameterOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteRouteRequestParameter request.
func (r *DeleteRouteRequestParameterResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
