// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigatewayv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ExportApiInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	ExportVersion *string `location:"querystring" locationName:"exportVersion" type:"string"`

	IncludeExtensions *bool `location:"querystring" locationName:"includeExtensions" type:"boolean"`

	// OutputType is a required field
	OutputType *string `location:"querystring" locationName:"outputType" type:"string" required:"true"`

	// Specification is a required field
	Specification *string `location:"uri" locationName:"specification" type:"string" required:"true"`

	StageName *string `location:"querystring" locationName:"stageName" type:"string"`
}

// String returns the string representation
func (s ExportApiInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportApiInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ExportApiInput"}

	if s.ApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApiId"))
	}

	if s.OutputType == nil {
		invalidParams.Add(aws.NewErrParamRequired("OutputType"))
	}

	if s.Specification == nil {
		invalidParams.Add(aws.NewErrParamRequired("Specification"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ExportApiInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Specification != nil {
		v := *s.Specification

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "specification", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ExportVersion != nil {
		v := *s.ExportVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "exportVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IncludeExtensions != nil {
		v := *s.IncludeExtensions

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "includeExtensions", protocol.BoolValue(v), metadata)
	}
	if s.OutputType != nil {
		v := *s.OutputType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "outputType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StageName != nil {
		v := *s.StageName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "stageName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ExportApiOutput struct {
	_ struct{} `type:"structure" payload:"Body"`

	// Represents an exported definition of an API in a particular output format,
	// for example, YAML. The API is serialized to the requested specification,
	// for example, OpenAPI 3.0.
	Body []byte `locationName:"body" type:"blob"`
}

// String returns the string representation
func (s ExportApiOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ExportApiOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Body != nil {
		v := s.Body

		metadata := protocol.Metadata{}
		e.SetStream(protocol.PayloadTarget, "body", protocol.BytesStream(v), metadata)
	}
	return nil
}

const opExportApi = "ExportApi"

// ExportApiRequest returns a request value for making API operation for
// AmazonApiGatewayV2.
//
// Exports a definition of an API in a particular output format and specification.
//
//    // Example sending a request using ExportApiRequest.
//    req := client.ExportApiRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/ExportApi
func (c *Client) ExportApiRequest(input *ExportApiInput) ExportApiRequest {
	op := &aws.Operation{
		Name:       opExportApi,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/apis/{apiId}/exports/{specification}",
	}

	if input == nil {
		input = &ExportApiInput{}
	}

	req := c.newRequest(op, input, &ExportApiOutput{})

	return ExportApiRequest{Request: req, Input: input, Copy: c.ExportApiRequest}
}

// ExportApiRequest is the request type for the
// ExportApi API operation.
type ExportApiRequest struct {
	*aws.Request
	Input *ExportApiInput
	Copy  func(*ExportApiInput) ExportApiRequest
}

// Send marshals and sends the ExportApi API request.
func (r ExportApiRequest) Send(ctx context.Context) (*ExportApiResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ExportApiResponse{
		ExportApiOutput: r.Request.Data.(*ExportApiOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ExportApiResponse is the response type for the
// ExportApi API operation.
type ExportApiResponse struct {
	*ExportApiOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ExportApi request.
func (r *ExportApiResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
