// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigatewayv2

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ReimportApiInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	Basepath *string `location:"querystring" locationName:"basepath" type:"string"`

	// Body is a required field
	Body *string `locationName:"body" type:"string" required:"true"`

	FailOnWarnings *bool `location:"querystring" locationName:"failOnWarnings" type:"boolean"`
}

// String returns the string representation
func (s ReimportApiInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReimportApiInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ReimportApiInput"}

	if s.ApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApiId"))
	}

	if s.Body == nil {
		invalidParams.Add(aws.NewErrParamRequired("Body"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ReimportApiInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Body != nil {
		v := *s.Body

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "body", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Basepath != nil {
		v := *s.Basepath

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "basepath", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FailOnWarnings != nil {
		v := *s.FailOnWarnings

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "failOnWarnings", protocol.BoolValue(v), metadata)
	}
	return nil
}

type ReimportApiOutput struct {
	_ struct{} `type:"structure"`

	ApiEndpoint *string `locationName:"apiEndpoint" type:"string"`

	// The identifier.
	ApiId *string `locationName:"apiId" type:"string"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	ApiKeySelectionExpression *string `locationName:"apiKeySelectionExpression" type:"string"`

	// Represents a CORS configuration. Supported only for HTTP APIs. See Configuring
	// CORS (https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html)
	// for more information.
	CorsConfiguration *Cors `locationName:"corsConfiguration" type:"structure"`

	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601"`

	// A string with a length between [0-1024].
	Description *string `locationName:"description" type:"string"`

	DisableSchemaValidation *bool `locationName:"disableSchemaValidation" type:"boolean"`

	ImportInfo []string `locationName:"importInfo" type:"list"`

	// A string with a length between [1-128].
	Name *string `locationName:"name" type:"string"`

	// Represents a protocol type.
	ProtocolType ProtocolType `locationName:"protocolType" type:"string" enum:"true"`

	// An expression used to extract information at runtime. See Selection Expressions
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions)
	// for more information.
	RouteSelectionExpression *string `locationName:"routeSelectionExpression" type:"string"`

	// Represents a collection of tags associated with the resource.
	Tags map[string]string `locationName:"tags" type:"map"`

	// A string with a length between [1-64].
	Version *string `locationName:"version" type:"string"`

	Warnings []string `locationName:"warnings" type:"list"`
}

// String returns the string representation
func (s ReimportApiOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ReimportApiOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApiEndpoint != nil {
		v := *s.ApiEndpoint

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiEndpoint", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ApiKeySelectionExpression != nil {
		v := *s.ApiKeySelectionExpression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiKeySelectionExpression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CorsConfiguration != nil {
		v := s.CorsConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "corsConfiguration", v, metadata)
	}
	if s.CreatedDate != nil {
		v := *s.CreatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdDate",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DisableSchemaValidation != nil {
		v := *s.DisableSchemaValidation

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "disableSchemaValidation", protocol.BoolValue(v), metadata)
	}
	if s.ImportInfo != nil {
		v := s.ImportInfo

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "importInfo", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ProtocolType) > 0 {
		v := s.ProtocolType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "protocolType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RouteSelectionExpression != nil {
		v := *s.RouteSelectionExpression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "routeSelectionExpression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Warnings != nil {
		v := s.Warnings

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "warnings", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

const opReimportApi = "ReimportApi"

// ReimportApiRequest returns a request value for making API operation for
// AmazonApiGatewayV2.
//
// Puts an Api resource.
//
//    // Example sending a request using ReimportApiRequest.
//    req := client.ReimportApiRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/ReimportApi
func (c *Client) ReimportApiRequest(input *ReimportApiInput) ReimportApiRequest {
	op := &aws.Operation{
		Name:       opReimportApi,
		HTTPMethod: "PUT",
		HTTPPath:   "/v2/apis/{apiId}",
	}

	if input == nil {
		input = &ReimportApiInput{}
	}

	req := c.newRequest(op, input, &ReimportApiOutput{})

	return ReimportApiRequest{Request: req, Input: input, Copy: c.ReimportApiRequest}
}

// ReimportApiRequest is the request type for the
// ReimportApi API operation.
type ReimportApiRequest struct {
	*aws.Request
	Input *ReimportApiInput
	Copy  func(*ReimportApiInput) ReimportApiRequest
}

// Send marshals and sends the ReimportApi API request.
func (r ReimportApiRequest) Send(ctx context.Context) (*ReimportApiResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ReimportApiResponse{
		ReimportApiOutput: r.Request.Data.(*ReimportApiOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ReimportApiResponse is the response type for the
// ReimportApi API operation.
type ReimportApiResponse struct {
	*ReimportApiOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ReimportApi request.
func (r *ReimportApiResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
