// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigatewayv2

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Settings for logging access in a stage.
type AccessLogSettings struct {
	_ struct{} `type:"structure"`

	// The ARN of the CloudWatch Logs log group to receive access logs.
	DestinationArn *string `locationName:"destinationArn" type:"string"`

	// A single line format of the access logs of data, as specified by selected
	// $context variables. The format must include at least $context.requestId.
	Format *string `locationName:"format" type:"string"`
}

// String returns the string representation
func (s AccessLogSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccessLogSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.DestinationArn != nil {
		v := *s.DestinationArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "destinationArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Format != nil {
		v := *s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "format", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents an API.
type Api struct {
	_ struct{} `type:"structure"`

	// The URI of the API, of the form {api-id}.execute-api.{region}.amazonaws.com.
	// The stage name is typically appended to this URI to form a complete path
	// to a deployed API stage.
	ApiEndpoint *string `locationName:"apiEndpoint" type:"string"`

	// The API ID.
	ApiId *string `locationName:"apiId" type:"string"`

	// An API key selection expression. Supported only for WebSocket APIs. See API
	// Key Selection Expressions (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions).
	ApiKeySelectionExpression *string `locationName:"apiKeySelectionExpression" type:"string"`

	// A CORS configuration. Supported only for HTTP APIs.
	CorsConfiguration *Cors `locationName:"corsConfiguration" type:"structure"`

	// The timestamp when the API was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601"`

	// The description of the API.
	Description *string `locationName:"description" type:"string"`

	// Avoid validating models when creating a deployment. Supported only for WebSocket
	// APIs.
	DisableSchemaValidation *bool `locationName:"disableSchemaValidation" type:"boolean"`

	// The validation information during API import. This may include particular
	// properties of your OpenAPI definition which are ignored during import. Supported
	// only for HTTP APIs.
	ImportInfo []string `locationName:"importInfo" type:"list"`

	// The name of the API.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The API protocol.
	//
	// ProtocolType is a required field
	ProtocolType ProtocolType `locationName:"protocolType" type:"string" required:"true" enum:"true"`

	// The route selection expression for the API. For HTTP APIs, the routeSelectionExpression
	// must be ${request.method} ${request.path}. If not provided, this will be
	// the default for HTTP APIs. This property is required for WebSocket APIs.
	//
	// RouteSelectionExpression is a required field
	RouteSelectionExpression *string `locationName:"routeSelectionExpression" type:"string" required:"true"`

	// A collection of tags associated with the API.
	Tags map[string]string `locationName:"tags" type:"map"`

	// A version identifier for the API.
	Version *string `locationName:"version" type:"string"`

	// The warning messages reported when failonwarnings is turned on during API
	// import.
	Warnings []string `locationName:"warnings" type:"list"`
}

// String returns the string representation
func (s Api) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Api) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApiEndpoint != nil {
		v := *s.ApiEndpoint

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiEndpoint", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ApiKeySelectionExpression != nil {
		v := *s.ApiKeySelectionExpression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiKeySelectionExpression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CorsConfiguration != nil {
		v := s.CorsConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "corsConfiguration", v, metadata)
	}
	if s.CreatedDate != nil {
		v := *s.CreatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdDate",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DisableSchemaValidation != nil {
		v := *s.DisableSchemaValidation

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "disableSchemaValidation", protocol.BoolValue(v), metadata)
	}
	if s.ImportInfo != nil {
		v := s.ImportInfo

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "importInfo", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ProtocolType) > 0 {
		v := s.ProtocolType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "protocolType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RouteSelectionExpression != nil {
		v := *s.RouteSelectionExpression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "routeSelectionExpression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Warnings != nil {
		v := s.Warnings

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "warnings", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Represents an API mapping.
type ApiMapping struct {
	_ struct{} `type:"structure"`

	// The API identifier.
	//
	// ApiId is a required field
	ApiId *string `locationName:"apiId" type:"string" required:"true"`

	// The API mapping identifier.
	ApiMappingId *string `locationName:"apiMappingId" type:"string"`

	// The API mapping key.
	ApiMappingKey *string `locationName:"apiMappingKey" type:"string"`

	// The API stage.
	//
	// Stage is a required field
	Stage *string `locationName:"stage" type:"string" required:"true"`
}

// String returns the string representation
func (s ApiMapping) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ApiMapping) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ApiMappingId != nil {
		v := *s.ApiMappingId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiMappingId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ApiMappingKey != nil {
		v := *s.ApiMappingKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiMappingKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Stage != nil {
		v := *s.Stage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents an authorizer.
type Authorizer struct {
	_ struct{} `type:"structure"`

	// Specifies the required credentials as an IAM role for API Gateway to invoke
	// the authorizer. To specify an IAM role for API Gateway to assume, use the
	// role's Amazon Resource Name (ARN). To use resource-based permissions on the
	// Lambda function, specify null. Supported only for REQUEST authorizers.
	AuthorizerCredentialsArn *string `locationName:"authorizerCredentialsArn" type:"string"`

	// The authorizer identifier.
	AuthorizerId *string `locationName:"authorizerId" type:"string"`

	// Authorizer caching is not currently supported. Don't specify this value for
	// authorizers.
	AuthorizerResultTtlInSeconds *int64 `locationName:"authorizerResultTtlInSeconds" type:"integer"`

	// The authorizer type. For WebSocket APIs, specify REQUEST for a Lambda function
	// using incoming request parameters. For HTTP APIs, specify JWT to use JSON
	// Web Tokens.
	AuthorizerType AuthorizerType `locationName:"authorizerType" type:"string" enum:"true"`

	// The authorizer's Uniform Resource Identifier (URI). ForREQUEST authorizers,
	// this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations.
	// In general, the URI has this form: arn:aws:apigateway:{region}:lambda:path/{service_api}
	// , where {region} is the same as the region hosting the Lambda function, path
	// indicates that the remaining substring in the URI should be treated as the
	// path to the resource, including the initial /. For Lambda functions, this
	// is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported
	// only for REQUEST authorizers.
	AuthorizerUri *string `locationName:"authorizerUri" type:"string"`

	// The identity source for which authorization is requested.
	//
	// For a REQUEST authorizer, this is optional. The value is a set of one or
	// more mapping expressions of the specified request parameters. Currently,
	// the identity source can be headers, query string parameters, stage variables,
	// and context parameters. For example, if an Auth header and a Name query string
	// parameter are defined as identity sources, this value is route.request.header.Auth,
	// route.request.querystring.Name. These parameters will be used to perform
	// runtime validation for Lambda-based authorizers by verifying all of the identity-related
	// request parameters are present in the request, not null, and non-empty. Only
	// when this is true does the authorizer invoke the authorizer Lambda function.
	// Otherwise, it returns a 401 Unauthorized response without calling the Lambda
	// function.
	//
	// For JWT, a single entry that specifies where to extract the JSON Web Token
	// (JWT) from inbound requests. Currently only header-based and query parameter-based
	// selections are supported, for example "$request.header.Authorization".
	IdentitySource []string `locationName:"identitySource" type:"list"`

	// The validation expression does not apply to the REQUEST authorizer.
	IdentityValidationExpression *string `locationName:"identityValidationExpression" type:"string"`

	// Represents the configuration of a JWT authorizer. Required for the JWT authorizer
	// type. Supported only for HTTP APIs.
	JwtConfiguration *JWTConfiguration `locationName:"jwtConfiguration" type:"structure"`

	// The name of the authorizer.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation
func (s Authorizer) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Authorizer) MarshalFields(e protocol.FieldEncoder) error {
	if s.AuthorizerCredentialsArn != nil {
		v := *s.AuthorizerCredentialsArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authorizerCredentialsArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AuthorizerId != nil {
		v := *s.AuthorizerId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authorizerId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AuthorizerResultTtlInSeconds != nil {
		v := *s.AuthorizerResultTtlInSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authorizerResultTtlInSeconds", protocol.Int64Value(v), metadata)
	}
	if len(s.AuthorizerType) > 0 {
		v := s.AuthorizerType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authorizerType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.AuthorizerUri != nil {
		v := *s.AuthorizerUri

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authorizerUri", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IdentitySource != nil {
		v := s.IdentitySource

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "identitySource", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.IdentityValidationExpression != nil {
		v := *s.IdentityValidationExpression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "identityValidationExpression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.JwtConfiguration != nil {
		v := s.JwtConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "jwtConfiguration", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents a CORS configuration. Supported only for HTTP APIs. See Configuring
// CORS (https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html)
// for more information.
type Cors struct {
	_ struct{} `type:"structure"`

	// Specifies whether credentials are included in the CORS request. Supported
	// only for HTTP APIs.
	AllowCredentials *bool `locationName:"allowCredentials" type:"boolean"`

	// Represents a collection of allowed headers. Supported only for HTTP APIs.
	AllowHeaders []string `locationName:"allowHeaders" type:"list"`

	// Represents a collection of allowed HTTP methods. Supported only for HTTP
	// APIs.
	AllowMethods []string `locationName:"allowMethods" type:"list"`

	// Represents a collection of allowed origins. Supported only for HTTP APIs.
	AllowOrigins []string `locationName:"allowOrigins" type:"list"`

	// Represents a collection of exposed headers. Supported only for HTTP APIs.
	ExposeHeaders []string `locationName:"exposeHeaders" type:"list"`

	// The number of seconds that the browser should cache preflight request results.
	// Supported only for HTTP APIs.
	MaxAge *int64 `locationName:"maxAge" type:"integer"`
}

// String returns the string representation
func (s Cors) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Cors) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Cors"}
	if s.MaxAge != nil && *s.MaxAge < -1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxAge", -1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Cors) MarshalFields(e protocol.FieldEncoder) error {
	if s.AllowCredentials != nil {
		v := *s.AllowCredentials

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "allowCredentials", protocol.BoolValue(v), metadata)
	}
	if s.AllowHeaders != nil {
		v := s.AllowHeaders

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "allowHeaders", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.AllowMethods != nil {
		v := s.AllowMethods

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "allowMethods", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.AllowOrigins != nil {
		v := s.AllowOrigins

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "allowOrigins", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.ExposeHeaders != nil {
		v := s.ExposeHeaders

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "exposeHeaders", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.MaxAge != nil {
		v := *s.MaxAge

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxAge", protocol.Int64Value(v), metadata)
	}
	return nil
}

// An immutable representation of an API that can be called by users. A Deployment
// must be associated with a Stage for it to be callable over the internet.
type Deployment struct {
	_ struct{} `type:"structure"`

	// Specifies whether a deployment was automatically released.
	AutoDeployed *bool `locationName:"autoDeployed" type:"boolean"`

	// The date and time when the Deployment resource was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601"`

	// The identifier for the deployment.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// The status of the deployment: PENDING, FAILED, or SUCCEEDED.
	DeploymentStatus DeploymentStatus `locationName:"deploymentStatus" type:"string" enum:"true"`

	// May contain additional feedback on the status of an API deployment.
	DeploymentStatusMessage *string `locationName:"deploymentStatusMessage" type:"string"`

	// The description for the deployment.
	Description *string `locationName:"description" type:"string"`
}

// String returns the string representation
func (s Deployment) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Deployment) MarshalFields(e protocol.FieldEncoder) error {
	if s.AutoDeployed != nil {
		v := *s.AutoDeployed

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "autoDeployed", protocol.BoolValue(v), metadata)
	}
	if s.CreatedDate != nil {
		v := *s.CreatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdDate",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.DeploymentId != nil {
		v := *s.DeploymentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deploymentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.DeploymentStatus) > 0 {
		v := s.DeploymentStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deploymentStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.DeploymentStatusMessage != nil {
		v := *s.DeploymentStatusMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deploymentStatusMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents a domain name.
type DomainName struct {
	_ struct{} `type:"structure"`

	// The API mapping selection expression.
	ApiMappingSelectionExpression *string `locationName:"apiMappingSelectionExpression" type:"string"`

	// The name of the DomainName resource.
	//
	// DomainName is a required field
	DomainName *string `locationName:"domainName" type:"string" required:"true"`

	// The domain name configurations.
	DomainNameConfigurations []DomainNameConfiguration `locationName:"domainNameConfigurations" type:"list"`

	// The collection of tags associated with a domain name.
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s DomainName) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DomainName) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApiMappingSelectionExpression != nil {
		v := *s.ApiMappingSelectionExpression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiMappingSelectionExpression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainName != nil {
		v := *s.DomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "domainName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainNameConfigurations != nil {
		v := s.DomainNameConfigurations

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "domainNameConfigurations", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// The domain name configuration.
type DomainNameConfiguration struct {
	_ struct{} `type:"structure"`

	// A domain name for the API.
	ApiGatewayDomainName *string `locationName:"apiGatewayDomainName" type:"string"`

	// An AWS-managed certificate that will be used by the edge-optimized endpoint
	// for this domain name. AWS Certificate Manager is the only supported source.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The user-friendly name of the certificate that will be used by the edge-optimized
	// endpoint for this domain name.
	CertificateName *string `locationName:"certificateName" type:"string"`

	// The timestamp when the certificate that was used by edge-optimized endpoint
	// for this domain name was uploaded.
	CertificateUploadDate *time.Time `locationName:"certificateUploadDate" type:"timestamp" timestampFormat:"iso8601"`

	// The status of the domain name migration. The valid values are AVAILABLE and
	// UPDATING. If the status is UPDATING, the domain cannot be modified further
	// until the existing operation is complete. If it is AVAILABLE, the domain
	// can be updated.
	DomainNameStatus DomainNameStatus `locationName:"domainNameStatus" type:"string" enum:"true"`

	// An optional text message containing detailed information about status of
	// the domain name migration.
	DomainNameStatusMessage *string `locationName:"domainNameStatusMessage" type:"string"`

	// The endpoint type.
	EndpointType EndpointType `locationName:"endpointType" type:"string" enum:"true"`

	// The Amazon Route 53 Hosted Zone ID of the endpoint.
	HostedZoneId *string `locationName:"hostedZoneId" type:"string"`

	// The Transport Layer Security (TLS) version of the security policy for this
	// domain name. The valid values are TLS_1_0 and TLS_1_2.
	SecurityPolicy SecurityPolicy `locationName:"securityPolicy" type:"string" enum:"true"`
}

// String returns the string representation
func (s DomainNameConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DomainNameConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApiGatewayDomainName != nil {
		v := *s.ApiGatewayDomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiGatewayDomainName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CertificateArn != nil {
		v := *s.CertificateArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "certificateArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CertificateName != nil {
		v := *s.CertificateName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "certificateName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CertificateUploadDate != nil {
		v := *s.CertificateUploadDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "certificateUploadDate",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if len(s.DomainNameStatus) > 0 {
		v := s.DomainNameStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "domainNameStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.DomainNameStatusMessage != nil {
		v := *s.DomainNameStatusMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "domainNameStatusMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.EndpointType) > 0 {
		v := s.EndpointType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "endpointType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.HostedZoneId != nil {
		v := *s.HostedZoneId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "hostedZoneId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.SecurityPolicy) > 0 {
		v := s.SecurityPolicy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "securityPolicy", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Represents an integration.
type Integration struct {
	_ struct{} `type:"structure"`

	// Specifies whether an integration is managed by API Gateway. If you created
	// an API using using quick create, the resulting integration is managed by
	// API Gateway. You can update a managed integration, but you can't delete it.
	ApiGatewayManaged *bool `locationName:"apiGatewayManaged" type:"boolean"`

	// The ID of the VPC link for a private integration. Supported only for HTTP
	// APIs.
	ConnectionId *string `locationName:"connectionId" type:"string"`

	// The type of the network connection to the integration endpoint. Specify INTERNET
	// for connections through the public routable internet or VPC_LINK for private
	// connections between API Gateway and resources in a VPC. The default value
	// is INTERNET.
	ConnectionType ConnectionType `locationName:"connectionType" type:"string" enum:"true"`

	// Supported only for WebSocket APIs. Specifies how to handle response payload
	// content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT,
	// with the following behaviors:
	//
	// CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string
	// to the corresponding binary blob.
	//
	// CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded
	// string.
	//
	// If this property is not defined, the response payload will be passed through
	// from the integration response to the route response or method response without
	// modification.
	ContentHandlingStrategy ContentHandlingStrategy `locationName:"contentHandlingStrategy" type:"string" enum:"true"`

	// Specifies the credentials required for the integration, if any. For AWS integrations,
	// three options are available. To specify an IAM Role for API Gateway to assume,
	// use the role's Amazon Resource Name (ARN). To require that the caller's identity
	// be passed through from the request, specify the string arn:aws:iam::*:user/*.
	// To use resource-based permissions on supported AWS services, specify null.
	CredentialsArn *string `locationName:"credentialsArn" type:"string"`

	// Represents the description of an integration.
	Description *string `locationName:"description" type:"string"`

	// Represents the identifier of an integration.
	IntegrationId *string `locationName:"integrationId" type:"string"`

	// Specifies the integration's HTTP method type.
	IntegrationMethod *string `locationName:"integrationMethod" type:"string"`

	// The integration response selection expression for the integration. Supported
	// only for WebSocket APIs. See Integration Response Selection Expressions (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-integration-response-selection-expressions).
	IntegrationResponseSelectionExpression *string `locationName:"integrationResponseSelectionExpression" type:"string"`

	// The integration type of an integration. One of the following:
	//
	// AWS: for integrating the route or method request with an AWS service action,
	// including the Lambda function-invoking action. With the Lambda function-invoking
	// action, this is referred to as the Lambda custom integration. With any other
	// AWS service action, this is known as AWS integration. Supported only for
	// WebSocket APIs.
	//
	// AWS_PROXY: for integrating the route or method request with the Lambda function-invoking
	// action with the client request passed through as-is. This integration is
	// also referred to as Lambda proxy integration.
	//
	// HTTP: for integrating the route or method request with an HTTP endpoint.
	// This integration is also referred to as the HTTP custom integration. Supported
	// only for WebSocket APIs.
	//
	// HTTP_PROXY: for integrating the route or method request with an HTTP endpoint,
	// with the client request passed through as-is. This is also referred to as
	// HTTP proxy integration.
	//
	// MOCK: for integrating the route or method request with API Gateway as a "loopback"
	// endpoint without invoking any backend. Supported only for WebSocket APIs.
	IntegrationType IntegrationType `locationName:"integrationType" type:"string" enum:"true"`

	// For a Lambda integration, specify the URI of a Lambda function.
	//
	// For an HTTP integration, specify a fully-qualified URL.
	//
	// For an HTTP API private integration, specify the ARN of an Application Load
	// Balancer listener, Network Load Balancer listener, or AWS Cloud Map service.
	// If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances
	// to identify resources. You can use query parameters to target specific resources.
	// To learn more, see DiscoverInstances (https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html).
	// For private integrations, all resources must be owned by the same AWS account.
	IntegrationUri *string `locationName:"integrationUri" type:"string"`

	// Specifies the pass-through behavior for incoming requests based on the Content-Type
	// header in the request, and the available mapping templates specified as the
	// requestTemplates property on the Integration resource. There are three valid
	// values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket
	// APIs.
	//
	// WHEN_NO_MATCH passes the request body for unmapped content types through
	// to the integration backend without transformation.
	//
	// NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type
	// response.
	//
	// WHEN_NO_TEMPLATES allows pass-through when the integration has no content
	// types mapped to templates. However, if there is at least one content type
	// defined, unmapped content types will be rejected with the same HTTP 415 Unsupported
	// Media Type response.
	PassthroughBehavior PassthroughBehavior `locationName:"passthroughBehavior" type:"string" enum:"true"`

	// Specifies the format of the payload sent to an integration. Required for
	// HTTP APIs.
	PayloadFormatVersion *string `locationName:"payloadFormatVersion" type:"string"`

	// A key-value map specifying request parameters that are passed from the method
	// request to the backend. The key is an integration request parameter name
	// and the associated value is a method request parameter value or static value
	// that must be enclosed within single quotes and pre-encoded as required by
	// the backend. The method request parameter value must match the pattern of
	// method.request.{location}.{name} , where {location} is querystring, path,
	// or header; and {name} must be a valid and unique method request parameter
	// name. Supported only for WebSocket APIs.
	RequestParameters map[string]string `locationName:"requestParameters" type:"map"`

	// Represents a map of Velocity templates that are applied on the request payload
	// based on the value of the Content-Type header sent by the client. The content
	// type value is the key in this map, and the template (as a String) is the
	// value. Supported only for WebSocket APIs.
	RequestTemplates map[string]string `locationName:"requestTemplates" type:"map"`

	// The template selection expression for the integration. Supported only for
	// WebSocket APIs.
	TemplateSelectionExpression *string `locationName:"templateSelectionExpression" type:"string"`

	// Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and
	// between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is
	// 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.
	TimeoutInMillis *int64 `locationName:"timeoutInMillis" min:"50" type:"integer"`

	// The TLS configuration for a private integration. If you specify a TLS configuration,
	// private integration traffic uses the HTTPS protocol. Supported only for HTTP
	// APIs.
	TlsConfig *TlsConfig `locationName:"tlsConfig" type:"structure"`
}

// String returns the string representation
func (s Integration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Integration) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApiGatewayManaged != nil {
		v := *s.ApiGatewayManaged

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiGatewayManaged", protocol.BoolValue(v), metadata)
	}
	if s.ConnectionId != nil {
		v := *s.ConnectionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "connectionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ConnectionType) > 0 {
		v := s.ConnectionType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "connectionType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.ContentHandlingStrategy) > 0 {
		v := s.ContentHandlingStrategy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "contentHandlingStrategy", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.CredentialsArn != nil {
		v := *s.CredentialsArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "credentialsArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IntegrationId != nil {
		v := *s.IntegrationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "integrationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IntegrationMethod != nil {
		v := *s.IntegrationMethod

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "integrationMethod", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IntegrationResponseSelectionExpression != nil {
		v := *s.IntegrationResponseSelectionExpression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "integrationResponseSelectionExpression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.IntegrationType) > 0 {
		v := s.IntegrationType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "integrationType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.IntegrationUri != nil {
		v := *s.IntegrationUri

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "integrationUri", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.PassthroughBehavior) > 0 {
		v := s.PassthroughBehavior

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "passthroughBehavior", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.PayloadFormatVersion != nil {
		v := *s.PayloadFormatVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "payloadFormatVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestParameters != nil {
		v := s.RequestParameters

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "requestParameters", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.RequestTemplates != nil {
		v := s.RequestTemplates

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "requestTemplates", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.TemplateSelectionExpression != nil {
		v := *s.TemplateSelectionExpression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "templateSelectionExpression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TimeoutInMillis != nil {
		v := *s.TimeoutInMillis

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "timeoutInMillis", protocol.Int64Value(v), metadata)
	}
	if s.TlsConfig != nil {
		v := s.TlsConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "tlsConfig", v, metadata)
	}
	return nil
}

// Represents an integration response.
type IntegrationResponse struct {
	_ struct{} `type:"structure"`

	// Supported only for WebSocket APIs. Specifies how to handle response payload
	// content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT,
	// with the following behaviors:
	//
	// CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string
	// to the corresponding binary blob.
	//
	// CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded
	// string.
	//
	// If this property is not defined, the response payload will be passed through
	// from the integration response to the route response or method response without
	// modification.
	ContentHandlingStrategy ContentHandlingStrategy `locationName:"contentHandlingStrategy" type:"string" enum:"true"`

	// The integration response ID.
	IntegrationResponseId *string `locationName:"integrationResponseId" type:"string"`

	// The integration response key.
	//
	// IntegrationResponseKey is a required field
	IntegrationResponseKey *string `locationName:"integrationResponseKey" type:"string" required:"true"`

	// A key-value map specifying response parameters that are passed to the method
	// response from the backend. The key is a method response header parameter
	// name and the mapped value is an integration response header value, a static
	// value enclosed within a pair of single quotes, or a JSON expression from
	// the integration response body. The mapping key must match the pattern of
	// method.response.header.{name}, where name is a valid and unique header name.
	// The mapped non-static value must match the pattern of integration.response.header.{name}
	// or integration.response.body.{JSON-expression}, where name is a valid and
	// unique response header name and JSON-expression is a valid JSON expression
	// without the $ prefix.
	ResponseParameters map[string]string `locationName:"responseParameters" type:"map"`

	// The collection of response templates for the integration response as a string-to-string
	// map of key-value pairs. Response templates are represented as a key/value
	// map, with a content-type as the key and a template as the value.
	ResponseTemplates map[string]string `locationName:"responseTemplates" type:"map"`

	// The template selection expressions for the integration response.
	TemplateSelectionExpression *string `locationName:"templateSelectionExpression" type:"string"`
}

// String returns the string representation
func (s IntegrationResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s IntegrationResponse) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ContentHandlingStrategy) > 0 {
		v := s.ContentHandlingStrategy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "contentHandlingStrategy", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.IntegrationResponseId != nil {
		v := *s.IntegrationResponseId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "integrationResponseId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IntegrationResponseKey != nil {
		v := *s.IntegrationResponseKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "integrationResponseKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResponseParameters != nil {
		v := s.ResponseParameters

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "responseParameters", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.ResponseTemplates != nil {
		v := s.ResponseTemplates

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "responseTemplates", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.TemplateSelectionExpression != nil {
		v := *s.TemplateSelectionExpression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "templateSelectionExpression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents the configuration of a JWT authorizer. Required for the JWT authorizer
// type. Supported only for HTTP APIs.
type JWTConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of the intended recipients of the JWT. A valid JWT must provide an
	// aud that matches at least one entry in this list. See RFC 7519 (https://tools.ietf.org/html/rfc7519#section-4.1.3).
	// Supported only for HTTP APIs.
	Audience []string `locationName:"audience" type:"list"`

	// The base domain of the identity provider that issues JSON Web Tokens. For
	// example, an Amazon Cognito user pool has the following format: https://cognito-idp.{region}.amazonaws.com/{userPoolId}
	// . Required for the JWT authorizer type. Supported only for HTTP APIs.
	Issuer *string `locationName:"issuer" type:"string"`
}

// String returns the string representation
func (s JWTConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s JWTConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.Audience != nil {
		v := s.Audience

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "audience", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Issuer != nil {
		v := *s.Issuer

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "issuer", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents a data model for an API. Supported only for WebSocket APIs. See
// Create Models and Mapping Templates for Request and Response Mappings (https://docs.aws.amazon.com/apigateway/latest/developerguide/models-mappings.html).
type Model struct {
	_ struct{} `type:"structure"`

	// The content-type for the model, for example, "application/json".
	ContentType *string `locationName:"contentType" type:"string"`

	// The description of the model.
	Description *string `locationName:"description" type:"string"`

	// The model identifier.
	ModelId *string `locationName:"modelId" type:"string"`

	// The name of the model. Must be alphanumeric.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The schema for the model. For application/json models, this should be JSON
	// schema draft 4 model.
	Schema *string `locationName:"schema" type:"string"`
}

// String returns the string representation
func (s Model) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Model) MarshalFields(e protocol.FieldEncoder) error {
	if s.ContentType != nil {
		v := *s.ContentType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "contentType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ModelId != nil {
		v := *s.ModelId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "modelId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Schema != nil {
		v := *s.Schema

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "schema", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Validation constraints imposed on parameters of a request (path, query string,
// headers).
type ParameterConstraints struct {
	_ struct{} `type:"structure"`

	// Whether or not the parameter is required.
	Required *bool `locationName:"required" type:"boolean"`
}

// String returns the string representation
func (s ParameterConstraints) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ParameterConstraints) MarshalFields(e protocol.FieldEncoder) error {
	if s.Required != nil {
		v := *s.Required

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "required", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Represents a route.
type Route struct {
	_ struct{} `type:"structure"`

	// Specifies whether a route is managed by API Gateway. If you created an API
	// using quick create, the $default route is managed by API Gateway. You can't
	// modify the $default route key.
	ApiGatewayManaged *bool `locationName:"apiGatewayManaged" type:"boolean"`

	// Specifies whether an API key is required for this route. Supported only for
	// WebSocket APIs.
	ApiKeyRequired *bool `locationName:"apiKeyRequired" type:"boolean"`

	// A list of authorization scopes configured on a route. The scopes are used
	// with a JWT authorizer to authorize the method invocation. The authorization
	// works by matching the route scopes against the scopes parsed from the access
	// token in the incoming request. The method invocation is authorized if any
	// route scope matches a claimed scope in the access token. Otherwise, the invocation
	// is not authorized. When the route scope is configured, the client must provide
	// an access token instead of an identity token for authorization purposes.
	AuthorizationScopes []string `locationName:"authorizationScopes" type:"list"`

	// The authorization type for the route. For WebSocket APIs, valid values are
	// NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for
	// using a Lambda authorizer For HTTP APIs, valid values are NONE for open access,
	// or JWT for using JSON Web Tokens.
	AuthorizationType AuthorizationType `locationName:"authorizationType" type:"string" enum:"true"`

	// The identifier of the Authorizer resource to be associated with this route.
	// The authorizer identifier is generated by API Gateway when you created the
	// authorizer.
	AuthorizerId *string `locationName:"authorizerId" type:"string"`

	// The model selection expression for the route. Supported only for WebSocket
	// APIs.
	ModelSelectionExpression *string `locationName:"modelSelectionExpression" type:"string"`

	// The operation name for the route.
	OperationName *string `locationName:"operationName" type:"string"`

	// The request models for the route. Supported only for WebSocket APIs.
	RequestModels map[string]string `locationName:"requestModels" type:"map"`

	// The request parameters for the route. Supported only for WebSocket APIs.
	RequestParameters map[string]ParameterConstraints `locationName:"requestParameters" type:"map"`

	// The route ID.
	RouteId *string `locationName:"routeId" type:"string"`

	// The route key for the route.
	//
	// RouteKey is a required field
	RouteKey *string `locationName:"routeKey" type:"string" required:"true"`

	// The route response selection expression for the route. Supported only for
	// WebSocket APIs.
	RouteResponseSelectionExpression *string `locationName:"routeResponseSelectionExpression" type:"string"`

	// The target for the route.
	Target *string `locationName:"target" type:"string"`
}

// String returns the string representation
func (s Route) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Route) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApiGatewayManaged != nil {
		v := *s.ApiGatewayManaged

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiGatewayManaged", protocol.BoolValue(v), metadata)
	}
	if s.ApiKeyRequired != nil {
		v := *s.ApiKeyRequired

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiKeyRequired", protocol.BoolValue(v), metadata)
	}
	if s.AuthorizationScopes != nil {
		v := s.AuthorizationScopes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "authorizationScopes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.AuthorizationType) > 0 {
		v := s.AuthorizationType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authorizationType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.AuthorizerId != nil {
		v := *s.AuthorizerId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "authorizerId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ModelSelectionExpression != nil {
		v := *s.ModelSelectionExpression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "modelSelectionExpression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OperationName != nil {
		v := *s.OperationName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "operationName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestModels != nil {
		v := s.RequestModels

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "requestModels", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.RequestParameters != nil {
		v := s.RequestParameters

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "requestParameters", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.RouteId != nil {
		v := *s.RouteId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "routeId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RouteKey != nil {
		v := *s.RouteKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "routeKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RouteResponseSelectionExpression != nil {
		v := *s.RouteResponseSelectionExpression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "routeResponseSelectionExpression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Target != nil {
		v := *s.Target

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "target", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents a route response.
type RouteResponse struct {
	_ struct{} `type:"structure"`

	// Represents the model selection expression of a route response. Supported
	// only for WebSocket APIs.
	ModelSelectionExpression *string `locationName:"modelSelectionExpression" type:"string"`

	// Represents the response models of a route response.
	ResponseModels map[string]string `locationName:"responseModels" type:"map"`

	// Represents the response parameters of a route response.
	ResponseParameters map[string]ParameterConstraints `locationName:"responseParameters" type:"map"`

	// Represents the identifier of a route response.
	RouteResponseId *string `locationName:"routeResponseId" type:"string"`

	// Represents the route response key of a route response.
	//
	// RouteResponseKey is a required field
	RouteResponseKey *string `locationName:"routeResponseKey" type:"string" required:"true"`
}

// String returns the string representation
func (s RouteResponse) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RouteResponse) MarshalFields(e protocol.FieldEncoder) error {
	if s.ModelSelectionExpression != nil {
		v := *s.ModelSelectionExpression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "modelSelectionExpression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResponseModels != nil {
		v := s.ResponseModels

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "responseModels", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.ResponseParameters != nil {
		v := s.ResponseParameters

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "responseParameters", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.RouteResponseId != nil {
		v := *s.RouteResponseId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "routeResponseId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RouteResponseKey != nil {
		v := *s.RouteResponseKey

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "routeResponseKey", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents a collection of route settings.
type RouteSettings struct {
	_ struct{} `type:"structure"`

	// Specifies whether (true) or not (false) data trace logging is enabled for
	// this route. This property affects the log entries pushed to Amazon CloudWatch
	// Logs. Supported only for WebSocket APIs.
	DataTraceEnabled *bool `locationName:"dataTraceEnabled" type:"boolean"`

	// Specifies whether detailed metrics are enabled.
	DetailedMetricsEnabled *bool `locationName:"detailedMetricsEnabled" type:"boolean"`

	// Specifies the logging level for this route: INFO, ERROR, or OFF. This property
	// affects the log entries pushed to Amazon CloudWatch Logs. Supported only
	// for WebSocket APIs.
	LoggingLevel LoggingLevel `locationName:"loggingLevel" type:"string" enum:"true"`

	// Specifies the throttling burst limit.
	ThrottlingBurstLimit *int64 `locationName:"throttlingBurstLimit" type:"integer"`

	// Specifies the throttling rate limit.
	ThrottlingRateLimit *float64 `locationName:"throttlingRateLimit" type:"double"`
}

// String returns the string representation
func (s RouteSettings) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RouteSettings) MarshalFields(e protocol.FieldEncoder) error {
	if s.DataTraceEnabled != nil {
		v := *s.DataTraceEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dataTraceEnabled", protocol.BoolValue(v), metadata)
	}
	if s.DetailedMetricsEnabled != nil {
		v := *s.DetailedMetricsEnabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "detailedMetricsEnabled", protocol.BoolValue(v), metadata)
	}
	if len(s.LoggingLevel) > 0 {
		v := s.LoggingLevel

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "loggingLevel", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ThrottlingBurstLimit != nil {
		v := *s.ThrottlingBurstLimit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "throttlingBurstLimit", protocol.Int64Value(v), metadata)
	}
	if s.ThrottlingRateLimit != nil {
		v := *s.ThrottlingRateLimit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "throttlingRateLimit", protocol.Float64Value(v), metadata)
	}
	return nil
}

// Represents an API stage.
type Stage struct {
	_ struct{} `type:"structure"`

	// Settings for logging access in this stage.
	AccessLogSettings *AccessLogSettings `locationName:"accessLogSettings" type:"structure"`

	// Specifies whether a stage is managed by API Gateway. If you created an API
	// using quick create, the $default stage is managed by API Gateway. You can't
	// modify the $default stage.
	ApiGatewayManaged *bool `locationName:"apiGatewayManaged" type:"boolean"`

	// Specifies whether updates to an API automatically trigger a new deployment.
	// The default value is false.
	AutoDeploy *bool `locationName:"autoDeploy" type:"boolean"`

	// The identifier of a client certificate for a Stage. Supported only for WebSocket
	// APIs.
	ClientCertificateId *string `locationName:"clientCertificateId" type:"string"`

	// The timestamp when the stage was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601"`

	// Default route settings for the stage.
	DefaultRouteSettings *RouteSettings `locationName:"defaultRouteSettings" type:"structure"`

	// The identifier of the Deployment that the Stage is associated with. Can't
	// be updated if autoDeploy is enabled.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// The description of the stage.
	Description *string `locationName:"description" type:"string"`

	// Describes the status of the last deployment of a stage. Supported only for
	// stages with autoDeploy enabled.
	LastDeploymentStatusMessage *string `locationName:"lastDeploymentStatusMessage" type:"string"`

	// The timestamp when the stage was last updated.
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp" timestampFormat:"iso8601"`

	// Route settings for the stage, by routeKey.
	RouteSettings map[string]RouteSettings `locationName:"routeSettings" type:"map"`

	// The name of the stage.
	//
	// StageName is a required field
	StageName *string `locationName:"stageName" type:"string" required:"true"`

	// A map that defines the stage variables for a stage resource. Variable names
	// can have alphanumeric and underscore characters, and the values must match
	// [A-Za-z0-9-._~:/?#&=,]+.
	StageVariables map[string]string `locationName:"stageVariables" type:"map"`

	// The collection of tags. Each tag element is associated with a given resource.
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s Stage) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Stage) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessLogSettings != nil {
		v := s.AccessLogSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "accessLogSettings", v, metadata)
	}
	if s.ApiGatewayManaged != nil {
		v := *s.ApiGatewayManaged

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "apiGatewayManaged", protocol.BoolValue(v), metadata)
	}
	if s.AutoDeploy != nil {
		v := *s.AutoDeploy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "autoDeploy", protocol.BoolValue(v), metadata)
	}
	if s.ClientCertificateId != nil {
		v := *s.ClientCertificateId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientCertificateId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedDate != nil {
		v := *s.CreatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdDate",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.DefaultRouteSettings != nil {
		v := s.DefaultRouteSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "defaultRouteSettings", v, metadata)
	}
	if s.DeploymentId != nil {
		v := *s.DeploymentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deploymentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastDeploymentStatusMessage != nil {
		v := *s.LastDeploymentStatusMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastDeploymentStatusMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdatedDate != nil {
		v := *s.LastUpdatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdatedDate",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.RouteSettings != nil {
		v := s.RouteSettings

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "routeSettings", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	if s.StageName != nil {
		v := *s.StageName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stageName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StageVariables != nil {
		v := s.StageVariables

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "stageVariables", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// The TLS configuration for a private integration. If you specify a TLS configuration,
// private integration traffic uses the HTTPS protocol. Supported only for HTTP
// APIs.
type TlsConfig struct {
	_ struct{} `type:"structure"`

	// If you specify a server name, API Gateway uses it to verify the hostname
	// on the integration's certificate. The server name is also included in the
	// TLS handshake to support Server Name Indication (SNI) or virtual hosting.
	ServerNameToVerify *string `locationName:"serverNameToVerify" type:"string"`
}

// String returns the string representation
func (s TlsConfig) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TlsConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.ServerNameToVerify != nil {
		v := *s.ServerNameToVerify

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "serverNameToVerify", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The TLS configuration for a private integration. If you specify a TLS configuration,
// private integration traffic uses the HTTPS protocol. Supported only for HTTP
// APIs.
type TlsConfigInput struct {
	_ struct{} `type:"structure"`

	// If you specify a server name, API Gateway uses it to verify the hostname
	// on the integration's certificate. The server name is also included in the
	// TLS handshake to support Server Name Indication (SNI) or virtual hosting.
	ServerNameToVerify *string `locationName:"serverNameToVerify" type:"string"`
}

// String returns the string representation
func (s TlsConfigInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TlsConfigInput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ServerNameToVerify != nil {
		v := *s.ServerNameToVerify

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "serverNameToVerify", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents a VPC link.
type VpcLink struct {
	_ struct{} `type:"structure"`

	// The timestamp when the VPC link was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" timestampFormat:"iso8601"`

	// The name of the VPC link.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// A list of security group IDs for the VPC link.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []string `locationName:"securityGroupIds" type:"list" required:"true"`

	// A list of subnet IDs to include in the VPC link.
	//
	// SubnetIds is a required field
	SubnetIds []string `locationName:"subnetIds" type:"list" required:"true"`

	// Tags for the VPC link.
	Tags map[string]string `locationName:"tags" type:"map"`

	// The ID of the VPC link.
	//
	// VpcLinkId is a required field
	VpcLinkId *string `locationName:"vpcLinkId" type:"string" required:"true"`

	// The status of the VPC link.
	VpcLinkStatus VpcLinkStatus `locationName:"vpcLinkStatus" type:"string" enum:"true"`

	// A message summarizing the cause of the status of the VPC link.
	VpcLinkStatusMessage *string `locationName:"vpcLinkStatusMessage" type:"string"`

	// The version of the VPC link.
	VpcLinkVersion VpcLinkVersion `locationName:"vpcLinkVersion" type:"string" enum:"true"`
}

// String returns the string representation
func (s VpcLink) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VpcLink) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreatedDate != nil {
		v := *s.CreatedDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdDate",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SecurityGroupIds != nil {
		v := s.SecurityGroupIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "securityGroupIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.SubnetIds != nil {
		v := s.SubnetIds

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "subnetIds", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.VpcLinkId != nil {
		v := *s.VpcLinkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "vpcLinkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.VpcLinkStatus) > 0 {
		v := s.VpcLinkStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "vpcLinkStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.VpcLinkStatusMessage != nil {
		v := *s.VpcLinkStatusMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "vpcLinkStatusMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.VpcLinkVersion) > 0 {
		v := s.VpcLinkVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "vpcLinkVersion", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}
