// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appconfig

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateConfigurationProfileInput struct {
	_ struct{} `type:"structure"`

	// The application ID.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"ApplicationId" type:"string" required:"true"`

	// A description of the configuration profile.
	Description *string `type:"string"`

	// A URI to locate the configuration. You can specify a Systems Manager (SSM)
	// document, an SSM Parameter Store parameter, or an Amazon S3 object. For an
	// SSM document, specify either the document name in the format ssm-document://<Document_name>
	// or the Amazon Resource Name (ARN). For a parameter, specify either the parameter
	// name in the format ssm-parameter://<Parameter_name> or the ARN. For an Amazon
	// S3 object, specify the URI in the following format: s3://<bucket>/<objectKey>
	// . Here is an example: s3://my-bucket/my-app/us-east-1/my-config.json
	//
	// LocationUri is a required field
	LocationUri *string `min:"1" type:"string" required:"true"`

	// A name for the configuration profile.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The ARN of an IAM role with permission to access the configuration at the
	// specified LocationUri.
	RetrievalRoleArn *string `min:"20" type:"string"`

	// Metadata to assign to the configuration profile. Tags help organize and categorize
	// your AppConfig resources. Each tag consists of a key and an optional value,
	// both of which you define.
	Tags map[string]string `type:"map"`

	// A list of methods for validating the configuration.
	Validators []Validator `type:"list"`
}

// String returns the string representation
func (s CreateConfigurationProfileInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConfigurationProfileInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateConfigurationProfileInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if s.LocationUri == nil {
		invalidParams.Add(aws.NewErrParamRequired("LocationUri"))
	}
	if s.LocationUri != nil && len(*s.LocationUri) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LocationUri", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.RetrievalRoleArn != nil && len(*s.RetrievalRoleArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("RetrievalRoleArn", 20))
	}
	if s.Validators != nil {
		for i, v := range s.Validators {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Validators", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateConfigurationProfileInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LocationUri != nil {
		v := *s.LocationUri

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LocationUri", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RetrievalRoleArn != nil {
		v := *s.RetrievalRoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RetrievalRoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Validators != nil {
		v := s.Validators

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Validators", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CreateConfigurationProfileOutput struct {
	_ struct{} `type:"structure"`

	// The application ID.
	ApplicationId *string `type:"string"`

	// The configuration profile description.
	Description *string `type:"string"`

	// The configuration profile ID.
	Id *string `type:"string"`

	// The URI location of the configuration.
	LocationUri *string `min:"1" type:"string"`

	// The name of the configuration profile.
	Name *string `min:"1" type:"string"`

	// The ARN of an IAM role with permission to access the configuration at the
	// specified LocationUri.
	RetrievalRoleArn *string `min:"20" type:"string"`

	// A list of methods for validating the configuration.
	Validators []Validator `type:"list"`
}

// String returns the string representation
func (s CreateConfigurationProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateConfigurationProfileOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LocationUri != nil {
		v := *s.LocationUri

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LocationUri", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RetrievalRoleArn != nil {
		v := *s.RetrievalRoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RetrievalRoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Validators != nil {
		v := s.Validators

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Validators", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opCreateConfigurationProfile = "CreateConfigurationProfile"

// CreateConfigurationProfileRequest returns a request value for making API operation for
// Amazon AppConfig.
//
// Information that enables AppConfig to access the configuration source. Valid
// configuration sources include Systems Manager (SSM) documents, SSM Parameter
// Store parameters, and Amazon S3 objects. A configuration profile includes
// the following information.
//
//    * The Uri location of the configuration data.
//
//    * The AWS Identity and Access Management (IAM) role that provides access
//    to the configuration data.
//
//    * A validator for the configuration data. Available validators include
//    either a JSON Schema or an AWS Lambda function.
//
// For more information, see Create a Configuration and a Configuration Profile
// (http://docs.aws.amazon.com/systems-manager/latest/userguide/appconfig-creating-configuration-and-profile.html)
// in the AWS AppConfig User Guide.
//
//    // Example sending a request using CreateConfigurationProfileRequest.
//    req := client.CreateConfigurationProfileRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/CreateConfigurationProfile
func (c *Client) CreateConfigurationProfileRequest(input *CreateConfigurationProfileInput) CreateConfigurationProfileRequest {
	op := &aws.Operation{
		Name:       opCreateConfigurationProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/applications/{ApplicationId}/configurationprofiles",
	}

	if input == nil {
		input = &CreateConfigurationProfileInput{}
	}

	req := c.newRequest(op, input, &CreateConfigurationProfileOutput{})

	return CreateConfigurationProfileRequest{Request: req, Input: input, Copy: c.CreateConfigurationProfileRequest}
}

// CreateConfigurationProfileRequest is the request type for the
// CreateConfigurationProfile API operation.
type CreateConfigurationProfileRequest struct {
	*aws.Request
	Input *CreateConfigurationProfileInput
	Copy  func(*CreateConfigurationProfileInput) CreateConfigurationProfileRequest
}

// Send marshals and sends the CreateConfigurationProfile API request.
func (r CreateConfigurationProfileRequest) Send(ctx context.Context) (*CreateConfigurationProfileResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateConfigurationProfileResponse{
		CreateConfigurationProfileOutput: r.Request.Data.(*CreateConfigurationProfileOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateConfigurationProfileResponse is the response type for the
// CreateConfigurationProfile API operation.
type CreateConfigurationProfileResponse struct {
	*CreateConfigurationProfileOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateConfigurationProfile request.
func (r *CreateConfigurationProfileResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
