// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appconfig

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateDeploymentStrategyInput struct {
	_ struct{} `type:"structure"`

	// Total amount of time for a deployment to last.
	//
	// DeploymentDurationInMinutes is a required field
	DeploymentDurationInMinutes *int64 `type:"integer" required:"true"`

	// A description of the deployment strategy.
	Description *string `type:"string"`

	// The amount of time AppConfig monitors for alarms before considering the deployment
	// to be complete and no longer eligible for automatic roll back.
	FinalBakeTimeInMinutes *int64 `type:"integer"`

	// The percentage of targets to receive a deployed configuration during each
	// interval.
	//
	// GrowthFactor is a required field
	GrowthFactor *float64 `min:"1" type:"float" required:"true"`

	// The algorithm used to define how percentage grows over time. AWS AppConfig
	// supports the following growth types:
	//
	// Linear: For this type, AppConfig processes the deployment by dividing the
	// total number of targets by the value specified for Step percentage. For example,
	// a linear deployment that uses a Step percentage of 10 deploys the configuration
	// to 10 percent of the hosts. After those deployments are complete, the system
	// deploys the configuration to the next 10 percent. This continues until 100%
	// of the targets have successfully received the configuration.
	//
	// Exponential: For this type, AppConfig processes the deployment exponentially
	// using the following formula: G*(2^N). In this formula, G is the growth factor
	// specified by the user and N is the number of steps until the configuration
	// is deployed to all targets. For example, if you specify a growth factor of
	// 2, then the system rolls out the configuration as follows:
	//
	// 2*(2^0)
	//
	// 2*(2^1)
	//
	// 2*(2^2)
	//
	// Expressed numerically, the deployment rolls out as follows: 2% of the targets,
	// 4% of the targets, 8% of the targets, and continues until the configuration
	// has been deployed to all targets.
	GrowthType GrowthType `type:"string" enum:"true"`

	// A name for the deployment strategy.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Save the deployment strategy to a Systems Manager (SSM) document.
	//
	// ReplicateTo is a required field
	ReplicateTo ReplicateTo `type:"string" required:"true" enum:"true"`

	// Metadata to assign to the deployment strategy. Tags help organize and categorize
	// your AppConfig resources. Each tag consists of a key and an optional value,
	// both of which you define.
	Tags map[string]string `type:"map"`
}

// String returns the string representation
func (s CreateDeploymentStrategyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDeploymentStrategyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateDeploymentStrategyInput"}

	if s.DeploymentDurationInMinutes == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeploymentDurationInMinutes"))
	}

	if s.GrowthFactor == nil {
		invalidParams.Add(aws.NewErrParamRequired("GrowthFactor"))
	}
	if s.GrowthFactor != nil && *s.GrowthFactor < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("GrowthFactor", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if len(s.ReplicateTo) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ReplicateTo"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateDeploymentStrategyInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DeploymentDurationInMinutes != nil {
		v := *s.DeploymentDurationInMinutes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeploymentDurationInMinutes", protocol.Int64Value(v), metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FinalBakeTimeInMinutes != nil {
		v := *s.FinalBakeTimeInMinutes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FinalBakeTimeInMinutes", protocol.Int64Value(v), metadata)
	}
	if s.GrowthFactor != nil {
		v := *s.GrowthFactor

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GrowthFactor", protocol.Float64Value(v), metadata)
	}
	if len(s.GrowthType) > 0 {
		v := s.GrowthType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GrowthType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ReplicateTo) > 0 {
		v := s.ReplicateTo

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReplicateTo", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

type CreateDeploymentStrategyOutput struct {
	_ struct{} `type:"structure"`

	// Total amount of time the deployment lasted.
	DeploymentDurationInMinutes *int64 `type:"integer"`

	// The description of the deployment strategy.
	Description *string `type:"string"`

	// The amount of time AppConfig monitored for alarms before considering the
	// deployment to be complete and no longer eligible for automatic roll back.
	FinalBakeTimeInMinutes *int64 `type:"integer"`

	// The percentage of targets that received a deployed configuration during each
	// interval.
	GrowthFactor *float64 `min:"1" type:"float"`

	// The algorithm used to define how percentage grew over time.
	GrowthType GrowthType `type:"string" enum:"true"`

	// The deployment strategy ID.
	Id *string `type:"string"`

	// The name of the deployment strategy.
	Name *string `min:"1" type:"string"`

	// Save the deployment strategy to a Systems Manager (SSM) document.
	ReplicateTo ReplicateTo `type:"string" enum:"true"`
}

// String returns the string representation
func (s CreateDeploymentStrategyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateDeploymentStrategyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DeploymentDurationInMinutes != nil {
		v := *s.DeploymentDurationInMinutes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeploymentDurationInMinutes", protocol.Int64Value(v), metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FinalBakeTimeInMinutes != nil {
		v := *s.FinalBakeTimeInMinutes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FinalBakeTimeInMinutes", protocol.Int64Value(v), metadata)
	}
	if s.GrowthFactor != nil {
		v := *s.GrowthFactor

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GrowthFactor", protocol.Float64Value(v), metadata)
	}
	if len(s.GrowthType) > 0 {
		v := s.GrowthType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GrowthType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ReplicateTo) > 0 {
		v := s.ReplicateTo

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReplicateTo", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

const opCreateDeploymentStrategy = "CreateDeploymentStrategy"

// CreateDeploymentStrategyRequest returns a request value for making API operation for
// Amazon AppConfig.
//
// A deployment strategy defines important criteria for rolling out your configuration
// to the designated targets. A deployment strategy includes: the overall duration
// required, a percentage of targets to receive the deployment during each interval,
// an algorithm that defines how percentage grows, and bake time.
//
//    // Example sending a request using CreateDeploymentStrategyRequest.
//    req := client.CreateDeploymentStrategyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/CreateDeploymentStrategy
func (c *Client) CreateDeploymentStrategyRequest(input *CreateDeploymentStrategyInput) CreateDeploymentStrategyRequest {
	op := &aws.Operation{
		Name:       opCreateDeploymentStrategy,
		HTTPMethod: "POST",
		HTTPPath:   "/deploymentstrategies",
	}

	if input == nil {
		input = &CreateDeploymentStrategyInput{}
	}

	req := c.newRequest(op, input, &CreateDeploymentStrategyOutput{})

	return CreateDeploymentStrategyRequest{Request: req, Input: input, Copy: c.CreateDeploymentStrategyRequest}
}

// CreateDeploymentStrategyRequest is the request type for the
// CreateDeploymentStrategy API operation.
type CreateDeploymentStrategyRequest struct {
	*aws.Request
	Input *CreateDeploymentStrategyInput
	Copy  func(*CreateDeploymentStrategyInput) CreateDeploymentStrategyRequest
}

// Send marshals and sends the CreateDeploymentStrategy API request.
func (r CreateDeploymentStrategyRequest) Send(ctx context.Context) (*CreateDeploymentStrategyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateDeploymentStrategyResponse{
		CreateDeploymentStrategyOutput: r.Request.Data.(*CreateDeploymentStrategyOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateDeploymentStrategyResponse is the response type for the
// CreateDeploymentStrategy API operation.
type CreateDeploymentStrategyResponse struct {
	*CreateDeploymentStrategyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateDeploymentStrategy request.
func (r *CreateDeploymentStrategyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
