// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appconfig

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type DeleteHostedConfigurationVersionInput struct {
	_ struct{} `type:"structure"`

	// The application ID.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"ApplicationId" type:"string" required:"true"`

	// The configuration profile ID.
	//
	// ConfigurationProfileId is a required field
	ConfigurationProfileId *string `location:"uri" locationName:"ConfigurationProfileId" type:"string" required:"true"`

	// The versions number to delete.
	//
	// VersionNumber is a required field
	VersionNumber *int64 `location:"uri" locationName:"VersionNumber" type:"integer" required:"true"`
}

// String returns the string representation
func (s DeleteHostedConfigurationVersionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteHostedConfigurationVersionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteHostedConfigurationVersionInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if s.ConfigurationProfileId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConfigurationProfileId"))
	}

	if s.VersionNumber == nil {
		invalidParams.Add(aws.NewErrParamRequired("VersionNumber"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteHostedConfigurationVersionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ConfigurationProfileId != nil {
		v := *s.ConfigurationProfileId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ConfigurationProfileId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VersionNumber != nil {
		v := *s.VersionNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "VersionNumber", protocol.Int64Value(v), metadata)
	}
	return nil
}

type DeleteHostedConfigurationVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteHostedConfigurationVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteHostedConfigurationVersionOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteHostedConfigurationVersion = "DeleteHostedConfigurationVersion"

// DeleteHostedConfigurationVersionRequest returns a request value for making API operation for
// Amazon AppConfig.
//
// Delete a version of a configuration from the AppConfig configuration store.
//
//    // Example sending a request using DeleteHostedConfigurationVersionRequest.
//    req := client.DeleteHostedConfigurationVersionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/DeleteHostedConfigurationVersion
func (c *Client) DeleteHostedConfigurationVersionRequest(input *DeleteHostedConfigurationVersionInput) DeleteHostedConfigurationVersionRequest {
	op := &aws.Operation{
		Name:       opDeleteHostedConfigurationVersion,
		HTTPMethod: "DELETE",
		HTTPPath:   "/applications/{ApplicationId}/configurationprofiles/{ConfigurationProfileId}/hostedconfigurationversions/{VersionNumber}",
	}

	if input == nil {
		input = &DeleteHostedConfigurationVersionInput{}
	}

	req := c.newRequest(op, input, &DeleteHostedConfigurationVersionOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return DeleteHostedConfigurationVersionRequest{Request: req, Input: input, Copy: c.DeleteHostedConfigurationVersionRequest}
}

// DeleteHostedConfigurationVersionRequest is the request type for the
// DeleteHostedConfigurationVersion API operation.
type DeleteHostedConfigurationVersionRequest struct {
	*aws.Request
	Input *DeleteHostedConfigurationVersionInput
	Copy  func(*DeleteHostedConfigurationVersionInput) DeleteHostedConfigurationVersionRequest
}

// Send marshals and sends the DeleteHostedConfigurationVersion API request.
func (r DeleteHostedConfigurationVersionRequest) Send(ctx context.Context) (*DeleteHostedConfigurationVersionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteHostedConfigurationVersionResponse{
		DeleteHostedConfigurationVersionOutput: r.Request.Data.(*DeleteHostedConfigurationVersionOutput),
		response:                               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteHostedConfigurationVersionResponse is the response type for the
// DeleteHostedConfigurationVersion API operation.
type DeleteHostedConfigurationVersionResponse struct {
	*DeleteHostedConfigurationVersionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteHostedConfigurationVersion request.
func (r *DeleteHostedConfigurationVersionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
