// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appconfig

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetApplicationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the application you want to get.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"ApplicationId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApplicationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetApplicationInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetApplicationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetApplicationOutput struct {
	_ struct{} `type:"structure"`

	// The description of the application.
	Description *string `type:"string"`

	// The application ID.
	Id *string `type:"string"`

	// The application name.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetApplicationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetApplication = "GetApplication"

// GetApplicationRequest returns a request value for making API operation for
// Amazon AppConfig.
//
// Retrieve information about an application.
//
//    // Example sending a request using GetApplicationRequest.
//    req := client.GetApplicationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetApplication
func (c *Client) GetApplicationRequest(input *GetApplicationInput) GetApplicationRequest {
	op := &aws.Operation{
		Name:       opGetApplication,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{ApplicationId}",
	}

	if input == nil {
		input = &GetApplicationInput{}
	}

	req := c.newRequest(op, input, &GetApplicationOutput{})

	return GetApplicationRequest{Request: req, Input: input, Copy: c.GetApplicationRequest}
}

// GetApplicationRequest is the request type for the
// GetApplication API operation.
type GetApplicationRequest struct {
	*aws.Request
	Input *GetApplicationInput
	Copy  func(*GetApplicationInput) GetApplicationRequest
}

// Send marshals and sends the GetApplication API request.
func (r GetApplicationRequest) Send(ctx context.Context) (*GetApplicationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetApplicationResponse{
		GetApplicationOutput: r.Request.Data.(*GetApplicationOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetApplicationResponse is the response type for the
// GetApplication API operation.
type GetApplicationResponse struct {
	*GetApplicationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetApplication request.
func (r *GetApplicationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
