// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appconfig

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The application to get. Specify either the application name or the application
	// ID.
	//
	// Application is a required field
	Application *string `location:"uri" locationName:"Application" min:"1" type:"string" required:"true"`

	// The configuration version returned in the most recent GetConfiguration response.
	//
	// AWS AppConfig uses the value of the ClientConfigurationVersion parameter
	// to identify the configuration version on your clients. If you don’t send
	// ClientConfigurationVersion with each call to GetConfiguration, your clients
	// receive the current configuration. You are charged each time your clients
	// receive a configuration.
	//
	// To avoid excess charges, we recommend that you include the ClientConfigurationVersion
	// value with every call to GetConfiguration. This value must be saved on your
	// client. Subsequent calls to GetConfiguration must pass this value by using
	// the ClientConfigurationVersion parameter.
	//
	// For more information about working with configurations, see Retrieving the
	// Configuration (https://docs.aws.amazon.com/systems-manager/latest/userguide/appconfig-retrieving-the-configuration.html)
	// in the AWS AppConfig User Guide.
	ClientConfigurationVersion *string `location:"querystring" locationName:"client_configuration_version" min:"1" type:"string"`

	// A unique ID to identify the client for the configuration. This ID enables
	// AppConfig to deploy the configuration in intervals, as defined in the deployment
	// strategy.
	//
	// ClientId is a required field
	ClientId *string `location:"querystring" locationName:"client_id" min:"1" type:"string" required:"true"`

	// The configuration to get. Specify either the configuration name or the configuration
	// ID.
	//
	// Configuration is a required field
	Configuration *string `location:"uri" locationName:"Configuration" min:"1" type:"string" required:"true"`

	// The environment to get. Specify either the environment name or the environment
	// ID.
	//
	// Environment is a required field
	Environment *string `location:"uri" locationName:"Environment" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetConfigurationInput"}

	if s.Application == nil {
		invalidParams.Add(aws.NewErrParamRequired("Application"))
	}
	if s.Application != nil && len(*s.Application) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Application", 1))
	}
	if s.ClientConfigurationVersion != nil && len(*s.ClientConfigurationVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientConfigurationVersion", 1))
	}

	if s.ClientId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientId", 1))
	}

	if s.Configuration == nil {
		invalidParams.Add(aws.NewErrParamRequired("Configuration"))
	}
	if s.Configuration != nil && len(*s.Configuration) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Configuration", 1))
	}

	if s.Environment == nil {
		invalidParams.Add(aws.NewErrParamRequired("Environment"))
	}
	if s.Environment != nil && len(*s.Environment) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Environment", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Application != nil {
		v := *s.Application

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Application", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Configuration != nil {
		v := *s.Configuration

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Configuration", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Environment != nil {
		v := *s.Environment

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Environment", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ClientConfigurationVersion != nil {
		v := *s.ClientConfigurationVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "client_configuration_version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ClientId != nil {
		v := *s.ClientId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "client_id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetConfigurationOutput struct {
	_ struct{} `type:"structure" payload:"Content"`

	// The configuration version.
	ConfigurationVersion *string `location:"header" locationName:"Configuration-Version" min:"1" type:"string"`

	// The content of the configuration or the configuration data.
	Content []byte `type:"blob" sensitive:"true"`

	// A standard MIME type describing the format of the configuration content.
	// For more information, see Content-Type (http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17).
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`
}

// String returns the string representation
func (s GetConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ConfigurationVersion != nil {
		v := *s.ConfigurationVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Configuration-Version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ContentType != nil {
		v := *s.ContentType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Content != nil {
		v := s.Content

		metadata := protocol.Metadata{}
		e.SetStream(protocol.PayloadTarget, "Content", protocol.BytesStream(v), metadata)
	}
	return nil
}

const opGetConfiguration = "GetConfiguration"

// GetConfigurationRequest returns a request value for making API operation for
// Amazon AppConfig.
//
// Receive information about a configuration.
//
// AWS AppConfig uses the value of the ClientConfigurationVersion parameter
// to identify the configuration version on your clients. If you don’t send
// ClientConfigurationVersion with each call to GetConfiguration, your clients
// receive the current configuration. You are charged each time your clients
// receive a configuration.
//
// To avoid excess charges, we recommend that you include the ClientConfigurationVersion
// value with every call to GetConfiguration. This value must be saved on your
// client. Subsequent calls to GetConfiguration must pass this value by using
// the ClientConfigurationVersion parameter.
//
//    // Example sending a request using GetConfigurationRequest.
//    req := client.GetConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetConfiguration
func (c *Client) GetConfigurationRequest(input *GetConfigurationInput) GetConfigurationRequest {
	op := &aws.Operation{
		Name:       opGetConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{Application}/environments/{Environment}/configurations/{Configuration}",
	}

	if input == nil {
		input = &GetConfigurationInput{}
	}

	req := c.newRequest(op, input, &GetConfigurationOutput{})

	return GetConfigurationRequest{Request: req, Input: input, Copy: c.GetConfigurationRequest}
}

// GetConfigurationRequest is the request type for the
// GetConfiguration API operation.
type GetConfigurationRequest struct {
	*aws.Request
	Input *GetConfigurationInput
	Copy  func(*GetConfigurationInput) GetConfigurationRequest
}

// Send marshals and sends the GetConfiguration API request.
func (r GetConfigurationRequest) Send(ctx context.Context) (*GetConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetConfigurationResponse{
		GetConfigurationOutput: r.Request.Data.(*GetConfigurationOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetConfigurationResponse is the response type for the
// GetConfiguration API operation.
type GetConfigurationResponse struct {
	*GetConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetConfiguration request.
func (r *GetConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
