// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appconfig

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetDeploymentStrategyInput struct {
	_ struct{} `type:"structure"`

	// The ID of the deployment strategy to get.
	//
	// DeploymentStrategyId is a required field
	DeploymentStrategyId *string `location:"uri" locationName:"DeploymentStrategyId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDeploymentStrategyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeploymentStrategyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetDeploymentStrategyInput"}

	if s.DeploymentStrategyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeploymentStrategyId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetDeploymentStrategyInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DeploymentStrategyId != nil {
		v := *s.DeploymentStrategyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "DeploymentStrategyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetDeploymentStrategyOutput struct {
	_ struct{} `type:"structure"`

	// Total amount of time the deployment lasted.
	DeploymentDurationInMinutes *int64 `type:"integer"`

	// The description of the deployment strategy.
	Description *string `type:"string"`

	// The amount of time AppConfig monitored for alarms before considering the
	// deployment to be complete and no longer eligible for automatic roll back.
	FinalBakeTimeInMinutes *int64 `type:"integer"`

	// The percentage of targets that received a deployed configuration during each
	// interval.
	GrowthFactor *float64 `min:"1" type:"float"`

	// The algorithm used to define how percentage grew over time.
	GrowthType GrowthType `type:"string" enum:"true"`

	// The deployment strategy ID.
	Id *string `type:"string"`

	// The name of the deployment strategy.
	Name *string `min:"1" type:"string"`

	// Save the deployment strategy to a Systems Manager (SSM) document.
	ReplicateTo ReplicateTo `type:"string" enum:"true"`
}

// String returns the string representation
func (s GetDeploymentStrategyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetDeploymentStrategyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DeploymentDurationInMinutes != nil {
		v := *s.DeploymentDurationInMinutes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeploymentDurationInMinutes", protocol.Int64Value(v), metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FinalBakeTimeInMinutes != nil {
		v := *s.FinalBakeTimeInMinutes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FinalBakeTimeInMinutes", protocol.Int64Value(v), metadata)
	}
	if s.GrowthFactor != nil {
		v := *s.GrowthFactor

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GrowthFactor", protocol.Float64Value(v), metadata)
	}
	if len(s.GrowthType) > 0 {
		v := s.GrowthType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GrowthType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ReplicateTo) > 0 {
		v := s.ReplicateTo

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ReplicateTo", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

const opGetDeploymentStrategy = "GetDeploymentStrategy"

// GetDeploymentStrategyRequest returns a request value for making API operation for
// Amazon AppConfig.
//
// Retrieve information about a deployment strategy. A deployment strategy defines
// important criteria for rolling out your configuration to the designated targets.
// A deployment strategy includes: the overall duration required, a percentage
// of targets to receive the deployment during each interval, an algorithm that
// defines how percentage grows, and bake time.
//
//    // Example sending a request using GetDeploymentStrategyRequest.
//    req := client.GetDeploymentStrategyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/GetDeploymentStrategy
func (c *Client) GetDeploymentStrategyRequest(input *GetDeploymentStrategyInput) GetDeploymentStrategyRequest {
	op := &aws.Operation{
		Name:       opGetDeploymentStrategy,
		HTTPMethod: "GET",
		HTTPPath:   "/deploymentstrategies/{DeploymentStrategyId}",
	}

	if input == nil {
		input = &GetDeploymentStrategyInput{}
	}

	req := c.newRequest(op, input, &GetDeploymentStrategyOutput{})

	return GetDeploymentStrategyRequest{Request: req, Input: input, Copy: c.GetDeploymentStrategyRequest}
}

// GetDeploymentStrategyRequest is the request type for the
// GetDeploymentStrategy API operation.
type GetDeploymentStrategyRequest struct {
	*aws.Request
	Input *GetDeploymentStrategyInput
	Copy  func(*GetDeploymentStrategyInput) GetDeploymentStrategyRequest
}

// Send marshals and sends the GetDeploymentStrategy API request.
func (r GetDeploymentStrategyRequest) Send(ctx context.Context) (*GetDeploymentStrategyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetDeploymentStrategyResponse{
		GetDeploymentStrategyOutput: r.Request.Data.(*GetDeploymentStrategyOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetDeploymentStrategyResponse is the response type for the
// GetDeploymentStrategy API operation.
type GetDeploymentStrategyResponse struct {
	*GetDeploymentStrategyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetDeploymentStrategy request.
func (r *GetDeploymentStrategyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
