// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appconfig

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type StartDeploymentInput struct {
	_ struct{} `type:"structure"`

	// The application ID.
	//
	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"ApplicationId" type:"string" required:"true"`

	// The configuration profile ID.
	//
	// ConfigurationProfileId is a required field
	ConfigurationProfileId *string `type:"string" required:"true"`

	// The configuration version to deploy.
	//
	// ConfigurationVersion is a required field
	ConfigurationVersion *string `min:"1" type:"string" required:"true"`

	// The deployment strategy ID.
	//
	// DeploymentStrategyId is a required field
	DeploymentStrategyId *string `type:"string" required:"true"`

	// A description of the deployment.
	Description *string `type:"string"`

	// The environment ID.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `location:"uri" locationName:"EnvironmentId" type:"string" required:"true"`

	// Metadata to assign to the deployment. Tags help organize and categorize your
	// AppConfig resources. Each tag consists of a key and an optional value, both
	// of which you define.
	Tags map[string]string `type:"map"`
}

// String returns the string representation
func (s StartDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartDeploymentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartDeploymentInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if s.ConfigurationProfileId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConfigurationProfileId"))
	}

	if s.ConfigurationVersion == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConfigurationVersion"))
	}
	if s.ConfigurationVersion != nil && len(*s.ConfigurationVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ConfigurationVersion", 1))
	}

	if s.DeploymentStrategyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeploymentStrategyId"))
	}

	if s.EnvironmentId == nil {
		invalidParams.Add(aws.NewErrParamRequired("EnvironmentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StartDeploymentInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ConfigurationProfileId != nil {
		v := *s.ConfigurationProfileId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ConfigurationProfileId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ConfigurationVersion != nil {
		v := *s.ConfigurationVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ConfigurationVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DeploymentStrategyId != nil {
		v := *s.DeploymentStrategyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeploymentStrategyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EnvironmentId != nil {
		v := *s.EnvironmentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "EnvironmentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type StartDeploymentOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the application that was deployed.
	ApplicationId *string `type:"string"`

	// The time the deployment completed.
	CompletedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Information about the source location of the configuration.
	ConfigurationLocationUri *string `min:"1" type:"string"`

	// The name of the configuration.
	ConfigurationName *string `min:"1" type:"string"`

	// The ID of the configuration profile that was deployed.
	ConfigurationProfileId *string `type:"string"`

	// The configuration version that was deployed.
	ConfigurationVersion *string `min:"1" type:"string"`

	// Total amount of time the deployment lasted.
	DeploymentDurationInMinutes *int64 `type:"integer"`

	// The sequence number of the deployment.
	DeploymentNumber *int64 `type:"integer"`

	// The ID of the deployment strategy that was deployed.
	DeploymentStrategyId *string `type:"string"`

	// The description of the deployment.
	Description *string `type:"string"`

	// The ID of the environment that was deployed.
	EnvironmentId *string `type:"string"`

	// A list containing all events related to a deployment. The most recent events
	// are displayed first.
	EventLog []DeploymentEvent `type:"list"`

	// The amount of time AppConfig monitored for alarms before considering the
	// deployment to be complete and no longer eligible for automatic roll back.
	FinalBakeTimeInMinutes *int64 `type:"integer"`

	// The percentage of targets to receive a deployed configuration during each
	// interval.
	GrowthFactor *float64 `min:"1" type:"float"`

	// The algorithm used to define how percentage grew over time.
	GrowthType GrowthType `type:"string" enum:"true"`

	// The percentage of targets for which the deployment is available.
	PercentageComplete *float64 `min:"1" type:"float"`

	// The time the deployment started.
	StartedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The state of the deployment.
	State DeploymentState `type:"string" enum:"true"`
}

// String returns the string representation
func (s StartDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StartDeploymentOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ApplicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CompletedAt != nil {
		v := *s.CompletedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CompletedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if s.ConfigurationLocationUri != nil {
		v := *s.ConfigurationLocationUri

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ConfigurationLocationUri", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ConfigurationName != nil {
		v := *s.ConfigurationName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ConfigurationName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ConfigurationProfileId != nil {
		v := *s.ConfigurationProfileId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ConfigurationProfileId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ConfigurationVersion != nil {
		v := *s.ConfigurationVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ConfigurationVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DeploymentDurationInMinutes != nil {
		v := *s.DeploymentDurationInMinutes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeploymentDurationInMinutes", protocol.Int64Value(v), metadata)
	}
	if s.DeploymentNumber != nil {
		v := *s.DeploymentNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeploymentNumber", protocol.Int64Value(v), metadata)
	}
	if s.DeploymentStrategyId != nil {
		v := *s.DeploymentStrategyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeploymentStrategyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EnvironmentId != nil {
		v := *s.EnvironmentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EnvironmentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EventLog != nil {
		v := s.EventLog

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "EventLog", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.FinalBakeTimeInMinutes != nil {
		v := *s.FinalBakeTimeInMinutes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FinalBakeTimeInMinutes", protocol.Int64Value(v), metadata)
	}
	if s.GrowthFactor != nil {
		v := *s.GrowthFactor

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GrowthFactor", protocol.Float64Value(v), metadata)
	}
	if len(s.GrowthType) > 0 {
		v := s.GrowthType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GrowthType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.PercentageComplete != nil {
		v := *s.PercentageComplete

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PercentageComplete", protocol.Float64Value(v), metadata)
	}
	if s.StartedAt != nil {
		v := *s.StartedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartedAt",
			protocol.TimeValue{V: v, Format: "iso8601", QuotedFormatTime: true}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

const opStartDeployment = "StartDeployment"

// StartDeploymentRequest returns a request value for making API operation for
// Amazon AppConfig.
//
// Starts a deployment.
//
//    // Example sending a request using StartDeploymentRequest.
//    req := client.StartDeploymentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appconfig-2019-10-09/StartDeployment
func (c *Client) StartDeploymentRequest(input *StartDeploymentInput) StartDeploymentRequest {
	op := &aws.Operation{
		Name:       opStartDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/applications/{ApplicationId}/environments/{EnvironmentId}/deployments",
	}

	if input == nil {
		input = &StartDeploymentInput{}
	}

	req := c.newRequest(op, input, &StartDeploymentOutput{})

	return StartDeploymentRequest{Request: req, Input: input, Copy: c.StartDeploymentRequest}
}

// StartDeploymentRequest is the request type for the
// StartDeployment API operation.
type StartDeploymentRequest struct {
	*aws.Request
	Input *StartDeploymentInput
	Copy  func(*StartDeploymentInput) StartDeploymentRequest
}

// Send marshals and sends the StartDeployment API request.
func (r StartDeploymentRequest) Send(ctx context.Context) (*StartDeploymentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartDeploymentResponse{
		StartDeploymentOutput: r.Request.Data.(*StartDeploymentOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartDeploymentResponse is the response type for the
// StartDeployment API operation.
type StartDeploymentResponse struct {
	*StartDeploymentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartDeployment request.
func (r *StartDeploymentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
