// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package applicationdiscoveryservice

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeImportTasksInput struct {
	_ struct{} `type:"structure"`

	// An array of name-value pairs that you provide to filter the results for the
	// DescribeImportTask request to a specific subset of results. Currently, wildcard
	// values aren't supported for filters.
	Filters []ImportTaskFilter `locationName:"filters" type:"list"`

	// The maximum number of results that you want this request to return, up to
	// 100.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token to request a specific page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeImportTasksInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeImportTasksInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeImportTasksInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeImportTasksOutput struct {
	_ struct{} `type:"structure"`

	// The token to request the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A returned array of import tasks that match any applied filters, up to the
	// specified number of maximum results.
	Tasks []ImportTask `locationName:"tasks" type:"list"`
}

// String returns the string representation
func (s DescribeImportTasksOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeImportTasks = "DescribeImportTasks"

// DescribeImportTasksRequest returns a request value for making API operation for
// AWS Application Discovery Service.
//
// Returns an array of import tasks for your account, including status information,
// times, IDs, the Amazon S3 Object URL for the import file, and more.
//
//    // Example sending a request using DescribeImportTasksRequest.
//    req := client.DescribeImportTasksRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DescribeImportTasks
func (c *Client) DescribeImportTasksRequest(input *DescribeImportTasksInput) DescribeImportTasksRequest {
	op := &aws.Operation{
		Name:       opDescribeImportTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeImportTasksInput{}
	}

	req := c.newRequest(op, input, &DescribeImportTasksOutput{})

	return DescribeImportTasksRequest{Request: req, Input: input, Copy: c.DescribeImportTasksRequest}
}

// DescribeImportTasksRequest is the request type for the
// DescribeImportTasks API operation.
type DescribeImportTasksRequest struct {
	*aws.Request
	Input *DescribeImportTasksInput
	Copy  func(*DescribeImportTasksInput) DescribeImportTasksRequest
}

// Send marshals and sends the DescribeImportTasks API request.
func (r DescribeImportTasksRequest) Send(ctx context.Context) (*DescribeImportTasksResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeImportTasksResponse{
		DescribeImportTasksOutput: r.Request.Data.(*DescribeImportTasksOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeImportTasksRequestPaginator returns a paginator for DescribeImportTasks.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeImportTasksRequest(input)
//   p := applicationdiscoveryservice.NewDescribeImportTasksRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeImportTasksPaginator(req DescribeImportTasksRequest) DescribeImportTasksPaginator {
	return DescribeImportTasksPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeImportTasksInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeImportTasksPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeImportTasksPaginator struct {
	aws.Pager
}

func (p *DescribeImportTasksPaginator) CurrentPage() *DescribeImportTasksOutput {
	return p.Pager.CurrentPage().(*DescribeImportTasksOutput)
}

// DescribeImportTasksResponse is the response type for the
// DescribeImportTasks API operation.
type DescribeImportTasksResponse struct {
	*DescribeImportTasksOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeImportTasks request.
func (r *DescribeImportTasksResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
