// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package applicationdiscoveryservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DisassociateConfigurationItemsFromApplicationInput struct {
	_ struct{} `type:"structure"`

	// Configuration ID of an application from which each item is disassociated.
	//
	// ApplicationConfigurationId is a required field
	ApplicationConfigurationId *string `locationName:"applicationConfigurationId" type:"string" required:"true"`

	// Configuration ID of each item to be disassociated from an application.
	//
	// ConfigurationIds is a required field
	ConfigurationIds []string `locationName:"configurationIds" type:"list" required:"true"`
}

// String returns the string representation
func (s DisassociateConfigurationItemsFromApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateConfigurationItemsFromApplicationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisassociateConfigurationItemsFromApplicationInput"}

	if s.ApplicationConfigurationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationConfigurationId"))
	}

	if s.ConfigurationIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConfigurationIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DisassociateConfigurationItemsFromApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateConfigurationItemsFromApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisassociateConfigurationItemsFromApplication = "DisassociateConfigurationItemsFromApplication"

// DisassociateConfigurationItemsFromApplicationRequest returns a request value for making API operation for
// AWS Application Discovery Service.
//
// Disassociates one or more configuration items from an application.
//
//    // Example sending a request using DisassociateConfigurationItemsFromApplicationRequest.
//    req := client.DisassociateConfigurationItemsFromApplicationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DisassociateConfigurationItemsFromApplication
func (c *Client) DisassociateConfigurationItemsFromApplicationRequest(input *DisassociateConfigurationItemsFromApplicationInput) DisassociateConfigurationItemsFromApplicationRequest {
	op := &aws.Operation{
		Name:       opDisassociateConfigurationItemsFromApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateConfigurationItemsFromApplicationInput{}
	}

	req := c.newRequest(op, input, &DisassociateConfigurationItemsFromApplicationOutput{})

	return DisassociateConfigurationItemsFromApplicationRequest{Request: req, Input: input, Copy: c.DisassociateConfigurationItemsFromApplicationRequest}
}

// DisassociateConfigurationItemsFromApplicationRequest is the request type for the
// DisassociateConfigurationItemsFromApplication API operation.
type DisassociateConfigurationItemsFromApplicationRequest struct {
	*aws.Request
	Input *DisassociateConfigurationItemsFromApplicationInput
	Copy  func(*DisassociateConfigurationItemsFromApplicationInput) DisassociateConfigurationItemsFromApplicationRequest
}

// Send marshals and sends the DisassociateConfigurationItemsFromApplication API request.
func (r DisassociateConfigurationItemsFromApplicationRequest) Send(ctx context.Context) (*DisassociateConfigurationItemsFromApplicationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisassociateConfigurationItemsFromApplicationResponse{
		DisassociateConfigurationItemsFromApplicationOutput: r.Request.Data.(*DisassociateConfigurationItemsFromApplicationOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisassociateConfigurationItemsFromApplicationResponse is the response type for the
// DisassociateConfigurationItemsFromApplication API operation.
type DisassociateConfigurationItemsFromApplicationResponse struct {
	*DisassociateConfigurationItemsFromApplicationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisassociateConfigurationItemsFromApplication request.
func (r *DisassociateConfigurationItemsFromApplicationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
