// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package applicationinsights

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateComponentInput struct {
	_ struct{} `type:"structure"`

	// The name of the component.
	//
	// ComponentName is a required field
	ComponentName *string `type:"string" required:"true"`

	// The name of the resource group.
	//
	// ResourceGroupName is a required field
	ResourceGroupName *string `min:"1" type:"string" required:"true"`

	// The list of resource ARNs that belong to the component.
	//
	// ResourceList is a required field
	ResourceList []string `type:"list" required:"true"`
}

// String returns the string representation
func (s CreateComponentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateComponentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateComponentInput"}

	if s.ComponentName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ComponentName"))
	}

	if s.ResourceGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceGroupName"))
	}
	if s.ResourceGroupName != nil && len(*s.ResourceGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceGroupName", 1))
	}

	if s.ResourceList == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateComponentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateComponentOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateComponent = "CreateComponent"

// CreateComponentRequest returns a request value for making API operation for
// Amazon CloudWatch Application Insights.
//
// Creates a custom component by grouping similar standalone instances to monitor.
//
//    // Example sending a request using CreateComponentRequest.
//    req := client.CreateComponentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/CreateComponent
func (c *Client) CreateComponentRequest(input *CreateComponentInput) CreateComponentRequest {
	op := &aws.Operation{
		Name:       opCreateComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateComponentInput{}
	}

	req := c.newRequest(op, input, &CreateComponentOutput{})

	return CreateComponentRequest{Request: req, Input: input, Copy: c.CreateComponentRequest}
}

// CreateComponentRequest is the request type for the
// CreateComponent API operation.
type CreateComponentRequest struct {
	*aws.Request
	Input *CreateComponentInput
	Copy  func(*CreateComponentInput) CreateComponentRequest
}

// Send marshals and sends the CreateComponent API request.
func (r CreateComponentRequest) Send(ctx context.Context) (*CreateComponentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateComponentResponse{
		CreateComponentOutput: r.Request.Data.(*CreateComponentOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateComponentResponse is the response type for the
// CreateComponent API operation.
type CreateComponentResponse struct {
	*CreateComponentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateComponent request.
func (r *CreateComponentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
