// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package applicationinsights

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeProblemInput struct {
	_ struct{} `type:"structure"`

	// The ID of the problem.
	//
	// ProblemId is a required field
	ProblemId *string `min:"38" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeProblemInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProblemInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeProblemInput"}

	if s.ProblemId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProblemId"))
	}
	if s.ProblemId != nil && len(*s.ProblemId) < 38 {
		invalidParams.Add(aws.NewErrParamMinLen("ProblemId", 38))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeProblemOutput struct {
	_ struct{} `type:"structure"`

	// Information about the problem.
	Problem *Problem `type:"structure"`
}

// String returns the string representation
func (s DescribeProblemOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeProblem = "DescribeProblem"

// DescribeProblemRequest returns a request value for making API operation for
// Amazon CloudWatch Application Insights.
//
// Describes an application problem.
//
//    // Example sending a request using DescribeProblemRequest.
//    req := client.DescribeProblemRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/DescribeProblem
func (c *Client) DescribeProblemRequest(input *DescribeProblemInput) DescribeProblemRequest {
	op := &aws.Operation{
		Name:       opDescribeProblem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeProblemInput{}
	}

	req := c.newRequest(op, input, &DescribeProblemOutput{})

	return DescribeProblemRequest{Request: req, Input: input, Copy: c.DescribeProblemRequest}
}

// DescribeProblemRequest is the request type for the
// DescribeProblem API operation.
type DescribeProblemRequest struct {
	*aws.Request
	Input *DescribeProblemInput
	Copy  func(*DescribeProblemInput) DescribeProblemRequest
}

// Send marshals and sends the DescribeProblem API request.
func (r DescribeProblemRequest) Send(ctx context.Context) (*DescribeProblemResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeProblemResponse{
		DescribeProblemOutput: r.Request.Data.(*DescribeProblemOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeProblemResponse is the response type for the
// DescribeProblem API operation.
type DescribeProblemResponse struct {
	*DescribeProblemOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeProblem request.
func (r *DescribeProblemResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
