// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package applicationinsights

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListConfigurationHistoryInput struct {
	_ struct{} `type:"structure"`

	// The end time of the event.
	EndTime *time.Time `type:"timestamp"`

	// The status of the configuration update event. Possible values include INFO,
	// WARN, and ERROR.
	EventStatus ConfigurationEventStatus `type:"string" enum:"true"`

	// The maximum number of results returned by ListConfigurationHistory in paginated
	// output. When this parameter is used, ListConfigurationHistory returns only
	// MaxResults in a single page along with a NextToken response element. The
	// remaining results of the initial request can be seen by sending another ListConfigurationHistory
	// request with the returned NextToken value. If this parameter is not used,
	// then ListConfigurationHistory returns all results.
	MaxResults *int64 `min:"1" type:"integer"`

	// The NextToken value returned from a previous paginated ListConfigurationHistory
	// request where MaxResults was used and the results exceeded the value of that
	// parameter. Pagination continues from the end of the previous results that
	// returned the NextToken value. This value is null when there are no more results
	// to return.
	NextToken *string `type:"string"`

	// Resource group to which the application belongs.
	ResourceGroupName *string `min:"1" type:"string"`

	// The start time of the event.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s ListConfigurationHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListConfigurationHistoryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListConfigurationHistoryInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceGroupName != nil && len(*s.ResourceGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListConfigurationHistoryOutput struct {
	_ struct{} `type:"structure"`

	// The list of configuration events and their corresponding details.
	EventList []ConfigurationEvent `type:"list"`

	// The NextToken value to include in a future ListConfigurationHistory request.
	// When the results of a ListConfigurationHistory request exceed MaxResults,
	// this value can be used to retrieve the next page of results. This value is
	// null when there are no more results to return.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListConfigurationHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

const opListConfigurationHistory = "ListConfigurationHistory"

// ListConfigurationHistoryRequest returns a request value for making API operation for
// Amazon CloudWatch Application Insights.
//
// Lists the INFO, WARN, and ERROR events for periodic configuration updates
// performed by Application Insights. Examples of events represented are:
//
//    * INFO: creating a new alarm or updating an alarm threshold.
//
//    * WARN: alarm not created due to insufficient data points used to predict
//    thresholds.
//
//    * ERROR: alarm not created due to permission errors or exceeding quotas.
//
//    // Example sending a request using ListConfigurationHistoryRequest.
//    req := client.ListConfigurationHistoryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/application-insights-2018-11-25/ListConfigurationHistory
func (c *Client) ListConfigurationHistoryRequest(input *ListConfigurationHistoryInput) ListConfigurationHistoryRequest {
	op := &aws.Operation{
		Name:       opListConfigurationHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListConfigurationHistoryInput{}
	}

	req := c.newRequest(op, input, &ListConfigurationHistoryOutput{})

	return ListConfigurationHistoryRequest{Request: req, Input: input, Copy: c.ListConfigurationHistoryRequest}
}

// ListConfigurationHistoryRequest is the request type for the
// ListConfigurationHistory API operation.
type ListConfigurationHistoryRequest struct {
	*aws.Request
	Input *ListConfigurationHistoryInput
	Copy  func(*ListConfigurationHistoryInput) ListConfigurationHistoryRequest
}

// Send marshals and sends the ListConfigurationHistory API request.
func (r ListConfigurationHistoryRequest) Send(ctx context.Context) (*ListConfigurationHistoryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListConfigurationHistoryResponse{
		ListConfigurationHistoryOutput: r.Request.Data.(*ListConfigurationHistoryOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListConfigurationHistoryRequestPaginator returns a paginator for ListConfigurationHistory.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListConfigurationHistoryRequest(input)
//   p := applicationinsights.NewListConfigurationHistoryRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListConfigurationHistoryPaginator(req ListConfigurationHistoryRequest) ListConfigurationHistoryPaginator {
	return ListConfigurationHistoryPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListConfigurationHistoryInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListConfigurationHistoryPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListConfigurationHistoryPaginator struct {
	aws.Pager
}

func (p *ListConfigurationHistoryPaginator) CurrentPage() *ListConfigurationHistoryOutput {
	return p.Pager.CurrentPage().(*ListConfigurationHistoryOutput)
}

// ListConfigurationHistoryResponse is the response type for the
// ListConfigurationHistory API operation.
type ListConfigurationHistoryResponse struct {
	*ListConfigurationHistoryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListConfigurationHistory request.
func (r *ListConfigurationHistoryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
