// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package applicationinsights

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Describes a standalone resource or similarly grouped resources that the application
// is made up of.
type ApplicationComponent struct {
	_ struct{} `type:"structure"`

	// The name of the component.
	ComponentName *string `type:"string"`

	// Indicates whether the application component is monitored.
	Monitor *bool `type:"boolean"`

	// The resource type. Supported resource types include EC2 instances, Auto Scaling
	// group, Classic ELB, Application ELB, and SQS Queue.
	ResourceType *string `type:"string"`

	// The stack tier of the application component.
	Tier Tier `min:"1" type:"string" enum:"true"`
}

// String returns the string representation
func (s ApplicationComponent) String() string {
	return awsutil.Prettify(s)
}

// Describes the status of the application.
type ApplicationInfo struct {
	_ struct{} `type:"structure"`

	// Indicates whether Application Insights can listen to CloudWatch events for
	// the application resources, such as instance terminated, failed deployment,
	// and others.
	CWEMonitorEnabled *bool `type:"boolean"`

	// The lifecycle of the application.
	LifeCycle *string `type:"string"`

	// Indicates whether Application Insights will create opsItems for any problem
	// detected by Application Insights for an application.
	OpsCenterEnabled *bool `type:"boolean"`

	// The SNS topic provided to Application Insights that is associated to the
	// created opsItems to receive SNS notifications for opsItem updates.
	OpsItemSNSTopicArn *string `min:"20" type:"string"`

	// The issues on the user side that block Application Insights from successfully
	// monitoring an application. Example remarks include:
	//
	//    * “Configuring application, detected 1 Errors, 3 Warnings”
	//
	//    * “Configuring application, detected 1 Unconfigured Components”
	Remarks *string `type:"string"`

	// The name of the resource group used for the application.
	ResourceGroupName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ApplicationInfo) String() string {
	return awsutil.Prettify(s)
}

// The event information.
type ConfigurationEvent struct {
	_ struct{} `type:"structure"`

	// The details of the event in plain text.
	EventDetail *string `type:"string"`

	// The name of the resource Application Insights attempted to configure.
	EventResourceName *string `type:"string"`

	// The resource type that Application Insights attempted to configure, for example,
	// CLOUDWATCH_ALARM.
	EventResourceType ConfigurationEventResourceType `type:"string" enum:"true"`

	// The status of the configuration update event. Possible values include INFO,
	// WARN, and ERROR.
	EventStatus ConfigurationEventStatus `type:"string" enum:"true"`

	// The timestamp of the event.
	EventTime *time.Time `type:"timestamp"`

	// The resource monitored by Application Insights.
	MonitoredResourceARN *string `type:"string"`
}

// String returns the string representation
func (s ConfigurationEvent) String() string {
	return awsutil.Prettify(s)
}

// An object that defines the log patterns that belongs to a LogPatternSet.
type LogPattern struct {
	_ struct{} `type:"structure"`

	// A regular expression that defines the log pattern. A log pattern can contains
	// at many as 50 characters, and it cannot be empty.
	Pattern *string `min:"1" type:"string"`

	// The name of the log pattern. A log pattern name can contains at many as 50
	// characters, and it cannot be empty. The characters can be Unicode letters,
	// digits or one of the following symbols: period, dash, underscore.
	PatternName *string `min:"1" type:"string"`

	// The name of the log pattern. A log pattern name can contains at many as 30
	// characters, and it cannot be empty. The characters can be Unicode letters,
	// digits or one of the following symbols: period, dash, underscore.
	PatternSetName *string `min:"1" type:"string"`

	// Rank of the log pattern.
	Rank *int64 `type:"integer"`
}

// String returns the string representation
func (s LogPattern) String() string {
	return awsutil.Prettify(s)
}

// Describes an anomaly or error with the application.
type Observation struct {
	_ struct{} `type:"structure"`

	// The detail type of the CloudWatch Event-based observation, for example, EC2
	// Instance State-change Notification.
	CloudWatchEventDetailType *string `type:"string"`

	// The ID of the CloudWatch Event-based observation related to the detected
	// problem.
	CloudWatchEventId *string `type:"string"`

	// The source of the CloudWatch Event.
	CloudWatchEventSource CloudWatchEventSource `type:"string" enum:"true"`

	// The CodeDeploy application to which the deployment belongs.
	CodeDeployApplication *string `type:"string"`

	// The deployment group to which the CodeDeploy deployment belongs.
	CodeDeployDeploymentGroup *string `type:"string"`

	// The deployment ID of the CodeDeploy-based observation related to the detected
	// problem.
	CodeDeployDeploymentId *string `type:"string"`

	// The instance group to which the CodeDeploy instance belongs.
	CodeDeployInstanceGroupId *string `type:"string"`

	// The status of the CodeDeploy deployment, for example SUCCESS or FAILURE.
	CodeDeployState *string `type:"string"`

	// The state of the instance, such as STOPPING or TERMINATING.
	Ec2State *string `type:"string"`

	// The time when the observation ended, in epoch seconds.
	EndTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the AWS Health Event-based observation.
	HealthEventArn *string `type:"string"`

	// The description of the AWS Health event provided by the service, such as
	// Amazon EC2.
	HealthEventDescription *string `type:"string"`

	// The category of the AWS Health event, such as issue.
	HealthEventTypeCategory *string `type:"string"`

	// The type of the AWS Health event, for example, AWS_EC2_POWER_CONNECTIVITY_ISSUE.
	HealthEventTypeCode *string `type:"string"`

	// The service to which the AWS Health Event belongs, such as EC2.
	HealthService *string `type:"string"`

	// The ID of the observation type.
	Id *string `min:"38" type:"string"`

	// The timestamp in the CloudWatch Logs that specifies when the matched line
	// occurred.
	LineTime *time.Time `type:"timestamp"`

	// The log filter of the observation.
	LogFilter LogFilter `type:"string" enum:"true"`

	// The log group name.
	LogGroup *string `type:"string"`

	// The log text of the observation.
	LogText *string `type:"string"`

	// The name of the observation metric.
	MetricName *string `type:"string"`

	// The namespace of the observation metric.
	MetricNamespace *string `type:"string"`

	// The source resource ARN of the observation.
	SourceARN *string `type:"string"`

	// The source type of the observation.
	SourceType *string `type:"string"`

	// The time when the observation was first detected, in epoch seconds.
	StartTime *time.Time `type:"timestamp"`

	// The unit of the source observation metric.
	Unit *string `type:"string"`

	// The value of the source observation metric.
	Value *float64 `type:"double"`

	// The X-Ray request error percentage for this node.
	XRayErrorPercent *int64 `type:"integer"`

	// The X-Ray request fault percentage for this node.
	XRayFaultPercent *int64 `type:"integer"`

	// The name of the X-Ray node.
	XRayNodeName *string `type:"string"`

	// The type of the X-Ray node.
	XRayNodeType *string `type:"string"`

	// The X-Ray node request average latency for this node.
	XRayRequestAverageLatency *int64 `type:"long"`

	// The X-Ray request count for this node.
	XRayRequestCount *int64 `type:"integer"`

	// The X-Ray request throttle percentage for this node.
	XRayThrottlePercent *int64 `type:"integer"`
}

// String returns the string representation
func (s Observation) String() string {
	return awsutil.Prettify(s)
}

// Describes a problem that is detected by correlating observations.
type Problem struct {
	_ struct{} `type:"structure"`

	// The resource affected by the problem.
	AffectedResource *string `type:"string"`

	// The time when the problem ended, in epoch seconds.
	EndTime *time.Time `type:"timestamp"`

	// Feedback provided by the user about the problem.
	Feedback map[string]FeedbackValue `type:"map"`

	// The ID of the problem.
	Id *string `min:"38" type:"string"`

	// A detailed analysis of the problem using machine learning.
	Insights *string `type:"string"`

	// The name of the resource group affected by the problem.
	ResourceGroupName *string `min:"1" type:"string"`

	// A measure of the level of impact of the problem.
	SeverityLevel SeverityLevel `type:"string" enum:"true"`

	// The time when the problem started, in epoch seconds.
	StartTime *time.Time `type:"timestamp"`

	// The status of the problem.
	Status Status `type:"string" enum:"true"`

	// The name of the problem.
	Title *string `type:"string"`
}

// String returns the string representation
func (s Problem) String() string {
	return awsutil.Prettify(s)
}

// Describes observations related to the problem.
type RelatedObservations struct {
	_ struct{} `type:"structure"`

	// The list of observations related to the problem.
	ObservationList []Observation `type:"list"`
}

// String returns the string representation
func (s RelatedObservations) String() string {
	return awsutil.Prettify(s)
}

// An object that defines the tags associated with an application. A tag is
// a label that you optionally define and associate with an application. Tags
// can help you categorize and manage resources in different ways, such as by
// purpose, owner, environment, or other criteria.
//
// Each tag consists of a required tag key and an associated tag value, both
// of which you define. A tag key is a general label that acts as a category
// for a more specific tag value. A tag value acts as a descriptor within a
// tag key. A tag key can contain as many as 128 characters. A tag value can
// contain as many as 256 characters. The characters can be Unicode letters,
// digits, white space, or one of the following symbols: _ . : / = + -. The
// following additional restrictions apply to tags:
//
//    * Tag keys and values are case sensitive.
//
//    * For each associated resource, each tag key must be unique and it can
//    have only one value.
//
//    * The aws: prefix is reserved for use by AWS; you can’t use it in any
//    tag keys or values that you define. In addition, you can't edit or remove
//    tag keys or values that use this prefix.
type Tag struct {
	_ struct{} `type:"structure"`

	// One part of a key-value pair that defines a tag. The maximum length of a
	// tag key is 128 characters. The minimum length is 1 character.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The optional part of a key-value pair that defines a tag. The maximum length
	// of a tag value is 256 characters. The minimum length is 0 characters. If
	// you don't want an application to have a specific tag value, don't specify
	// a value for this parameter.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}
