// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appmesh

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateGatewayRouteInput struct {
	_ struct{} `type:"structure"`

	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// GatewayRouteName is a required field
	GatewayRouteName *string `locationName:"gatewayRouteName" min:"1" type:"string" required:"true"`

	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// An object that represents a gateway route specification. Specify one gateway
	// route type.
	//
	// Spec is a required field
	Spec *GatewayRouteSpec `locationName:"spec" type:"structure" required:"true"`

	Tags []TagRef `locationName:"tags" type:"list"`

	// VirtualGatewayName is a required field
	VirtualGatewayName *string `location:"uri" locationName:"virtualGatewayName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateGatewayRouteInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGatewayRouteInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateGatewayRouteInput"}

	if s.GatewayRouteName == nil {
		invalidParams.Add(aws.NewErrParamRequired("GatewayRouteName"))
	}
	if s.GatewayRouteName != nil && len(*s.GatewayRouteName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GatewayRouteName", 1))
	}

	if s.MeshName == nil {
		invalidParams.Add(aws.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("MeshOwner", 12))
	}

	if s.Spec == nil {
		invalidParams.Add(aws.NewErrParamRequired("Spec"))
	}

	if s.VirtualGatewayName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VirtualGatewayName"))
	}
	if s.VirtualGatewayName != nil && len(*s.VirtualGatewayName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VirtualGatewayName", 1))
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateGatewayRouteInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GatewayRouteName != nil {
		v := *s.GatewayRouteName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "gatewayRouteName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Spec != nil {
		v := s.Spec

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "spec", v, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "tags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.MeshName != nil {
		v := *s.MeshName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "meshName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VirtualGatewayName != nil {
		v := *s.VirtualGatewayName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "virtualGatewayName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MeshOwner != nil {
		v := *s.MeshOwner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "meshOwner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CreateGatewayRouteOutput struct {
	_ struct{} `type:"structure" payload:"GatewayRoute"`

	// An object that represents a gateway route returned by a describe operation.
	//
	// GatewayRoute is a required field
	GatewayRoute *GatewayRouteData `locationName:"gatewayRoute" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateGatewayRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateGatewayRouteOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.GatewayRoute != nil {
		v := s.GatewayRoute

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "gatewayRoute", v, metadata)
	}
	return nil
}

const opCreateGatewayRoute = "CreateGatewayRoute"

// CreateGatewayRouteRequest returns a request value for making API operation for
// AWS App Mesh.
//
// Creates a gateway route.
//
// A gateway route is attached to a virtual gateway and routes traffic to an
// existing virtual service. If a route matches a request, it can distribute
// traffic to a target virtual service.
//
// For more information about gateway routes, see Gateway routes (https://docs.aws.amazon.com/app-mesh/latest/userguide/gateway-routes.html).
//
//    // Example sending a request using CreateGatewayRouteRequest.
//    req := client.CreateGatewayRouteRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateGatewayRoute
func (c *Client) CreateGatewayRouteRequest(input *CreateGatewayRouteInput) CreateGatewayRouteRequest {
	op := &aws.Operation{
		Name:       opCreateGatewayRoute,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualGateway/{virtualGatewayName}/gatewayRoutes",
	}

	if input == nil {
		input = &CreateGatewayRouteInput{}
	}

	req := c.newRequest(op, input, &CreateGatewayRouteOutput{})

	return CreateGatewayRouteRequest{Request: req, Input: input, Copy: c.CreateGatewayRouteRequest}
}

// CreateGatewayRouteRequest is the request type for the
// CreateGatewayRoute API operation.
type CreateGatewayRouteRequest struct {
	*aws.Request
	Input *CreateGatewayRouteInput
	Copy  func(*CreateGatewayRouteInput) CreateGatewayRouteRequest
}

// Send marshals and sends the CreateGatewayRoute API request.
func (r CreateGatewayRouteRequest) Send(ctx context.Context) (*CreateGatewayRouteResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateGatewayRouteResponse{
		CreateGatewayRouteOutput: r.Request.Data.(*CreateGatewayRouteOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateGatewayRouteResponse is the response type for the
// CreateGatewayRoute API operation.
type CreateGatewayRouteResponse struct {
	*CreateGatewayRouteOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateGatewayRoute request.
func (r *CreateGatewayRouteResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
