// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appmesh

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateVirtualGatewayInput struct {
	_ struct{} `type:"structure"`

	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// An object that represents the specification of a service mesh resource.
	//
	// Spec is a required field
	Spec *VirtualGatewaySpec `locationName:"spec" type:"structure" required:"true"`

	Tags []TagRef `locationName:"tags" type:"list"`

	// VirtualGatewayName is a required field
	VirtualGatewayName *string `locationName:"virtualGatewayName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateVirtualGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVirtualGatewayInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateVirtualGatewayInput"}

	if s.MeshName == nil {
		invalidParams.Add(aws.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("MeshOwner", 12))
	}

	if s.Spec == nil {
		invalidParams.Add(aws.NewErrParamRequired("Spec"))
	}

	if s.VirtualGatewayName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VirtualGatewayName"))
	}
	if s.VirtualGatewayName != nil && len(*s.VirtualGatewayName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VirtualGatewayName", 1))
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateVirtualGatewayInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Spec != nil {
		v := s.Spec

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "spec", v, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "tags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.VirtualGatewayName != nil {
		v := *s.VirtualGatewayName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "virtualGatewayName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MeshName != nil {
		v := *s.MeshName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "meshName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MeshOwner != nil {
		v := *s.MeshOwner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "meshOwner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type CreateVirtualGatewayOutput struct {
	_ struct{} `type:"structure" payload:"VirtualGateway"`

	// An object that represents a virtual gateway returned by a describe operation.
	//
	// VirtualGateway is a required field
	VirtualGateway *VirtualGatewayData `locationName:"virtualGateway" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateVirtualGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateVirtualGatewayOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.VirtualGateway != nil {
		v := s.VirtualGateway

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "virtualGateway", v, metadata)
	}
	return nil
}

const opCreateVirtualGateway = "CreateVirtualGateway"

// CreateVirtualGatewayRequest returns a request value for making API operation for
// AWS App Mesh.
//
// Creates a virtual gateway.
//
// A virtual gateway allows resources outside your mesh to communicate to resources
// that are inside your mesh. The virtual gateway represents an Envoy proxy
// running in an Amazon ECS task, in a Kubernetes service, or on an Amazon EC2
// instance. Unlike a virtual node, which represents an Envoy running with an
// application, a virtual gateway represents Envoy deployed by itself.
//
// For more information about virtual gateways, see Virtual gateways (https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_gateways.html).
//
//    // Example sending a request using CreateVirtualGatewayRequest.
//    req := client.CreateVirtualGatewayRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/CreateVirtualGateway
func (c *Client) CreateVirtualGatewayRequest(input *CreateVirtualGatewayInput) CreateVirtualGatewayRequest {
	op := &aws.Operation{
		Name:       opCreateVirtualGateway,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualGateways",
	}

	if input == nil {
		input = &CreateVirtualGatewayInput{}
	}

	req := c.newRequest(op, input, &CreateVirtualGatewayOutput{})

	return CreateVirtualGatewayRequest{Request: req, Input: input, Copy: c.CreateVirtualGatewayRequest}
}

// CreateVirtualGatewayRequest is the request type for the
// CreateVirtualGateway API operation.
type CreateVirtualGatewayRequest struct {
	*aws.Request
	Input *CreateVirtualGatewayInput
	Copy  func(*CreateVirtualGatewayInput) CreateVirtualGatewayRequest
}

// Send marshals and sends the CreateVirtualGateway API request.
func (r CreateVirtualGatewayRequest) Send(ctx context.Context) (*CreateVirtualGatewayResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateVirtualGatewayResponse{
		CreateVirtualGatewayOutput: r.Request.Data.(*CreateVirtualGatewayOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateVirtualGatewayResponse is the response type for the
// CreateVirtualGateway API operation.
type CreateVirtualGatewayResponse struct {
	*CreateVirtualGatewayOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateVirtualGateway request.
func (r *CreateVirtualGatewayResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
