// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appmesh

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DescribeVirtualRouterInput struct {
	_ struct{} `type:"structure"`

	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// VirtualRouterName is a required field
	VirtualRouterName *string `location:"uri" locationName:"virtualRouterName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeVirtualRouterInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeVirtualRouterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeVirtualRouterInput"}

	if s.MeshName == nil {
		invalidParams.Add(aws.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("MeshOwner", 12))
	}

	if s.VirtualRouterName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VirtualRouterName"))
	}
	if s.VirtualRouterName != nil && len(*s.VirtualRouterName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VirtualRouterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeVirtualRouterInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MeshName != nil {
		v := *s.MeshName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "meshName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VirtualRouterName != nil {
		v := *s.VirtualRouterName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "virtualRouterName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MeshOwner != nil {
		v := *s.MeshOwner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "meshOwner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DescribeVirtualRouterOutput struct {
	_ struct{} `type:"structure" payload:"VirtualRouter"`

	// An object that represents a virtual router returned by a describe operation.
	//
	// VirtualRouter is a required field
	VirtualRouter *VirtualRouterData `locationName:"virtualRouter" type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeVirtualRouterOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeVirtualRouterOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.VirtualRouter != nil {
		v := s.VirtualRouter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "virtualRouter", v, metadata)
	}
	return nil
}

const opDescribeVirtualRouter = "DescribeVirtualRouter"

// DescribeVirtualRouterRequest returns a request value for making API operation for
// AWS App Mesh.
//
// Describes an existing virtual router.
//
//    // Example sending a request using DescribeVirtualRouterRequest.
//    req := client.DescribeVirtualRouterRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/DescribeVirtualRouter
func (c *Client) DescribeVirtualRouterRequest(input *DescribeVirtualRouterInput) DescribeVirtualRouterRequest {
	op := &aws.Operation{
		Name:       opDescribeVirtualRouter,
		HTTPMethod: "GET",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualRouters/{virtualRouterName}",
	}

	if input == nil {
		input = &DescribeVirtualRouterInput{}
	}

	req := c.newRequest(op, input, &DescribeVirtualRouterOutput{})

	return DescribeVirtualRouterRequest{Request: req, Input: input, Copy: c.DescribeVirtualRouterRequest}
}

// DescribeVirtualRouterRequest is the request type for the
// DescribeVirtualRouter API operation.
type DescribeVirtualRouterRequest struct {
	*aws.Request
	Input *DescribeVirtualRouterInput
	Copy  func(*DescribeVirtualRouterInput) DescribeVirtualRouterRequest
}

// Send marshals and sends the DescribeVirtualRouter API request.
func (r DescribeVirtualRouterRequest) Send(ctx context.Context) (*DescribeVirtualRouterResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeVirtualRouterResponse{
		DescribeVirtualRouterOutput: r.Request.Data.(*DescribeVirtualRouterOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeVirtualRouterResponse is the response type for the
// DescribeVirtualRouter API operation.
type DescribeVirtualRouterResponse struct {
	*DescribeVirtualRouterOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeVirtualRouter request.
func (r *DescribeVirtualRouterResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
