// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appmesh

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateGatewayRouteInput struct {
	_ struct{} `type:"structure"`

	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// GatewayRouteName is a required field
	GatewayRouteName *string `location:"uri" locationName:"gatewayRouteName" min:"1" type:"string" required:"true"`

	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// An object that represents a gateway route specification. Specify one gateway
	// route type.
	//
	// Spec is a required field
	Spec *GatewayRouteSpec `locationName:"spec" type:"structure" required:"true"`

	// VirtualGatewayName is a required field
	VirtualGatewayName *string `location:"uri" locationName:"virtualGatewayName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateGatewayRouteInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGatewayRouteInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateGatewayRouteInput"}

	if s.GatewayRouteName == nil {
		invalidParams.Add(aws.NewErrParamRequired("GatewayRouteName"))
	}
	if s.GatewayRouteName != nil && len(*s.GatewayRouteName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("GatewayRouteName", 1))
	}

	if s.MeshName == nil {
		invalidParams.Add(aws.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("MeshOwner", 12))
	}

	if s.Spec == nil {
		invalidParams.Add(aws.NewErrParamRequired("Spec"))
	}

	if s.VirtualGatewayName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VirtualGatewayName"))
	}
	if s.VirtualGatewayName != nil && len(*s.VirtualGatewayName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VirtualGatewayName", 1))
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateGatewayRouteInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Spec != nil {
		v := s.Spec

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "spec", v, metadata)
	}
	if s.GatewayRouteName != nil {
		v := *s.GatewayRouteName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "gatewayRouteName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MeshName != nil {
		v := *s.MeshName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "meshName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VirtualGatewayName != nil {
		v := *s.VirtualGatewayName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "virtualGatewayName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MeshOwner != nil {
		v := *s.MeshOwner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "meshOwner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateGatewayRouteOutput struct {
	_ struct{} `type:"structure" payload:"GatewayRoute"`

	// An object that represents a gateway route returned by a describe operation.
	//
	// GatewayRoute is a required field
	GatewayRoute *GatewayRouteData `locationName:"gatewayRoute" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateGatewayRouteOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateGatewayRouteOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.GatewayRoute != nil {
		v := s.GatewayRoute

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "gatewayRoute", v, metadata)
	}
	return nil
}

const opUpdateGatewayRoute = "UpdateGatewayRoute"

// UpdateGatewayRouteRequest returns a request value for making API operation for
// AWS App Mesh.
//
// Updates an existing gateway route that is associated to a specified virtual
// gateway in a service mesh.
//
//    // Example sending a request using UpdateGatewayRouteRequest.
//    req := client.UpdateGatewayRouteRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateGatewayRoute
func (c *Client) UpdateGatewayRouteRequest(input *UpdateGatewayRouteInput) UpdateGatewayRouteRequest {
	op := &aws.Operation{
		Name:       opUpdateGatewayRoute,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualGateway/{virtualGatewayName}/gatewayRoutes/{gatewayRouteName}",
	}

	if input == nil {
		input = &UpdateGatewayRouteInput{}
	}

	req := c.newRequest(op, input, &UpdateGatewayRouteOutput{})

	return UpdateGatewayRouteRequest{Request: req, Input: input, Copy: c.UpdateGatewayRouteRequest}
}

// UpdateGatewayRouteRequest is the request type for the
// UpdateGatewayRoute API operation.
type UpdateGatewayRouteRequest struct {
	*aws.Request
	Input *UpdateGatewayRouteInput
	Copy  func(*UpdateGatewayRouteInput) UpdateGatewayRouteRequest
}

// Send marshals and sends the UpdateGatewayRoute API request.
func (r UpdateGatewayRouteRequest) Send(ctx context.Context) (*UpdateGatewayRouteResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateGatewayRouteResponse{
		UpdateGatewayRouteOutput: r.Request.Data.(*UpdateGatewayRouteOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateGatewayRouteResponse is the response type for the
// UpdateGatewayRoute API operation.
type UpdateGatewayRouteResponse struct {
	*UpdateGatewayRouteOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateGatewayRoute request.
func (r *UpdateGatewayRouteResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
