// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appmesh

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateVirtualGatewayInput struct {
	_ struct{} `type:"structure"`

	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// MeshName is a required field
	MeshName *string `location:"uri" locationName:"meshName" min:"1" type:"string" required:"true"`

	MeshOwner *string `location:"querystring" locationName:"meshOwner" min:"12" type:"string"`

	// An object that represents the specification of a service mesh resource.
	//
	// Spec is a required field
	Spec *VirtualGatewaySpec `locationName:"spec" type:"structure" required:"true"`

	// VirtualGatewayName is a required field
	VirtualGatewayName *string `location:"uri" locationName:"virtualGatewayName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateVirtualGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVirtualGatewayInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateVirtualGatewayInput"}

	if s.MeshName == nil {
		invalidParams.Add(aws.NewErrParamRequired("MeshName"))
	}
	if s.MeshName != nil && len(*s.MeshName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MeshName", 1))
	}
	if s.MeshOwner != nil && len(*s.MeshOwner) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("MeshOwner", 12))
	}

	if s.Spec == nil {
		invalidParams.Add(aws.NewErrParamRequired("Spec"))
	}

	if s.VirtualGatewayName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VirtualGatewayName"))
	}
	if s.VirtualGatewayName != nil && len(*s.VirtualGatewayName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VirtualGatewayName", 1))
	}
	if s.Spec != nil {
		if err := s.Spec.Validate(); err != nil {
			invalidParams.AddNested("Spec", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateVirtualGatewayInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Spec != nil {
		v := s.Spec

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "spec", v, metadata)
	}
	if s.MeshName != nil {
		v := *s.MeshName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "meshName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VirtualGatewayName != nil {
		v := *s.VirtualGatewayName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "virtualGatewayName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MeshOwner != nil {
		v := *s.MeshOwner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "meshOwner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateVirtualGatewayOutput struct {
	_ struct{} `type:"structure" payload:"VirtualGateway"`

	// An object that represents a virtual gateway returned by a describe operation.
	//
	// VirtualGateway is a required field
	VirtualGateway *VirtualGatewayData `locationName:"virtualGateway" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateVirtualGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateVirtualGatewayOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.VirtualGateway != nil {
		v := s.VirtualGateway

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "virtualGateway", v, metadata)
	}
	return nil
}

const opUpdateVirtualGateway = "UpdateVirtualGateway"

// UpdateVirtualGatewayRequest returns a request value for making API operation for
// AWS App Mesh.
//
// Updates an existing virtual gateway in a specified service mesh.
//
//    // Example sending a request using UpdateVirtualGatewayRequest.
//    req := client.UpdateVirtualGatewayRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/UpdateVirtualGateway
func (c *Client) UpdateVirtualGatewayRequest(input *UpdateVirtualGatewayInput) UpdateVirtualGatewayRequest {
	op := &aws.Operation{
		Name:       opUpdateVirtualGateway,
		HTTPMethod: "PUT",
		HTTPPath:   "/v20190125/meshes/{meshName}/virtualGateways/{virtualGatewayName}",
	}

	if input == nil {
		input = &UpdateVirtualGatewayInput{}
	}

	req := c.newRequest(op, input, &UpdateVirtualGatewayOutput{})

	return UpdateVirtualGatewayRequest{Request: req, Input: input, Copy: c.UpdateVirtualGatewayRequest}
}

// UpdateVirtualGatewayRequest is the request type for the
// UpdateVirtualGateway API operation.
type UpdateVirtualGatewayRequest struct {
	*aws.Request
	Input *UpdateVirtualGatewayInput
	Copy  func(*UpdateVirtualGatewayInput) UpdateVirtualGatewayRequest
}

// Send marshals and sends the UpdateVirtualGateway API request.
func (r UpdateVirtualGatewayRequest) Send(ctx context.Context) (*UpdateVirtualGatewayResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateVirtualGatewayResponse{
		UpdateVirtualGatewayOutput: r.Request.Data.(*UpdateVirtualGatewayOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateVirtualGatewayResponse is the response type for the
// UpdateVirtualGateway API operation.
type UpdateVirtualGatewayResponse struct {
	*UpdateVirtualGatewayOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateVirtualGateway request.
func (r *UpdateVirtualGatewayResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
