// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appstream

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CopyImageInput struct {
	_ struct{} `type:"structure"`

	// The description that the image will have when it is copied to the destination.
	DestinationImageDescription *string `type:"string"`

	// The name that the image will have when it is copied to the destination.
	//
	// DestinationImageName is a required field
	DestinationImageName *string `type:"string" required:"true"`

	// The destination region to which the image will be copied. This parameter
	// is required, even if you are copying an image within the same region.
	//
	// DestinationRegion is a required field
	DestinationRegion *string `min:"1" type:"string" required:"true"`

	// The name of the image to copy.
	//
	// SourceImageName is a required field
	SourceImageName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CopyImageInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyImageInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CopyImageInput"}

	if s.DestinationImageName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DestinationImageName"))
	}

	if s.DestinationRegion == nil {
		invalidParams.Add(aws.NewErrParamRequired("DestinationRegion"))
	}
	if s.DestinationRegion != nil && len(*s.DestinationRegion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DestinationRegion", 1))
	}

	if s.SourceImageName == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceImageName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CopyImageOutput struct {
	_ struct{} `type:"structure"`

	// The name of the destination image.
	DestinationImageName *string `type:"string"`
}

// String returns the string representation
func (s CopyImageOutput) String() string {
	return awsutil.Prettify(s)
}

const opCopyImage = "CopyImage"

// CopyImageRequest returns a request value for making API operation for
// Amazon AppStream.
//
// Copies the image within the same region or to a new region within the same
// AWS account. Note that any tags you added to the image will not be copied.
//
//    // Example sending a request using CopyImageRequest.
//    req := client.CopyImageRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CopyImage
func (c *Client) CopyImageRequest(input *CopyImageInput) CopyImageRequest {
	op := &aws.Operation{
		Name:       opCopyImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyImageInput{}
	}

	req := c.newRequest(op, input, &CopyImageOutput{})

	return CopyImageRequest{Request: req, Input: input, Copy: c.CopyImageRequest}
}

// CopyImageRequest is the request type for the
// CopyImage API operation.
type CopyImageRequest struct {
	*aws.Request
	Input *CopyImageInput
	Copy  func(*CopyImageInput) CopyImageRequest
}

// Send marshals and sends the CopyImage API request.
func (r CopyImageRequest) Send(ctx context.Context) (*CopyImageResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CopyImageResponse{
		CopyImageOutput: r.Request.Data.(*CopyImageOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CopyImageResponse is the response type for the
// CopyImage API operation.
type CopyImageResponse struct {
	*CopyImageOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CopyImage request.
func (r *CopyImageResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
