// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appsync

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetFunctionInput struct {
	_ struct{} `type:"structure"`

	// The GraphQL API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// The Function ID.
	//
	// FunctionId is a required field
	FunctionId *string `location:"uri" locationName:"functionId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFunctionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetFunctionInput"}

	if s.ApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApiId"))
	}

	if s.FunctionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionId"))
	}
	if s.FunctionId != nil && len(*s.FunctionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FunctionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetFunctionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FunctionId != nil {
		v := *s.FunctionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "functionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetFunctionOutput struct {
	_ struct{} `type:"structure"`

	// The Function object.
	FunctionConfiguration *FunctionConfiguration `locationName:"functionConfiguration" type:"structure"`
}

// String returns the string representation
func (s GetFunctionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetFunctionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.FunctionConfiguration != nil {
		v := s.FunctionConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "functionConfiguration", v, metadata)
	}
	return nil
}

const opGetFunction = "GetFunction"

// GetFunctionRequest returns a request value for making API operation for
// AWS AppSync.
//
// Get a Function.
//
//    // Example sending a request using GetFunctionRequest.
//    req := client.GetFunctionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetFunction
func (c *Client) GetFunctionRequest(input *GetFunctionInput) GetFunctionRequest {
	op := &aws.Operation{
		Name:       opGetFunction,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apis/{apiId}/functions/{functionId}",
	}

	if input == nil {
		input = &GetFunctionInput{}
	}

	req := c.newRequest(op, input, &GetFunctionOutput{})

	return GetFunctionRequest{Request: req, Input: input, Copy: c.GetFunctionRequest}
}

// GetFunctionRequest is the request type for the
// GetFunction API operation.
type GetFunctionRequest struct {
	*aws.Request
	Input *GetFunctionInput
	Copy  func(*GetFunctionInput) GetFunctionRequest
}

// Send marshals and sends the GetFunction API request.
func (r GetFunctionRequest) Send(ctx context.Context) (*GetFunctionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetFunctionResponse{
		GetFunctionOutput: r.Request.Data.(*GetFunctionOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetFunctionResponse is the response type for the
// GetFunction API operation.
type GetFunctionResponse struct {
	*GetFunctionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetFunction request.
func (r *GetFunctionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
