// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package athena

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteNamedQueryInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the query to delete.
	//
	// NamedQueryId is a required field
	NamedQueryId *string `type:"string" required:"true" idempotencyToken:"true"`
}

// String returns the string representation
func (s DeleteNamedQueryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNamedQueryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteNamedQueryInput"}

	if s.NamedQueryId == nil {
		invalidParams.Add(aws.NewErrParamRequired("NamedQueryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteNamedQueryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteNamedQueryOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteNamedQuery = "DeleteNamedQuery"

// DeleteNamedQueryRequest returns a request value for making API operation for
// Amazon Athena.
//
// Deletes the named query if you have access to the workgroup in which the
// query was saved.
//
// For code samples using the AWS SDK for Java, see Examples and Code Samples
// (http://docs.aws.amazon.com/athena/latest/ug/code-samples.html) in the Amazon
// Athena User Guide.
//
//    // Example sending a request using DeleteNamedQueryRequest.
//    req := client.DeleteNamedQueryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/DeleteNamedQuery
func (c *Client) DeleteNamedQueryRequest(input *DeleteNamedQueryInput) DeleteNamedQueryRequest {
	op := &aws.Operation{
		Name:       opDeleteNamedQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNamedQueryInput{}
	}

	req := c.newRequest(op, input, &DeleteNamedQueryOutput{})

	return DeleteNamedQueryRequest{Request: req, Input: input, Copy: c.DeleteNamedQueryRequest}
}

// DeleteNamedQueryRequest is the request type for the
// DeleteNamedQuery API operation.
type DeleteNamedQueryRequest struct {
	*aws.Request
	Input *DeleteNamedQueryInput
	Copy  func(*DeleteNamedQueryInput) DeleteNamedQueryRequest
}

// Send marshals and sends the DeleteNamedQuery API request.
func (r DeleteNamedQueryRequest) Send(ctx context.Context) (*DeleteNamedQueryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteNamedQueryResponse{
		DeleteNamedQueryOutput: r.Request.Data.(*DeleteNamedQueryOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteNamedQueryResponse is the response type for the
// DeleteNamedQuery API operation.
type DeleteNamedQueryResponse struct {
	*DeleteNamedQueryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteNamedQuery request.
func (r *DeleteNamedQueryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
